/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.util;

import java.util.concurrent.atomic.AtomicLong;
import org.hibernate.search.batchindexing.MassIndexerProgressMonitor;
import org.hibernate.search.impl.SimpleIndexingProgressMonitor;
import org.junit.Assert;

public class AssertingMassIndexerProgressMonitor
implements MassIndexerProgressMonitor {
    private final MassIndexerProgressMonitor monitor;
    private final AtomicLong totalCount = new AtomicLong();
    private final AtomicLong finishedCount = new AtomicLong();
    private final AtomicLong addedDocuments = new AtomicLong();
    private final int expectedAddedDocuments;
    private final int expectedTotalCount;

    public AssertingMassIndexerProgressMonitor(int expectedAddedDocuments, int expectedTotalCount) {
        this.expectedAddedDocuments = expectedAddedDocuments;
        this.expectedTotalCount = expectedTotalCount;
        this.monitor = new SimpleIndexingProgressMonitor(1);
    }

    public void documentsAdded(long increment) {
        this.addedDocuments.addAndGet(increment);
        this.monitor.documentsAdded(increment);
    }

    public void documentsBuilt(int number) {
        this.monitor.documentsBuilt(number);
    }

    public void entitiesLoaded(int size) {
        this.monitor.entitiesLoaded(size);
    }

    public void addToTotalCount(long count) {
        this.totalCount.addAndGet(count);
        this.monitor.addToTotalCount(count);
    }

    public void indexingCompleted() {
        this.finishedCount.incrementAndGet();
    }

    public void assertExpectedProgressMade() {
        Assert.assertEquals((String)"Unexpected number of added documents", (long)this.expectedAddedDocuments, (long)this.addedDocuments.get());
        Assert.assertEquals((String)"Unexpected total count", (long)this.expectedTotalCount, (long)this.totalCount.get());
        Assert.assertEquals((String)"Finished called more than once", (long)1L, (long)this.finishedCount.get());
    }
}

