/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.filters;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import junit.framework.Assert;
import org.apache.lucene.index.AtomicReader;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.search.BitsFilteredDocIdSet;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.OpenBitSet;
import org.hibernate.search.annotations.DocumentId;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.backend.TransactionContext;
import org.hibernate.search.backend.spi.Work;
import org.hibernate.search.backend.spi.WorkType;
import org.hibernate.search.engine.spi.SearchFactoryImplementor;
import org.hibernate.search.query.dsl.QueryBuilder;
import org.hibernate.search.query.engine.spi.EntityInfo;
import org.hibernate.search.reader.impl.ManagedMultiReader;
import org.hibernate.search.reader.impl.ReaderProviderHelper;
import org.hibernate.search.test.util.ManualTransactionContext;
import org.hibernate.search.test.util.SearchFactoryHolder;
import org.hibernate.search.test.util.TestForIssue;
import org.junit.Rule;
import org.junit.Test;

@TestForIssue(jiraKey="HSEARCH-1230")
public class FreshReadersProvidedTest {
    @Rule
    public SearchFactoryHolder sfHolder = new SearchFactoryHolder(Guest.class);

    @Test
    public void filtersTest() {
        SearchFactoryImplementor searchFactory = this.sfHolder.getSearchFactory();
        Assert.assertNotNull((Object)searchFactory.getIndexManagerHolder().getIndexManager("guests"));
        Guest lastDwarf = new Guest();
        lastDwarf.id = 13L;
        lastDwarf.name = "Thorin Oakenshield";
        Work work = new Work((Object)lastDwarf, (Serializable)Long.valueOf(lastDwarf.id), WorkType.ADD, false);
        ManualTransactionContext tc = new ManualTransactionContext();
        searchFactory.getWorker().performWork(work, (TransactionContext)tc);
        tc.end();
        QueryBuilder guestQueryBuilder = searchFactory.buildQueryBuilder().forEntity(Guest.class).get();
        Query queryAllGuests = guestQueryBuilder.all().createQuery();
        List queryEntityInfos = searchFactory.createHSQuery().luceneQuery(queryAllGuests).targetedEntities(Arrays.asList(Guest.class)).queryEntityInfos();
        Assert.assertEquals((int)1, (int)queryEntityInfos.size());
        Assert.assertEquals((Object)13L, (Object)((EntityInfo)queryEntityInfos.get(0)).getId());
        RecordingFilter filter = new RecordingFilter("name");
        List filteredQueryEntityInfos = searchFactory.createHSQuery().luceneQuery(queryAllGuests).targetedEntities(Arrays.asList(Guest.class)).filter((Filter)filter).queryEntityInfos();
        this.checkFilterInspectedAllSegments(filter);
        this.expectedTermsForFilter(filter, "thorin", "oakenshield");
        Assert.assertEquals((int)1, (int)filteredQueryEntityInfos.size());
        Assert.assertEquals((Object)13L, (Object)((EntityInfo)filteredQueryEntityInfos.get(0)).getId());
        Guest balin = new Guest();
        balin.id = 7L;
        balin.name = "Balin";
        Work work2 = new Work((Object)balin, (Serializable)Long.valueOf(balin.id), WorkType.ADD, false);
        ManualTransactionContext tc2 = new ManualTransactionContext();
        searchFactory.getWorker().performWork(work2, (TransactionContext)tc2);
        tc2.end();
        List queryEntityInfosAgain = searchFactory.createHSQuery().luceneQuery(queryAllGuests).targetedEntities(Arrays.asList(Guest.class)).queryEntityInfos();
        Assert.assertEquals((int)2, (int)queryEntityInfosAgain.size());
        Assert.assertEquals((Object)13L, (Object)((EntityInfo)queryEntityInfosAgain.get(0)).getId());
        Assert.assertEquals((Object)7L, (Object)((EntityInfo)queryEntityInfosAgain.get(1)).getId());
        RecordingFilter secondFilter = new RecordingFilter("name");
        List secondFilteredQueryEntityInfos = searchFactory.createHSQuery().luceneQuery(queryAllGuests).targetedEntities(Arrays.asList(Guest.class)).filter((Filter)secondFilter).queryEntityInfos();
        this.checkFilterInspectedAllSegments(secondFilter);
        this.expectedTermsForFilter(secondFilter, "thorin", "oakenshield", "balin");
        Assert.assertEquals((int)2, (int)secondFilteredQueryEntityInfos.size());
        Assert.assertEquals((Object)13L, (Object)((EntityInfo)secondFilteredQueryEntityInfos.get(0)).getId());
        Assert.assertEquals((Object)7L, (Object)((EntityInfo)secondFilteredQueryEntityInfos.get(1)).getId());
    }

    private void expectedTermsForFilter(RecordingFilter filter, String ... term) {
        Assert.assertEquals((int)term.length, (int)filter.seenTerms.size());
        Assert.assertTrue((boolean)filter.seenTerms.containsAll(Arrays.asList(term)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkFilterInspectedAllSegments(RecordingFilter filter) {
        SearchFactoryImplementor searchFactory = this.sfHolder.getSearchFactory();
        IndexReader currentIndexReader = searchFactory.getIndexReaderAccessor().open(new Class[]{Guest.class});
        try {
            List allSubReaders = ReaderProviderHelper.getSubIndexReaders((ManagedMultiReader)((ManagedMultiReader)currentIndexReader));
            for (IndexReader ir : allSubReaders) {
                Assert.assertTrue((boolean)filter.visitedReaders.contains(ir));
            }
            for (IndexReader ir : filter.visitedReaders) {
                Assert.assertTrue((boolean)allSubReaders.contains(ir));
            }
        }
        finally {
            searchFactory.getIndexReaderAccessor().close(currentIndexReader);
        }
    }

    @Indexed(index="guests")
    public static final class Guest {
        private long id;
        private String name;

        @DocumentId
        public long getId() {
            return this.id;
        }

        public void setId(long id) {
            this.id = id;
        }

        @Field
        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }
    }

    private static class RecordingFilter
    extends Filter {
        final List<IndexReader> visitedReaders = new ArrayList<IndexReader>();
        final List<String> seenTerms = new ArrayList<String>();
        final String fieldName;

        public RecordingFilter(String fieldName) {
            this.fieldName = fieldName;
        }

        public DocIdSet getDocIdSet(AtomicReaderContext context, Bits acceptDocs) throws IOException {
            AtomicReader reader = context.reader();
            this.visitedReaders.add((IndexReader)reader);
            OpenBitSet bitSet = new OpenBitSet((long)reader.maxDoc());
            for (int i = 0; i < reader.maxDoc(); ++i) {
                bitSet.fastSet(i);
            }
            Terms terms = reader.terms(this.fieldName);
            TermsEnum iterator = terms.iterator(null);
            BytesRef next = iterator.next();
            while (next != null) {
                this.seenTerms.add(next.utf8ToString());
                next = iterator.next();
            }
            return BitsFilteredDocIdSet.wrap((DocIdSet)bitSet, (Bits)acceptDocs);
        }
    }
}

