/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.util;

import java.io.IOException;
import junit.framework.Assert;
import org.apache.lucene.document.DocumentStoredFieldVisitor;
import org.apache.lucene.index.AtomicReader;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FilterAtomicReader;
import org.apache.lucene.index.FilterDirectoryReader;
import org.apache.lucene.index.StoredFieldVisitor;
import org.hibernate.search.indexes.impl.NotSharedReaderProvider;
import org.hibernate.search.indexes.spi.ReaderProvider;
import org.hibernate.search.query.engine.impl.ReusableDocumentStoredFieldVisitor;

public final class FieldSelectorLeakingReaderProvider
extends NotSharedReaderProvider
implements ReaderProvider {
    private static volatile StoredFieldVisitor fieldSelector;

    public static void resetFieldSelector() {
        fieldSelector = null;
    }

    public static void assertFieldSelectorEnabled(String ... expectedFieldNames) throws IOException {
        if (expectedFieldNames == null || expectedFieldNames.length == 0) {
            FieldSelectorLeakingReaderProvider.assertFieldSelectorDisabled();
        } else {
            Assert.assertNotNull((Object)fieldSelector);
            Assert.assertTrue((boolean)(fieldSelector instanceof ReusableDocumentStoredFieldVisitor));
            ReusableDocumentStoredFieldVisitor visitor = (ReusableDocumentStoredFieldVisitor)fieldSelector;
            Assert.assertEquals((int)expectedFieldNames.length, (int)visitor.countAcceptedFields());
            for (String fieldName : expectedFieldNames) {
                FieldInfo fieldId = FieldSelectorLeakingReaderProvider.forgeFieldInfo(fieldName);
                Assert.assertEquals((Object)StoredFieldVisitor.Status.YES, (Object)visitor.needsField(fieldId));
            }
        }
    }

    private static FieldInfo forgeFieldInfo(String fieldName) {
        return new FieldInfo(fieldName, true, 0, false, true, false, FieldInfo.IndexOptions.DOCS_ONLY, FieldInfo.DocValuesType.SORTED, FieldInfo.DocValuesType.SORTED, null);
    }

    public static void assertFieldSelectorDisabled() {
        StoredFieldVisitor fieldVisitor = fieldSelector;
        Assert.assertTrue((fieldVisitor == null || fieldVisitor instanceof DocumentStoredFieldVisitor ? 1 : 0) != 0);
    }

    public DirectoryReader openIndexReader() {
        DirectoryReader originalReader = super.openIndexReader();
        LeakingDirectoryReader wrappedReader = new LeakingDirectoryReader(originalReader);
        return wrappedReader;
    }

    private final class LeakingAtomicReader
    extends FilterAtomicReader {
        public LeakingAtomicReader(AtomicReader in) {
            super(in);
        }

        public void document(int docID, StoredFieldVisitor visitor) throws IOException {
            super.document(docID, visitor);
            fieldSelector = visitor;
        }
    }

    private final class LeakingSubReaderWrapper
    extends FilterDirectoryReader.SubReaderWrapper {
        private LeakingSubReaderWrapper() {
        }

        public AtomicReader wrap(AtomicReader reader) {
            return new LeakingAtomicReader(reader);
        }
    }

    private final class LeakingDirectoryReader
    extends FilterDirectoryReader {
        public LeakingDirectoryReader(DirectoryReader in) {
            super(in, (FilterDirectoryReader.SubReaderWrapper)new LeakingSubReaderWrapper());
        }

        protected DirectoryReader doWrapDirectoryReader(DirectoryReader in) {
            return new LeakingDirectoryReader(in);
        }
    }
}

