/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.util;

import java.util.Properties;
import org.apache.lucene.search.similarities.DefaultSimilarity;
import org.apache.lucene.search.similarities.Similarity;
import org.hibernate.search.engine.service.spi.Service;
import org.hibernate.search.engine.service.spi.ServiceManager;
import org.hibernate.search.engine.spi.SearchFactoryImplementor;
import org.hibernate.search.exception.ErrorHandler;
import org.hibernate.search.exception.impl.LogErrorHandler;
import org.hibernate.search.impl.SimpleInitializer;
import org.hibernate.search.indexes.impl.DirectoryBasedIndexManager;
import org.hibernate.search.indexes.impl.IndexManagerHolder;
import org.hibernate.search.spi.InstanceInitializer;
import org.hibernate.search.spi.WorkerBuildContext;

public class RamIndexManager
extends DirectoryBasedIndexManager {
    private static final LogErrorHandler logErrorHandler = new LogErrorHandler();

    public static RamIndexManager makeRamDirectory() {
        RamIndexManager ramIndexManager = new RamIndexManager();
        Properties properties = new Properties();
        properties.setProperty("directory_provider", "ram");
        ramIndexManager.initialize("testIndex", properties, (Similarity)new DefaultSimilarity(), new EmptyWorkerBuildContext());
        return ramIndexManager;
    }

    private static class EmptyWorkerBuildContext
    implements WorkerBuildContext {
        private EmptyWorkerBuildContext() {
        }

        public SearchFactoryImplementor getUninitializedSearchFactory() {
            return null;
        }

        public String getIndexingStrategy() {
            return null;
        }

        public IndexManagerHolder getAllIndexesManager() {
            return null;
        }

        public ErrorHandler getErrorHandler() {
            return logErrorHandler;
        }

        public boolean isTransactionManagerExpected() {
            return false;
        }

        public InstanceInitializer getInstanceInitializer() {
            return SimpleInitializer.INSTANCE;
        }

        public boolean isIndexMetadataComplete() {
            return true;
        }

        public ServiceManager getServiceManager() {
            return new ServiceManager(){

                public <S extends Service> S requestService(Class<S> serviceRole) {
                    return null;
                }

                public <S extends Service> void releaseService(Class<S> serviceRole) {
                }

                public void releaseAllServices() {
                }
            };
        }
    }
}

