/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.util;

import java.util.Properties;
import junit.framework.Assert;
import org.hibernate.search.cfg.SearchMapping;
import org.hibernate.search.cfg.spi.SearchConfiguration;
import org.hibernate.search.engine.spi.SearchFactoryImplementor;
import org.hibernate.search.spi.SearchFactoryBuilder;
import org.hibernate.search.test.util.ManualConfiguration;
import org.junit.rules.ExternalResource;

public class SearchFactoryHolder
extends ExternalResource {
    private final SearchMapping buildMappingDefinition;
    private final Class<?>[] entities;
    private final Properties configuration;
    private SearchFactoryImplementor sf;

    public SearchFactoryHolder(Class<?> ... entities) {
        this((SearchMapping)null, entities);
    }

    public SearchFactoryHolder(SearchMapping buildMappingDefinition, Class<?> ... entities) {
        this.buildMappingDefinition = buildMappingDefinition;
        this.entities = entities;
        this.configuration = new Properties();
        this.configuration.setProperty("hibernate.search.default.directory_provider", "ram");
        this.configuration.setProperty("hibernate.search.lucene_version", "LUCENE_CURRENT");
    }

    public SearchFactoryImplementor getSearchFactory() {
        return this.sf;
    }

    protected void before() throws Throwable {
        ManualConfiguration cfg = new ManualConfiguration();
        cfg.setProgrammaticMapping(this.buildMappingDefinition);
        for (String key : this.configuration.stringPropertyNames()) {
            cfg.addProperty(key, this.configuration.getProperty(key));
        }
        for (Class<?> c : this.entities) {
            cfg.addClass(c);
        }
        this.sf = new SearchFactoryBuilder().configuration((SearchConfiguration)cfg).buildSearchFactory();
    }

    protected void after() {
        this.sf.close();
    }

    public SearchFactoryHolder withProperty(String key, Object value) {
        Assert.assertNull((String)"SessionFactory already initialized", (Object)this.sf);
        this.configuration.put(key, value);
        return this;
    }
}

