/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.util.impl;

import junit.framework.Assert;
import org.hibernate.search.SearchException;
import org.hibernate.search.util.impl.FileHelper;
import org.junit.Test;

public class ResourceLoadingTest {
    @Test
    public void testOpenKnownResource() throws Exception {
        String resource = "log4j.properties";
        String resourceContent = FileHelper.readResourceAsString((String)resource, (ClassLoader)ResourceLoadingTest.class.getClassLoader());
        Assert.assertNotNull((Object)resourceContent);
        Assert.assertFalse((boolean)resourceContent.isEmpty());
    }

    @Test
    public void testUnKnownResource() throws Exception {
        String resource = "foo";
        try {
            FileHelper.readResourceAsString((String)resource, (ClassLoader)ResourceLoadingTest.class.getClassLoader());
        }
        catch (SearchException e) {
            Assert.assertEquals((String)"Wrong error message", (String)"HSEARCH000114: Could not load resource: 'foo'", (String)e.getMessage());
        }
    }
}

