/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.util.leakdetection;

import java.io.IOException;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.RAMDirectory;

public class FileMonitoringDirectory
extends RAMDirectory {
    private final ConcurrentMap<IndexOutput, IndexOutput> openOutputs = new ConcurrentHashMap<IndexOutput, IndexOutput>(10);
    private final ConcurrentMap<IndexInput, IndexInput> openInputs = new ConcurrentHashMap<IndexInput, IndexInput>(40);

    public IndexOutput createOutput(String name, IOContext context) throws IOException {
        IndexOutput indexOutput = super.createOutput(name, context);
        IndexOutputDelegate tracked = new IndexOutputDelegate(indexOutput);
        this.openOutputs.put(tracked, tracked);
        return tracked;
    }

    public IndexInput openInput(String name, IOContext context) throws IOException {
        IndexInput openInput = super.openInput(name, context);
        IndexInputDelegate tracked = new IndexInputDelegate(openInput);
        this.openInputs.put(tracked, tracked);
        return tracked;
    }

    public boolean isClosed() {
        return !this.isOpen;
    }

    public boolean allFilesWereClosed() {
        return this.openInputs.isEmpty() && this.openOutputs.isEmpty();
    }

    private class IndexInputDelegate
    extends IndexInput {
        private final IndexInput delegate;

        public IndexInputDelegate(IndexInput delegate) {
            super(delegate.toString());
            this.delegate = delegate;
        }

        public void close() throws IOException {
            this.delegate.close();
            FileMonitoringDirectory.this.openInputs.remove((Object)this);
        }

        public String toString() {
            return "IndexInputDelegate to " + this.delegate.toString();
        }

        public byte readByte() throws IOException {
            return this.delegate.readByte();
        }

        public void readBytes(byte[] b, int offset, int len) throws IOException {
            this.delegate.readBytes(b, offset, len);
        }

        public void readBytes(byte[] b, int offset, int len, boolean useBuffer) throws IOException {
            this.delegate.readBytes(b, offset, len, useBuffer);
        }

        public long getFilePointer() {
            return this.delegate.getFilePointer();
        }

        public void seek(long pos) throws IOException {
            this.delegate.seek(pos);
        }

        public long length() {
            return this.delegate.length();
        }

        public short readShort() throws IOException {
            return this.delegate.readShort();
        }

        public int readInt() throws IOException {
            return this.delegate.readInt();
        }

        public int readVInt() throws IOException {
            return this.delegate.readVInt();
        }

        public long readLong() throws IOException {
            return this.delegate.readLong();
        }

        public long readVLong() throws IOException {
            return this.delegate.readVLong();
        }

        public String readString() throws IOException {
            return this.delegate.readString();
        }

        public Map<String, String> readStringStringMap() throws IOException {
            return this.delegate.readStringStringMap();
        }

        public Set<String> readStringSet() throws IOException {
            return this.delegate.readStringSet();
        }
    }

    private class IndexOutputDelegate
    extends IndexOutput {
        private final IndexOutput delegate;

        public IndexOutputDelegate(IndexOutput delegate) {
            this.delegate = delegate;
        }

        public String toString() {
            return "IndexOutputDelegate to " + this.delegate.toString();
        }

        public void close() throws IOException {
            this.delegate.close();
            FileMonitoringDirectory.this.openOutputs.remove((Object)this);
        }

        public void writeByte(byte b) throws IOException {
            this.delegate.writeByte(b);
        }

        public void flush() throws IOException {
            this.delegate.flush();
        }

        public void writeBytes(byte[] b, int length) throws IOException {
            this.delegate.writeBytes(b, length);
        }

        public long getFilePointer() {
            return this.delegate.getFilePointer();
        }

        public void writeBytes(byte[] b, int offset, int length) throws IOException {
            this.delegate.writeBytes(b, offset, length);
        }

        public void seek(long pos) throws IOException {
            this.delegate.seek(pos);
        }

        public long length() throws IOException {
            return this.delegate.length();
        }

        public void setLength(long length) throws IOException {
            this.delegate.setLength(length);
        }

        public void writeInt(int i) throws IOException {
            this.delegate.writeInt(i);
        }

        public void writeShort(short i) throws IOException {
            this.delegate.writeShort(i);
        }

        public void writeLong(long i) throws IOException {
            this.delegate.writeLong(i);
        }

        public void writeString(String s) throws IOException {
            this.delegate.writeString(s);
        }

        public void copyBytes(DataInput input, long numBytes) throws IOException {
            this.delegate.copyBytes(input, numBytes);
        }

        public void writeStringStringMap(Map<String, String> map) throws IOException {
            this.delegate.writeStringStringMap(map);
        }

        public void writeStringSet(Set<String> set) throws IOException {
            this.delegate.writeStringSet(set);
        }
    }
}

