/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.query.dsl.impl;

import org.apache.lucene.search.Query;
import org.hibernate.search.bridge.FieldBridge;
import org.hibernate.search.engine.spi.DocumentBuilderIndexedEntity;
import org.hibernate.search.query.dsl.SpatialTermination;
import org.hibernate.search.query.dsl.impl.ConnectedQueryBuilder;
import org.hibernate.search.query.dsl.impl.Helper;
import org.hibernate.search.query.dsl.impl.QueryBuildingContext;
import org.hibernate.search.query.dsl.impl.QueryCustomizer;
import org.hibernate.search.query.dsl.impl.SpatialQueryContext;
import org.hibernate.search.spatial.SpatialFieldBridgeByHash;
import org.hibernate.search.spatial.SpatialFieldBridgeByRange;
import org.hibernate.search.spatial.impl.SpatialQueryBuilderFromCoordinates;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class ConnectedSpatialQueryBuilder
implements SpatialTermination {
    private static final Log LOG = LoggerFactory.make();
    private final SpatialQueryContext spatialContext;
    private final QueryCustomizer queryCustomizer;
    private final QueryBuildingContext queryContext;
    private final ConnectedQueryBuilder queryBuilder;

    public ConnectedSpatialQueryBuilder(SpatialQueryContext spatialContext, QueryCustomizer queryCustomizer, QueryBuildingContext queryContext, ConnectedQueryBuilder queryBuilder) {
        this.spatialContext = spatialContext;
        this.queryCustomizer = queryCustomizer;
        this.queryContext = queryContext;
        this.queryBuilder = queryBuilder;
    }

    @Override
    public Query createQuery() {
        return this.queryCustomizer.setWrappedQuery(this.createSpatialQuery()).createQuery();
    }

    private Query createSpatialQuery() {
        String coordinatesField;
        DocumentBuilderIndexedEntity<?> documentBuilder = Helper.getDocumentBuilder(this.queryContext);
        FieldBridge fieldBridge = documentBuilder.getBridge(coordinatesField = this.spatialContext.getCoordinatesField());
        if (fieldBridge instanceof SpatialFieldBridgeByHash) {
            return SpatialQueryBuilderFromCoordinates.buildSpatialQueryByHash(this.spatialContext.getCoordinates(), this.spatialContext.getRadiusDistance(), coordinatesField);
        }
        if (fieldBridge instanceof SpatialFieldBridgeByRange) {
            return SpatialQueryBuilderFromCoordinates.buildSpatialQueryByRange(this.spatialContext.getCoordinates(), this.spatialContext.getRadiusDistance(), coordinatesField);
        }
        throw LOG.targetedFieldNotSpatial(this.queryContext.getEntityType().getName(), coordinatesField);
    }
}

