/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.util.impl;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.util.Version;
import org.hibernate.search.SearchException;

public class ClassLoaderHelper {
    private ClassLoaderHelper() {
    }

    public static Enumeration<URL> getResources(String resourceName, Class<?> caller) {
        if (resourceName == null) {
            throw new SearchException("Null resource name!");
        }
        if (caller == null) {
            throw new SearchException("Null caller!");
        }
        HashSet<URL> urls = new HashSet<URL>();
        ClassLoaderHelper.getResources(resourceName, Thread.currentThread().getContextClassLoader(), urls);
        ClassLoaderHelper.getResources(resourceName, caller.getClassLoader(), urls);
        return Collections.enumeration(urls);
    }

    private static void getResources(String resourceName, ClassLoader cl, Set<URL> urls) {
        if (cl == null) {
            return;
        }
        try {
            Enumeration<URL> e = cl.getResources(resourceName);
            urls.addAll(Collections.list(e));
        }
        catch (IOException ioe) {
            throw new SearchException("Unable to load resource " + resourceName, ioe);
        }
    }

    @Deprecated
    public static <T> T instanceFromName(Class<T> targetSuperType, String classNameToLoad, Class<?> caller, String componentDescription) {
        return ClassLoaderHelper.instanceFromName(targetSuperType, classNameToLoad, caller.getClassLoader(), componentDescription);
    }

    public static <T> T instanceFromName(Class<T> targetSuperType, String classNameToLoad, ClassLoader fallbackClassLoader, String componentDescription) {
        Class<?> clazzDef = ClassLoaderHelper.classForName(classNameToLoad, fallbackClassLoader, componentDescription);
        return ClassLoaderHelper.instanceFromClass(targetSuperType, clazzDef, componentDescription);
    }

    public static <T> T instanceFromClass(Class<T> targetSuperType, Class<?> classToLoad, String componentDescription) {
        Object instance;
        ClassLoaderHelper.checkClassType(classToLoad, componentDescription);
        ClassLoaderHelper.checkHasNoArgConstructor(classToLoad, componentDescription);
        try {
            instance = classToLoad.newInstance();
        }
        catch (IllegalAccessException e) {
            throw new SearchException("Unable to instantiate " + componentDescription + " class: " + classToLoad.getName() + ". Class or constructor is not accessible.", e);
        }
        catch (InstantiationException e) {
            throw new SearchException("Unable to instantiate " + componentDescription + " class: " + classToLoad.getName() + ". Verify it has a no-args public constructor and is not abstract.", e);
        }
        return ClassLoaderHelper.verifySuperTypeCompatibility(targetSuperType, instance, classToLoad, componentDescription);
    }

    private static <T> T verifySuperTypeCompatibility(Class<T> targetSuperType, Object instance, Class<?> classToLoad, String componentDescription) {
        if (!targetSuperType.isInstance(instance)) {
            if (targetSuperType.isInterface()) {
                throw new SearchException("Wrong configuration of " + componentDescription + ": class " + classToLoad.getName() + " does not implement interface " + targetSuperType.getName());
            }
            throw new SearchException("Wrong configuration of " + componentDescription + ": class " + classToLoad.getName() + " is not a subtype of " + targetSuperType.getName());
        }
        return (T)instance;
    }

    public static <T> T instanceFromClass(Class<T> targetSuperType, Class<?> classToLoad, String componentDescription, Map<String, String> constructorParameter) {
        Object instance;
        ClassLoaderHelper.checkClassType(classToLoad, componentDescription);
        Constructor<?> singleMapConstructor = ClassLoaderHelper.getSingleMapConstructor(classToLoad, componentDescription);
        if (constructorParameter == null) {
            constructorParameter = new HashMap<String, String>(0);
        }
        try {
            instance = singleMapConstructor.newInstance(constructorParameter);
        }
        catch (Exception e) {
            throw new SearchException("Unable to instantiate " + componentDescription + " class: " + classToLoad.getName() + ". The implementation class did not recognize the applied parameters.", e);
        }
        return ClassLoaderHelper.verifySuperTypeCompatibility(targetSuperType, instance, classToLoad, componentDescription);
    }

    public static Analyzer analyzerInstanceFromClass(Class<?> classToInstantiate, Version luceneMatchVersion) {
        Analyzer analyzerInstance;
        Constructor<?> constructor;
        ClassLoaderHelper.checkClassType(classToInstantiate, "analyzer");
        boolean useVersionParameter = true;
        try {
            constructor = classToInstantiate.getConstructor(Version.class);
        }
        catch (NoSuchMethodException e) {
            try {
                constructor = classToInstantiate.getConstructor(new Class[0]);
                useVersionParameter = false;
            }
            catch (NoSuchMethodException nsme) {
                StringBuilder msg = new StringBuilder("Unable to instantiate analyzer class: ");
                msg.append(classToInstantiate.getName());
                msg.append(". Class neither has a default constructor nor a constructor with a Version parameter");
                throw new SearchException(msg.toString(), e);
            }
        }
        try {
            analyzerInstance = useVersionParameter ? (Analyzer)constructor.newInstance(luceneMatchVersion) : (Analyzer)constructor.newInstance(new Object[0]);
        }
        catch (IllegalAccessException e) {
            throw new SearchException("Unable to instantiate analyzer class: " + classToInstantiate.getName() + ". Class or constructor is not accessible.", e);
        }
        catch (InstantiationException e) {
            throw new SearchException("Unable to instantiate analyzer class: " + classToInstantiate.getName() + ". Verify it has a no-args public constructor and is not abstract.", e);
        }
        catch (InvocationTargetException e) {
            throw new SearchException("Unable to instantiate analyzer class: " + classToInstantiate.getName() + ". Verify it has a no-args public constructor and is not abstract." + " Also Analyzer implementation classes or their tokenStream() and reusableTokenStream() implementations must be final.", e);
        }
        return analyzerInstance;
    }

    private static void checkClassType(Class<?> classToLoad, String componentDescription) {
        if (classToLoad.isInterface()) {
            throw new SearchException(classToLoad.getName() + " defined for component " + componentDescription + " is an interface: implementation required.");
        }
    }

    private static void checkHasNoArgConstructor(Class<?> classToLoad, String componentDescription) {
        try {
            classToLoad.getConstructor(new Class[0]);
        }
        catch (SecurityException e) {
            throw new SearchException(classToLoad.getName() + " defined for component " + componentDescription + " could not be instantiated because of a security manager error", e);
        }
        catch (NoSuchMethodException e) {
            throw new SearchException(classToLoad.getName() + " defined for component " + componentDescription + " is missing a no-arguments constructor");
        }
    }

    private static Constructor<?> getSingleMapConstructor(Class<?> classToLoad, String componentDescription) {
        try {
            return classToLoad.getConstructor(Map.class);
        }
        catch (SecurityException e) {
            throw new SearchException(classToLoad.getName() + " defined for component " + componentDescription + " could not be instantiated because of a security manager error", e);
        }
        catch (NoSuchMethodException e) {
            throw new SearchException(classToLoad.getName() + " defined for component " + componentDescription + " is missing an appropriate constructor: expected a public constructor with a single parameter of type Map");
        }
    }

    public static Class<?> classForName(String classNameToLoad, ClassLoader classLoader, String componentDescription) {
        Class clazzDef;
        try {
            clazzDef = ClassLoaderHelper.classForName(classNameToLoad, classLoader);
        }
        catch (ClassNotFoundException e) {
            throw new SearchException("Unable to find " + componentDescription + " implementation class: " + classNameToLoad, e);
        }
        return clazzDef;
    }

    public static <T> Class<? extends T> classForName(Class<T> targetSuperType, String classNameToLoad, ClassLoader classLoader, String componentDescription) {
        Class<?> clazzDef = ClassLoaderHelper.classForName(classNameToLoad, classLoader, componentDescription);
        try {
            return clazzDef.asSubclass(targetSuperType);
        }
        catch (ClassCastException cce) {
            throw new SearchException("Unable to load class for " + componentDescription + ". Configured implementation " + classNameToLoad + " is not assignable to type " + targetSuperType);
        }
    }

    public static Class classForName(String name, ClassLoader classLoader) throws ClassNotFoundException {
        try {
            ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
            if (contextClassLoader != null) {
                return contextClassLoader.loadClass(name);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return Class.forName(name, true, classLoader);
    }
}

