/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.configuration;

import java.io.Serializable;
import java.lang.annotation.ElementType;
import java.util.Arrays;
import org.apache.lucene.search.Query;
import org.hibernate.search.backend.TransactionContext;
import org.hibernate.search.backend.spi.Work;
import org.hibernate.search.backend.spi.WorkType;
import org.hibernate.search.cfg.SearchMapping;
import org.hibernate.search.cfg.spi.SearchConfiguration;
import org.hibernate.search.engine.spi.SearchFactoryImplementor;
import org.hibernate.search.exception.SearchException;
import org.hibernate.search.query.dsl.QueryBuilder;
import org.hibernate.search.query.dsl.TermMatchingContext;
import org.hibernate.search.spi.SearchFactoryBuilder;
import org.hibernate.search.testsupport.setup.SearchConfigurationForTest;
import org.hibernate.search.testsupport.setup.TransactionContextForTest;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class ImplicitProvidedIdTest {
    @Rule
    public ExpectedException exceptions = ExpectedException.none();

    @Test
    public void exceptionThrownWhenNotEnabled() {
        SearchMapping mapping = new SearchMapping();
        mapping.entity(Book.class).indexed().property("title", ElementType.FIELD).field().property("text", ElementType.FIELD).field();
        SearchConfigurationForTest cfg = new SearchConfigurationForTest().setProgrammaticMapping(mapping).addClass(Book.class);
        this.exceptions.expect(SearchException.class);
        this.exceptions.expectMessage("HSEARCH000177");
        this.storeBooksViaProvidedId(cfg, "providedId", false);
    }

    @Test
    public void usingConfigurationTypeOverride() {
        SearchMapping mapping = new SearchMapping();
        mapping.entity(Book.class).indexed().property("title", ElementType.FIELD).field().property("text", ElementType.FIELD).field();
        SearchConfigurationForTest cfg = new SearchConfigurationForTest().setProgrammaticMapping(mapping).setIdProvidedImplicit(true).addClass(Book.class);
        this.storeBooksViaProvidedId(cfg, "providedId", false);
    }

    @Test
    public void usingProvidedIdAsOptionsOverride() {
        SearchMapping mapping = new SearchMapping();
        mapping.entity(Book.class).indexed().providedId().name("myID").property("title", ElementType.FIELD).field().property("text", ElementType.FIELD).field();
        SearchConfigurationForTest cfg = new SearchConfigurationForTest().setProgrammaticMapping(mapping).setIdProvidedImplicit(true).addClass(Book.class);
        this.storeBooksViaProvidedId(cfg, "myID", false);
    }

    @Test
    public void usingExplicitProvidedId() {
        SearchMapping mapping = new SearchMapping();
        mapping.entity(Book.class).indexed().providedId().name("myID").property("title", ElementType.FIELD).field().property("text", ElementType.FIELD).field();
        SearchConfigurationForTest cfg = new SearchConfigurationForTest().setProgrammaticMapping(mapping).setIdProvidedImplicit(false).addClass(Book.class);
        this.storeBooksViaProvidedId(cfg, "myID", false);
    }

    @Test
    public void usingDefaultSettings() {
        SearchMapping mapping = new SearchMapping();
        mapping.entity(Book.class).indexed().providedId().name("myID").property("title", ElementType.FIELD).field().property("text", ElementType.FIELD).field();
        SearchConfigurationForTest cfg = new SearchConfigurationForTest().setProgrammaticMapping(mapping).addClass(Book.class);
        this.storeBooksViaProvidedId(cfg, "myID", false);
    }

    @Test
    public void documentIdNotOverriden() {
        SearchMapping mapping = new SearchMapping();
        mapping.entity(Book.class).indexed().property("title", ElementType.FIELD).documentId().property("text", ElementType.FIELD).field();
        SearchConfigurationForTest cfg = new SearchConfigurationForTest().setProgrammaticMapping(mapping).addClass(Book.class);
        this.storeBooksViaProvidedId(cfg, "title", true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeBooksViaProvidedId(SearchConfigurationForTest cfg, String fieldName, boolean matchTitle) {
        try (SearchFactoryImplementor sf = null;){
            sf = new SearchFactoryBuilder().configuration((SearchConfiguration)cfg).buildSearchFactory();
            Book book = new Book();
            book.title = "Less is nice";
            book.text = "When using Infinispan Query, users have to always remember to add @ProvidedId on their classes or a nasty exception will remind them. Can't we just assume it's always annotated?";
            String isbn = "some entity-external id";
            Work work = new Work((Object)book, (Serializable)((Object)isbn), WorkType.ADD, false);
            TransactionContextForTest tc = new TransactionContextForTest();
            sf.getWorker().performWork(work, (TransactionContext)tc);
            tc.end();
            QueryBuilder queryBuilder = sf.buildQueryBuilder().forEntity(Book.class).get();
            Query query = ((TermMatchingContext)queryBuilder.keyword().onField(fieldName).ignoreAnalyzer()).matching((Object)(matchTitle ? book.title : isbn)).createQuery();
            int queryResultSize = sf.createHSQuery().luceneQuery(query).targetedEntities(Arrays.asList(Book.class)).queryResultSize();
            Assert.assertEquals((long)1L, (long)queryResultSize);
        }
    }

    static class Book {
        String title;
        String text;

        Book() {
        }
    }
}

