/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.configuration;

import java.io.InputStream;
import java.lang.annotation.ElementType;
import java.net.URL;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import org.hibernate.search.annotations.DocumentId;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.cfg.SearchMapping;
import org.hibernate.search.cfg.spi.IndexManagerFactory;
import org.hibernate.search.cfg.spi.SearchConfiguration;
import org.hibernate.search.engine.service.classloading.impl.DefaultClassLoaderService;
import org.hibernate.search.engine.service.classloading.spi.ClassLoaderService;
import org.hibernate.search.engine.service.spi.Service;
import org.hibernate.search.engine.spi.SearchFactoryImplementor;
import org.hibernate.search.impl.DefaultIndexManagerFactory;
import org.hibernate.search.indexes.impl.DirectoryBasedIndexManager;
import org.hibernate.search.indexes.impl.NRTIndexManager;
import org.hibernate.search.indexes.spi.IndexManager;
import org.hibernate.search.spi.SearchFactoryBuilder;
import org.hibernate.search.testsupport.TestForIssue;
import org.hibernate.search.testsupport.setup.SearchConfigurationForTest;
import org.hibernate.search.util.impl.ClassLoaderHelper;
import org.hibernate.search.util.impl.CollectionHelper;
import org.junit.Assert;
import org.junit.Test;

@TestForIssue(jiraKey="HSEARCH-1211")
public class IndexManagerFactoryCustomizationTest {
    @Test
    public void testDefaultImplementation() {
        SearchConfigurationForTest cfg = new SearchConfigurationForTest();
        this.verifyIndexManagerTypeIs(DirectoryBasedIndexManager.class, cfg);
    }

    @Test
    public void testOverriddenDefaultImplementation() {
        SearchConfigurationForTest configurationForTest = new SearchConfigurationForTest();
        HashMap fakedDiscoveredServices = CollectionHelper.newHashMap((int)1);
        fakedDiscoveredServices.put(IndexManagerFactory.class, NRTIndexManagerFactory.class.getName());
        configurationForTest.setClassLoaderService(new CustomClassLoaderService(fakedDiscoveredServices));
        this.verifyIndexManagerTypeIs(NRTIndexManager.class, configurationForTest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void verifyIndexManagerTypeIs(Class<? extends IndexManager> expectedIndexManagerClass, SearchConfigurationForTest cfg) {
        SearchMapping mapping = new SearchMapping();
        mapping.entity(Document.class).indexed().indexName("documents").property("id", ElementType.FIELD).documentId().property("title", ElementType.FIELD).field();
        cfg.setProgrammaticMapping(mapping);
        cfg.addClass(Document.class);
        try (SearchFactoryImplementor sf = new SearchFactoryBuilder().configuration((SearchConfiguration)cfg).buildSearchFactory();){
            Assert.assertEquals(expectedIndexManagerClass, this.extractDocumentIndexManagerClassName(sf, "documents"));
            sf.addClasses(new Class[]{Dvd.class});
            Assert.assertEquals(expectedIndexManagerClass, this.extractDocumentIndexManagerClassName(sf, "dvds"));
            Assert.assertEquals(expectedIndexManagerClass, this.extractDocumentIndexManagerClassName(sf, "documents"));
        }
    }

    private Class<? extends IndexManager> extractDocumentIndexManagerClassName(SearchFactoryImplementor sf, String indexName) {
        IndexManager indexManager = sf.getIndexManagerHolder().getIndexManager(indexName);
        Assert.assertNotNull((Object)indexManager);
        return indexManager.getClass();
    }

    public static class NRTIndexManagerFactory
    extends DefaultIndexManagerFactory {
        public IndexManager createDefaultIndexManager() {
            return new NRTIndexManager();
        }
    }

    public static class CustomClassLoaderService
    implements ClassLoaderService {
        private final ClassLoaderService defaultClassLoaderService = new DefaultClassLoaderService();
        private final Map<Class<? extends Service>, String> fakedDiscoveredServices;

        public CustomClassLoaderService(Map<Class<? extends Service>, String> fakedDiscoveredServices) {
            this.fakedDiscoveredServices = fakedDiscoveredServices;
        }

        public <T> Class<T> classForName(String className) {
            return this.defaultClassLoaderService.classForName(className);
        }

        public URL locateResource(String name) {
            return this.defaultClassLoaderService.locateResource(name);
        }

        public InputStream locateResourceStream(String name) {
            return this.defaultClassLoaderService.locateResourceStream(name);
        }

        public <T> LinkedHashSet<T> loadJavaServices(Class<T> serviceContract) {
            if (this.fakedDiscoveredServices.containsKey(serviceContract)) {
                LinkedHashSet<Object> services = new LinkedHashSet<Object>(1);
                Class<T> clazz = this.classForName(this.fakedDiscoveredServices.get(serviceContract));
                services.add(ClassLoaderHelper.instanceFromClass(serviceContract, clazz, (String)"fake service"));
                return services;
            }
            return this.defaultClassLoaderService.loadJavaServices(serviceContract);
        }
    }

    @Indexed(index="dvds")
    public static final class Dvd {
        @DocumentId
        long id;
        @Field
        String title;
    }

    public static final class Document {
        long id;
        String title;
    }
}

