/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.configuration;

import java.lang.annotation.ElementType;
import org.hibernate.search.annotations.DocumentId;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.backend.impl.lucene.AbstractWorkspaceImpl;
import org.hibernate.search.backend.impl.lucene.LuceneBackendQueueProcessor;
import org.hibernate.search.cfg.SearchMapping;
import org.hibernate.search.cfg.spi.SearchConfiguration;
import org.hibernate.search.engine.spi.EntityIndexBinding;
import org.hibernate.search.impl.MutableSearchFactory;
import org.hibernate.search.indexes.impl.DirectoryBasedIndexManager;
import org.hibernate.search.spi.SearchFactoryBuilder;
import org.hibernate.search.testsupport.setup.SearchConfigurationForTest;
import org.junit.Assert;
import org.junit.Test;

public class IndexMetadataCompleteConfiguredTest {
    @Test
    public void testDefaultImplementation() {
        SearchConfigurationForTest cfg = new SearchConfigurationForTest();
        this.verifyIndexCompleteMetadataOption(true, cfg);
    }

    @Test
    public void testIndexMetadataCompleteFalse() {
        SearchConfigurationForTest cfg = new SearchConfigurationForTest();
        cfg.setIndexMetadataComplete(false);
        this.verifyIndexCompleteMetadataOption(false, cfg);
    }

    @Test
    public void testIndexMetadataCompleteTrue() {
        SearchConfigurationForTest cfg = new SearchConfigurationForTest();
        cfg.setIndexMetadataComplete(true);
        this.verifyIndexCompleteMetadataOption(true, cfg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void verifyIndexCompleteMetadataOption(boolean expectation, SearchConfigurationForTest cfg) {
        SearchMapping mapping = new SearchMapping();
        mapping.entity(Document.class).indexed().indexName("index1").property("id", ElementType.FIELD).documentId().property("title", ElementType.FIELD).field();
        cfg.setProgrammaticMapping(mapping);
        cfg.addClass(Document.class);
        try (MutableSearchFactory sf = (MutableSearchFactory)new SearchFactoryBuilder().configuration((SearchConfiguration)cfg).buildSearchFactory();){
            Assert.assertEquals((Object)expectation, (Object)IndexMetadataCompleteConfiguredTest.extractWorkspace(sf, Document.class).areSingleTermDeletesSafe());
            sf.addClasses(new Class[]{Dvd.class, Book.class});
            Assert.assertEquals((Object)false, (Object)IndexMetadataCompleteConfiguredTest.extractWorkspace(sf, Dvd.class).areSingleTermDeletesSafe());
            Assert.assertEquals((Object)false, (Object)IndexMetadataCompleteConfiguredTest.extractWorkspace(sf, Document.class).areSingleTermDeletesSafe());
            Assert.assertEquals((Object)expectation, (Object)IndexMetadataCompleteConfiguredTest.extractWorkspace(sf, Book.class).areSingleTermDeletesSafe());
        }
    }

    private static AbstractWorkspaceImpl extractWorkspace(MutableSearchFactory sf, Class<?> type) {
        EntityIndexBinding indexBindingForEntity = sf.getIndexBinding(type);
        DirectoryBasedIndexManager indexManager = (DirectoryBasedIndexManager)indexBindingForEntity.getIndexManagers()[0];
        LuceneBackendQueueProcessor backend = (LuceneBackendQueueProcessor)indexManager.getBackendQueueProcessor();
        return backend.getIndexResources().getWorkspace();
    }

    @Indexed(index="index2")
    public static final class Book {
        @DocumentId
        long id;
        @Field
        String title;
    }

    @Indexed(index="index1")
    public static final class Dvd {
        @DocumentId
        long id;
        @Field
        String title;
    }

    public static final class Document {
        long id;
        String title;
    }
}

