/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.configuration.mutablefactory;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TopDocs;
import org.hibernate.search.backend.TransactionContext;
import org.hibernate.search.backend.spi.Work;
import org.hibernate.search.backend.spi.WorkType;
import org.hibernate.search.cfg.spi.SearchConfiguration;
import org.hibernate.search.engine.service.classloading.spi.ClassLoaderService;
import org.hibernate.search.engine.service.spi.ServiceManager;
import org.hibernate.search.engine.spi.EntityIndexBinding;
import org.hibernate.search.engine.spi.SearchFactoryImplementor;
import org.hibernate.search.exception.SearchException;
import org.hibernate.search.indexes.impl.DirectoryBasedIndexManager;
import org.hibernate.search.indexes.spi.IndexManager;
import org.hibernate.search.spi.SearchFactoryBuilder;
import org.hibernate.search.spi.SearchIntegrator;
import org.hibernate.search.store.DirectoryProvider;
import org.hibernate.search.store.impl.RAMDirectoryProvider;
import org.hibernate.search.test.configuration.mutablefactory.A;
import org.hibernate.search.test.configuration.mutablefactory.B;
import org.hibernate.search.test.configuration.mutablefactory.C;
import org.hibernate.search.test.configuration.mutablefactory.generated.Generated;
import org.hibernate.search.testsupport.TestConstants;
import org.hibernate.search.testsupport.setup.SearchConfigurationForTest;
import org.hibernate.search.testsupport.setup.TransactionContextForTest;
import org.hibernate.search.util.impl.Executors;
import org.junit.Assert;
import org.junit.Test;

public class MutableFactoryTest {
    @Test
    public void testCreateEmptyFactory() throws Exception {
        SearchFactoryImplementor sf = new SearchFactoryBuilder().configuration((SearchConfiguration)new SearchConfigurationForTest()).buildSearchFactory();
        sf.close();
    }

    @Test
    public void testAddingClassFullModel() throws Exception {
        SearchFactoryImplementor sf = new SearchFactoryBuilder().configuration((SearchConfiguration)new SearchConfigurationForTest()).buildSearchFactory();
        SearchFactoryBuilder builder = new SearchFactoryBuilder();
        sf = builder.currentFactory((SearchIntegrator)sf).addClass(A.class).buildSearchFactory();
        TransactionContextForTest tc = new TransactionContextForTest();
        MutableFactoryTest.doIndexWork(new A(1, "Emmanuel"), 1, (SearchIntegrator)sf, tc);
        tc.end();
        QueryParser parser = new QueryParser(TestConstants.getTargetLuceneVersion(), "name", TestConstants.standardAnalyzer);
        Query luceneQuery = parser.parse("Emmanuel");
        IndexReader indexReader = sf.getIndexReaderAccessor().open(new Class[]{A.class});
        IndexSearcher searcher = new IndexSearcher(indexReader);
        TopDocs hits = searcher.search(luceneQuery, 1000);
        Assert.assertEquals((long)1L, (long)hits.totalHits);
        sf.getIndexReaderAccessor().close(indexReader);
        sf = builder.currentFactory((SearchIntegrator)sf).addClass(B.class).buildSearchFactory();
        tc = new TransactionContextForTest();
        MutableFactoryTest.doIndexWork(new B(1, "Noel"), 1, (SearchIntegrator)sf, tc);
        tc.end();
        luceneQuery = parser.parse("Noel");
        indexReader = sf.getIndexReaderAccessor().open(new Class[]{B.class});
        searcher = new IndexSearcher(indexReader);
        hits = searcher.search(luceneQuery, 1000);
        Assert.assertEquals((long)1L, (long)hits.totalHits);
        sf.getIndexReaderAccessor().close(indexReader);
        sf.close();
    }

    @Test
    public void testAddingClassSimpleAPI() throws Exception {
        SearchFactoryImplementor sf = new SearchFactoryBuilder().configuration((SearchConfiguration)new SearchConfigurationForTest()).buildSearchFactory();
        sf.addClasses(new Class[]{A.class});
        TransactionContextForTest tc = new TransactionContextForTest();
        MutableFactoryTest.doIndexWork(new A(1, "Emmanuel"), 1, (SearchIntegrator)sf, tc);
        tc.end();
        QueryParser parser = new QueryParser(TestConstants.getTargetLuceneVersion(), "name", TestConstants.standardAnalyzer);
        Query luceneQuery = parser.parse("Emmanuel");
        IndexReader indexReader = sf.getIndexReaderAccessor().open(new Class[]{A.class});
        IndexSearcher searcher = new IndexSearcher(indexReader);
        TopDocs hits = searcher.search(luceneQuery, 1000);
        Assert.assertEquals((long)1L, (long)hits.totalHits);
        sf.getIndexReaderAccessor().close(indexReader);
        sf.addClasses(new Class[]{B.class, C.class});
        tc = new TransactionContextForTest();
        MutableFactoryTest.doIndexWork(new B(1, "Noel"), 1, (SearchIntegrator)sf, tc);
        MutableFactoryTest.doIndexWork(new C(1, "Vincent"), 1, (SearchIntegrator)sf, tc);
        tc.end();
        luceneQuery = parser.parse("Noel");
        indexReader = sf.getIndexReaderAccessor().open(new Class[]{B.class});
        searcher = new IndexSearcher(indexReader);
        hits = searcher.search(luceneQuery, 1000);
        Assert.assertEquals((long)1L, (long)hits.totalHits);
        sf.getIndexReaderAccessor().close(indexReader);
        luceneQuery = parser.parse("Vincent");
        indexReader = sf.getIndexReaderAccessor().open(new Class[]{C.class});
        searcher = new IndexSearcher(indexReader);
        hits = searcher.search(luceneQuery, 1000);
        Assert.assertEquals((long)1L, (long)hits.totalHits);
        sf.getIndexReaderAccessor().close(indexReader);
        sf.close();
    }

    private static void doIndexWork(Object entity, Integer id, SearchIntegrator sfi, TransactionContextForTest tc) {
        Work work = new Work(entity, (Serializable)id, WorkType.INDEX);
        sfi.getWorker().performWork(work, (TransactionContext)tc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Test
    public void testMultiThreadedAddClasses() throws Exception {
        QueryParser parser = new QueryParser(TestConstants.getTargetLuceneVersion(), "name", TestConstants.standardAnalyzer);
        try (SearchFactoryImplementor sf = new SearchFactoryBuilder().configuration((SearchConfiguration)new SearchConfigurationForTest()).buildSearchFactory();){
            void var8_15;
            boolean inProgress;
            ArrayList<DoAddClasses> runnables = new ArrayList<DoAddClasses>(10);
            int nbrOfThread = 10;
            int nbrOfClassesPerThread = 10;
            for (int i = 0; i < 10; ++i) {
                runnables.add(new DoAddClasses(sf, i, 10));
            }
            ThreadPoolExecutor poolExecutor = Executors.newFixedThreadPool((int)10, (String)"SFI classes addition");
            poolExecutor.prestartAllCoreThreads();
            for (Runnable runnable : runnables) {
                poolExecutor.execute(runnable);
            }
            poolExecutor.shutdown();
            do {
                Thread.sleep(100L);
                inProgress = false;
                for (DoAddClasses runnable : runnables) {
                    inProgress = inProgress || runnable.isFailure() == null;
                }
            } while (inProgress);
            for (DoAddClasses runnable : runnables) {
                Assert.assertNotNull((String)("Threads not run # " + runnable.getWorkNumber()), (Object)runnable.isFailure());
                Assert.assertFalse((String)("thread failed #" + runnable.getWorkNumber() + " Failure: " + runnable.getFailureInfo()), (boolean)runnable.isFailure());
            }
            poolExecutor.awaitTermination(1L, TimeUnit.MINUTES);
            boolean bl = false;
            while (var8_15 < 100) {
                Query luceneQuery = parser.parse("Emmanuel" + (int)var8_15);
                Class<?> classByNumber = MutableFactoryTest.getClassByNumber((int)var8_15, sf.getServiceManager());
                IndexReader indexReader = sf.getIndexReaderAccessor().open(new Class[]{classByNumber});
                IndexSearcher searcher = new IndexSearcher(indexReader);
                TopDocs hits = searcher.search(luceneQuery, 1000);
                Assert.assertEquals((long)1L, (long)hits.totalHits);
                sf.getIndexReaderAccessor().close(indexReader);
                ++var8_15;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Class<?> getClassByNumber(int i, ServiceManager serviceManager) throws ClassNotFoundException {
        Class clazz;
        ClassLoaderService classLoaderService = (ClassLoaderService)serviceManager.requestService(ClassLoaderService.class);
        try {
            clazz = classLoaderService.classForName(Generated.A0.class.getName().replace("A0", "A" + i));
        }
        finally {
            serviceManager.releaseService(ClassLoaderService.class);
        }
        return clazz;
    }

    private static class DoAddClasses
    implements Runnable {
        private final SearchFactoryImplementor searchFactoryImplementor;
        private final int factorOfClassesPerThread;
        private final QueryParser parser;
        private final int nbrOfClassesPerThread;
        private volatile Boolean failure = false;
        private volatile String failureInfo;

        public String getFailureInfo() {
            return this.failureInfo;
        }

        public Boolean isFailure() {
            return this.failure;
        }

        public int getWorkNumber() {
            return this.factorOfClassesPerThread;
        }

        public DoAddClasses(SearchFactoryImplementor searchFactoryImplementor, int factorOfClassesPerThread, int nbrOfClassesPerThread) {
            this.searchFactoryImplementor = searchFactoryImplementor;
            this.factorOfClassesPerThread = factorOfClassesPerThread;
            this.parser = new QueryParser(TestConstants.getTargetLuceneVersion(), "name", TestConstants.standardAnalyzer);
            this.nbrOfClassesPerThread = nbrOfClassesPerThread;
        }

        @Override
        public void run() {
            try {
                for (int index = 0; index < 10; ++index) {
                    int i = this.factorOfClassesPerThread * this.nbrOfClassesPerThread + index;
                    Class aClass = MutableFactoryTest.getClassByNumber(i, this.searchFactoryImplementor.getServiceManager());
                    this.searchFactoryImplementor.addClasses(new Class[]{aClass});
                    Object entity = aClass.getConstructor(Integer.class, String.class).newInstance(i, "Emmanuel" + i);
                    TransactionContextForTest context = new TransactionContextForTest();
                    MutableFactoryTest.doIndexWork(entity, i, (SearchIntegrator)this.searchFactoryImplementor, context);
                    context.end();
                    EntityIndexBinding indexBindingForEntity = this.searchFactoryImplementor.getIndexBinding(aClass);
                    Assert.assertNotNull((Object)indexBindingForEntity);
                    IndexManager[] indexManagers = indexBindingForEntity.getIndexManagers();
                    Assert.assertEquals((long)1L, (long)indexManagers.length);
                    DirectoryBasedIndexManager indexManager = (DirectoryBasedIndexManager)indexManagers[0];
                    DirectoryProvider directoryProvider = indexManager.getDirectoryProvider();
                    if (!(directoryProvider instanceof RAMDirectoryProvider)) {
                        throw new SearchException("Configuration lost: expected RAM directory");
                    }
                    Query luceneQuery = this.parser.parse("Emmanuel" + i);
                    IndexReader indexReader = this.searchFactoryImplementor.getIndexReaderAccessor().open(new Class[]{aClass});
                    IndexSearcher searcher = new IndexSearcher(indexReader);
                    TopDocs hits = searcher.search(luceneQuery, 1000);
                    if (hits.totalHits != 1) {
                        this.failure = true;
                        this.failureInfo = "failure: Emmanuel" + i + " for " + aClass.getName();
                        return;
                    }
                    this.searchFactoryImplementor.getIndexReaderAccessor().close(indexReader);
                }
            }
            catch (Exception e) {
                this.failure = true;
                e.printStackTrace();
                this.failureInfo = "failure: Emmanuel" + this.factorOfClassesPerThread + " exception: " + e.toString();
            }
        }
    }
}

