/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.dsl;

import java.io.Serializable;
import org.hibernate.search.annotations.DocumentId;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.backend.TransactionContext;
import org.hibernate.search.backend.spi.Work;
import org.hibernate.search.backend.spi.WorkType;
import org.hibernate.search.engine.spi.SearchFactoryImplementor;
import org.hibernate.search.exception.EmptyQueryException;
import org.hibernate.search.query.dsl.QueryBuilder;
import org.hibernate.search.testsupport.junit.SearchFactoryHolder;
import org.hibernate.search.testsupport.setup.TransactionContextForTest;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class EmptyQueryExceptionTest {
    @Rule
    public SearchFactoryHolder sfHolder = new SearchFactoryHolder(Book.class);
    @Rule
    public ExpectedException exceptions = ExpectedException.none();

    @Test
    public void verifyExceptionOnNonMeaningfullQueries() {
        SearchFactoryImplementor searchFactory = this.sfHolder.getSearchFactory();
        Book book = new Book();
        book.title = "Empty Book";
        book.text = "The question is, does an empty book have 'space' tokens in it?";
        Work work = new Work((Object)book, (Serializable)((Object)book.title), WorkType.ADD, false);
        TransactionContextForTest tc = new TransactionContextForTest();
        searchFactory.getWorker().performWork(work, (TransactionContext)tc);
        tc.end();
        QueryBuilder queryBuilder = searchFactory.buildQueryBuilder().forEntity(Book.class).get();
        this.exceptions.expect(EmptyQueryException.class);
        queryBuilder.keyword().onField("text").matching((Object)" ").createQuery();
    }

    @Indexed
    static class Book {
        @DocumentId
        String title;
        @Field
        String text;

        Book() {
        }
    }
}

