/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.metadata;

import java.util.HashSet;
import java.util.Set;
import org.hibernate.annotations.common.reflection.ReflectionManager;
import org.hibernate.annotations.common.reflection.java.JavaReflectionManager;
import org.hibernate.search.cfg.spi.SearchConfiguration;
import org.hibernate.search.engine.impl.DefaultBoostStrategy;
import org.hibernate.search.engine.metadata.impl.AnnotationMetadataProvider;
import org.hibernate.search.impl.ConfigContext;
import org.hibernate.search.metadata.IndexedTypeDescriptor;
import org.hibernate.search.metadata.PropertyDescriptor;
import org.hibernate.search.spi.BuildContext;
import org.hibernate.search.test.metadata.DescriptorTestHelper;
import org.hibernate.search.test.metadata.Foo;
import org.hibernate.search.test.metadata.Fubar;
import org.hibernate.search.test.metadata.Snafu;
import org.hibernate.search.test.metadata.Susfu;
import org.hibernate.search.testsupport.TestForIssue;
import org.hibernate.search.testsupport.setup.BuildContextForTest;
import org.hibernate.search.testsupport.setup.SearchConfigurationForTest;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@TestForIssue(jiraKey="HSEARCH-436")
public class IndexedTypeDescriptorTest {
    private AnnotationMetadataProvider metadataProvider;

    @Before
    public void setUp() {
        SearchConfigurationForTest searchConfiguration = new SearchConfigurationForTest();
        ConfigContext configContext = new ConfigContext((SearchConfiguration)searchConfiguration, (BuildContext)new BuildContextForTest(searchConfiguration));
        this.metadataProvider = new AnnotationMetadataProvider((ReflectionManager)new JavaReflectionManager(), configContext);
    }

    @Test
    public void testIsIndexed() {
        IndexedTypeDescriptor typeDescriptor = DescriptorTestHelper.getTypeDescriptor(this.metadataProvider, Foo.class);
        Assert.assertEquals((String)"Wrong indexed type", Foo.class, (Object)typeDescriptor.getType());
        Assert.assertTrue((boolean)typeDescriptor.isIndexed());
    }

    @Test
    public void testDefaultStaticBoost() {
        IndexedTypeDescriptor typeDescriptor = DescriptorTestHelper.getTypeDescriptor(this.metadataProvider, Foo.class);
        Assert.assertEquals((String)"The default boost should be 1.0f", (float)1.0f, (float)typeDescriptor.getStaticBoost(), (float)0.0f);
    }

    @Test
    public void testGetPropertyThrowsExceptionForNullParameter() {
        IndexedTypeDescriptor typeDescriptor = DescriptorTestHelper.getTypeDescriptor(this.metadataProvider, Foo.class);
        try {
            typeDescriptor.getProperty(null);
            Assert.fail((String)"Passing null as parameter is not allowed");
        }
        catch (IllegalArgumentException e) {
            Assert.assertTrue((String)("Wrong exception: " + e.getMessage()), (boolean)e.getMessage().startsWith("HSEARCH000181"));
        }
    }

    @Test
    public void testGetFieldsForPropertyThrowsExceptionForNullParameter() {
        IndexedTypeDescriptor typeDescriptor = DescriptorTestHelper.getTypeDescriptor(this.metadataProvider, Foo.class);
        try {
            typeDescriptor.getFieldsForProperty(null);
            Assert.fail((String)"Passing null as parameter is not allowed");
        }
        catch (IllegalArgumentException e) {
            Assert.assertTrue((String)("Wrong exception: " + e.getMessage()), (boolean)e.getMessage().startsWith("HSEARCH000181"));
        }
    }

    @Test
    public void testGetIndexedFieldThrowsExceptionForNullParameter() {
        IndexedTypeDescriptor typeDescriptor = DescriptorTestHelper.getTypeDescriptor(this.metadataProvider, Foo.class);
        try {
            typeDescriptor.getIndexedField(null);
            Assert.fail((String)"Passing null as parameter is not allowed");
        }
        catch (IllegalArgumentException e) {
            Assert.assertTrue((String)("Wrong exception: " + e.getMessage()), (boolean)e.getMessage().startsWith("HSEARCH000182"));
        }
    }

    @Test
    public void testExplicitStaticBoost() {
        IndexedTypeDescriptor typeDescriptor = DescriptorTestHelper.getTypeDescriptor(this.metadataProvider, Fubar.class);
        Assert.assertEquals((String)"The default boost should be 42.0f", (float)42.0f, (float)typeDescriptor.getStaticBoost(), (float)0.0f);
    }

    @Test
    public void testDefaultDynamicBoost() {
        IndexedTypeDescriptor typeDescriptor = DescriptorTestHelper.getTypeDescriptor(this.metadataProvider, Foo.class);
        Assert.assertTrue((boolean)(typeDescriptor.getDynamicBoost() instanceof DefaultBoostStrategy));
    }

    @Test
    public void testExplicitDynamicBoost() {
        IndexedTypeDescriptor typeDescriptor = DescriptorTestHelper.getTypeDescriptor(this.metadataProvider, Fubar.class);
        Assert.assertTrue((boolean)(typeDescriptor.getDynamicBoost() instanceof Fubar.DoublingBoost));
    }

    @Test
    public void testFieldAnnotationOnFieldAndGetterCreatesTwoFieldDescriptors() {
        IndexedTypeDescriptor typeDescriptor = DescriptorTestHelper.getTypeDescriptor(this.metadataProvider, Susfu.class);
        Set fieldDescriptors = typeDescriptor.getFieldsForProperty("susfu");
        Assert.assertEquals((String)"There should be two field descriptors", (long)2L, (long)fieldDescriptors.size());
    }

    @Test
    public void testRetrievingPropertyDescriptors() {
        IndexedTypeDescriptor typeDescriptor = DescriptorTestHelper.getTypeDescriptor(this.metadataProvider, Snafu.class);
        Set propertyDescriptors = typeDescriptor.getIndexedProperties();
        Assert.assertEquals((String)"There should be 5 properties defined in Snafu", (long)5L, (long)propertyDescriptors.size());
        HashSet<String> expectedPropertyNames = new HashSet<String>();
        expectedPropertyNames.add("id");
        expectedPropertyNames.add("snafu");
        expectedPropertyNames.add("numericField");
        expectedPropertyNames.add("nullValue");
        expectedPropertyNames.add("custom");
        for (PropertyDescriptor propertyDescriptor : propertyDescriptors) {
            Assert.assertTrue((String)("Unexpected property name: " + propertyDescriptor.getName()), (boolean)expectedPropertyNames.contains(propertyDescriptor.getName()));
        }
    }
}

