/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.metadata;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.hibernate.annotations.common.reflection.ReflectionManager;
import org.hibernate.annotations.common.reflection.java.JavaReflectionManager;
import org.hibernate.search.cfg.spi.SearchConfiguration;
import org.hibernate.search.engine.metadata.impl.AnnotationMetadataProvider;
import org.hibernate.search.engine.metadata.impl.TypeMetadata;
import org.hibernate.search.impl.ConfigContext;
import org.hibernate.search.metadata.IndexDescriptor;
import org.hibernate.search.metadata.IndexedTypeDescriptor;
import org.hibernate.search.metadata.PropertyDescriptor;
import org.hibernate.search.metadata.impl.IndexedTypeDescriptorImpl;
import org.hibernate.search.spi.BuildContext;
import org.hibernate.search.test.metadata.DescriptorTestHelper;
import org.hibernate.search.test.metadata.Foo;
import org.hibernate.search.test.metadata.Fubar;
import org.hibernate.search.test.metadata.Snafu;
import org.hibernate.search.test.metadata.Susfu;
import org.hibernate.search.testsupport.TestForIssue;
import org.hibernate.search.testsupport.setup.BuildContextForTest;
import org.hibernate.search.testsupport.setup.SearchConfigurationForTest;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@TestForIssue(jiraKey="HSEARCH-436")
public class PropertyDescriptorTest {
    private static final List<String> TEST_INDEX_NAMES = Arrays.asList("index-0", "index-0", "index-0");
    private AnnotationMetadataProvider metadataProvider;

    @Before
    public void setUp() {
        SearchConfigurationForTest searchConfiguration = new SearchConfigurationForTest();
        ConfigContext configContext = new ConfigContext((SearchConfiguration)searchConfiguration, (BuildContext)new BuildContextForTest(searchConfiguration));
        this.metadataProvider = new AnnotationMetadataProvider((ReflectionManager)new JavaReflectionManager(), configContext);
    }

    @Test
    public void testIdProperty() {
        PropertyDescriptor propertyDescriptor = this.getPropertyDescriptor(Fubar.class, "id");
        String propertyName = propertyDescriptor.getName();
        Assert.assertEquals((String)"Wrong property name", (Object)"id", (Object)propertyName);
        Assert.assertTrue((String)"This property should should host the id field", (boolean)propertyDescriptor.isId());
    }

    @Test
    public void testIndexInformation() {
        IndexedTypeDescriptor typeDescriptor = DescriptorTestHelper.getTypeDescriptor(this.metadataProvider, Foo.class);
        Set indexDescriptors = typeDescriptor.getIndexDescriptors();
        Assert.assertEquals((String)"Wrong index name", (Object)TEST_INDEX_NAMES.get(0), (Object)((IndexDescriptor)indexDescriptors.iterator().next()).getName());
    }

    @Test
    public void testSharedIndexInformation() {
        TypeMetadata typeMetadata = this.metadataProvider.getTypeMetadataFor(Foo.class);
        IndexedTypeDescriptorImpl typeDescriptor = new IndexedTypeDescriptorImpl(typeMetadata, DescriptorTestHelper.getDummyShardedIndexManager());
        Assert.assertTrue((boolean)typeDescriptor.isSharded());
        Set indexDescriptors = typeDescriptor.getIndexDescriptors();
        Assert.assertTrue((indexDescriptors.size() == 3 ? 1 : 0) != 0);
        for (IndexDescriptor indexDescriptor : indexDescriptors) {
            String shardName = indexDescriptor.getName();
            Assert.assertTrue((String)("Missing shard name: " + shardName), (boolean)TEST_INDEX_NAMES.contains(indexDescriptor.getName()));
        }
    }

    @Test
    public void testFieldAnnotationOnFieldAndGetterCreatesTwoFieldDescriptors() {
        IndexedTypeDescriptor typeDescriptor = DescriptorTestHelper.getTypeDescriptor(this.metadataProvider, Susfu.class);
        Set fieldDescriptors = typeDescriptor.getFieldsForProperty("susfu");
        Assert.assertEquals((String)"There should be two field descriptors", (long)2L, (long)fieldDescriptors.size());
    }

    @Test
    public void testRetrievingPropertyDescriptors() {
        IndexedTypeDescriptor typeDescriptor = DescriptorTestHelper.getTypeDescriptor(this.metadataProvider, Snafu.class);
        Set propertyDescriptors = typeDescriptor.getIndexedProperties();
        Assert.assertEquals((String)"There should be 5 properties defined in Snafu", (long)5L, (long)propertyDescriptors.size());
        HashSet<String> expectedPropertyNames = new HashSet<String>();
        expectedPropertyNames.add("id");
        expectedPropertyNames.add("snafu");
        expectedPropertyNames.add("numericField");
        expectedPropertyNames.add("nullValue");
        expectedPropertyNames.add("custom");
        for (PropertyDescriptor propertyDescriptor : propertyDescriptors) {
            Assert.assertTrue((String)("Unexpected property name: " + propertyDescriptor.getName()), (boolean)expectedPropertyNames.contains(propertyDescriptor.getName()));
        }
    }

    private PropertyDescriptor getPropertyDescriptor(Class<?> clazz, String propertyName) {
        IndexedTypeDescriptor typeDescriptor = DescriptorTestHelper.getTypeDescriptor(this.metadataProvider, clazz);
        return typeDescriptor.getProperty(propertyName);
    }
}

