/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.programmaticmapping;

import java.lang.annotation.ElementType;
import org.hibernate.search.annotations.Analyze;
import org.hibernate.search.annotations.Store;
import org.hibernate.search.cfg.SearchMapping;
import org.hibernate.search.engine.spi.SearchFactoryImplementor;
import org.hibernate.search.testsupport.junit.SearchFactoryHolder;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;

public class MutatingSearchFactoryTest {
    @Rule
    public SearchFactoryHolder sfHolder = new SearchFactoryHolder(MutatingSearchFactoryTest.buildMappingDefinition(), new Class[0]);

    @Test
    public void mutationTest() {
        SearchFactoryImplementor searchFactory = this.sfHolder.getSearchFactory();
        Assert.assertNull((Object)searchFactory.getIndexManagerHolder().getIndexManager("phoneNumbersIndex"));
        searchFactory.addClasses(new Class[]{TelephoneRecord.class});
        Assert.assertNotNull((Object)searchFactory.getIndexManagerHolder().getIndexManager("phoneNumbersIndex"));
        Assert.assertNull((Object)searchFactory.getIndexManagerHolder().getIndexManager("addressBookIndex"));
        searchFactory.addClasses(new Class[]{AddressBook.class});
        Assert.assertNotNull((Object)searchFactory.getIndexManagerHolder().getIndexManager("addressBookIndex"));
    }

    static SearchMapping buildMappingDefinition() {
        SearchMapping mapping = new SearchMapping();
        mapping.entity(TelephoneRecord.class).indexed().indexName("phoneNumbersIndex").property("id", ElementType.FIELD).documentId().property("phone", ElementType.FIELD).field().analyze(Analyze.NO).store(Store.YES).entity(AddressBook.class).indexed().indexName("addressBookIndex").property("id", ElementType.FIELD).documentId().property("name", ElementType.FIELD).field().store(Store.YES);
        return mapping;
    }

    public static final class AddressBook {
        private long id;
        private String name;

        public long getId() {
            return this.id;
        }

        public void setId(long id) {
            this.id = id;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }
    }

    public static final class TelephoneRecord {
        private long id;
        private String phone;

        public TelephoneRecord(long id, String phone) {
            this.id = id;
            this.phone = phone;
        }

        public long getId() {
            return this.id;
        }

        public void setId(long id) {
            this.id = id;
        }

        public String getPhone() {
            return this.phone;
        }

        public void setPhone(String phone) {
            this.phone = phone;
        }
    }
}

