/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.testsupport.concurrency;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import org.junit.Assert;

public class ConcurrentRunner {
    public static final int DEFAULT_REPEAT = 300;
    public static final int DEFAULT_THREADS = 30;
    private final AtomicBoolean somethingFailed = new AtomicBoolean(false);
    private final ExecutorService executor;
    private final CountDownLatch startLatch = new CountDownLatch(1);
    private final CountDownLatch endLatch;
    private final TaskFactory factory;
    private final int repetitions;

    public ConcurrentRunner(TaskFactory factory) {
        this(300, 30, factory);
    }

    public ConcurrentRunner(int repetitions, int threads, TaskFactory factory) {
        this.repetitions = repetitions;
        this.factory = factory;
        this.executor = Executors.newFixedThreadPool(threads);
        this.endLatch = new CountDownLatch(repetitions);
    }

    public void execute() throws Exception {
        for (int i = 0; i < this.repetitions; ++i) {
            Runnable userRunnable = this.factory.createRunnable(i);
            this.executor.execute(new WrapRunnable(this.startLatch, this.endLatch, userRunnable));
        }
        this.executor.shutdown();
        this.startLatch.countDown();
        try {
            this.endLatch.await();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            e.printStackTrace();
            Assert.fail((String)"Interrupted while awaiting for end of execution");
        }
        Assert.assertFalse((boolean)this.somethingFailed.get());
    }

    public static interface TaskFactory {
        public Runnable createRunnable(int var1) throws Exception;
    }

    private class WrapRunnable
    implements Runnable {
        private final CountDownLatch startLatch;
        private final CountDownLatch endLatch;
        private final Runnable userRunnable;

        public WrapRunnable(CountDownLatch startLatch, CountDownLatch endLatch, Runnable userRunnable) {
            this.startLatch = startLatch;
            this.endLatch = endLatch;
            this.userRunnable = userRunnable;
        }

        @Override
        public void run() {
            try {
                this.startLatch.await();
                this.userRunnable.run();
            }
            catch (InterruptedException | RuntimeException e) {
                e.printStackTrace();
                ConcurrentRunner.this.somethingFailed.set(true);
            }
            this.endLatch.countDown();
        }
    }
}

