/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.bridge.builtin;

import java.util.Date;
import org.apache.lucene.search.Query;
import org.hibernate.search.annotations.Analyze;
import org.hibernate.search.annotations.DocumentId;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.FieldBridge;
import org.hibernate.search.annotations.Index;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.Parameter;
import org.hibernate.search.annotations.Store;
import org.hibernate.search.bridge.builtin.NumericEncodingDateBridge;
import org.hibernate.search.bridge.util.impl.NumericFieldUtils;
import org.hibernate.search.testsupport.TestForIssue;
import org.hibernate.search.testsupport.junit.SearchFactoryHolder;
import org.hibernate.search.testsupport.junit.SearchITHelper;
import org.junit.Rule;
import org.junit.Test;

@TestForIssue(jiraKey="HSEARCH-1825")
public class NullEncodingTwoWayFieldBridgeTest {
    @Rule
    public final SearchFactoryHolder sfHolder = new SearchFactoryHolder(Sample.class).withProperty("hibernate.search.default_null_token", "-1");
    private final SearchITHelper helper = new SearchITHelper(this.sfHolder);

    @Test
    public void testIndexingWithNullEncodingFieldBridge() {
        Sample entity = new Sample();
        entity.id = 1L;
        entity.description = "null date";
        entity.deletionDate = null;
        this.helper.add(entity);
        Query termQuery = NumericFieldUtils.createExactMatchQuery((String)"deletionDate", (Object)Long.parseLong("-1"));
        this.helper.assertThat(termQuery).from(Sample.class).hasResultSize(1);
    }

    @Indexed
    static class Sample {
        @DocumentId
        long id;
        @Field
        String description;
        @Field(store=Store.YES, index=Index.YES, analyze=Analyze.NO, indexNullAs="__DEFAULT_NULL_TOKEN__", bridge=@FieldBridge(impl=NumericEncodingDateBridge.class, params={@Parameter(name="resolution", value="MINUTE")}))
        private Date deletionDate;

        Sample() {
        }
    }
}

