/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.bridge.util;

import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import org.hibernate.search.bridge.util.impl.NumericFieldUtils;
import org.hibernate.search.exception.SearchException;
import org.hibernate.search.testsupport.TestForIssue;
import org.junit.Assert;
import org.junit.Test;

@TestForIssue(jiraKey="HSEARCH-2188")
public class NumericFieldUtilsTest {
    @Test
    public void testShouldRequireNumericRangeQuery() {
        for (Object val : this.getNumericTestValues()) {
            Assert.assertTrue((String)("Value of type " + val.getClass() + " should require numeric range query"), (boolean)NumericFieldUtils.requiresNumericRangeQuery((Object)val));
        }
    }

    @Test
    public void testShouldNotRequireNumericRangeQuery() {
        Assert.assertFalse((String)"null value should not require numeric range query", (boolean)NumericFieldUtils.requiresNumericRangeQuery(null));
        for (Object val : this.getNonNumericTestValues()) {
            Assert.assertFalse((String)("Value of type '" + val.getClass() + "' should not require numeric range query"), (boolean)NumericFieldUtils.requiresNumericRangeQuery((Object)val));
        }
    }

    @Test
    public void testShouldCreateExactMatchQuery() {
        for (Object val : this.getNumericTestValues()) {
            try {
                NumericFieldUtils.createExactMatchQuery((String)"numField", (Object)val);
            }
            catch (SearchException e) {
                Assert.fail((String)("Should create exact match query for value of type " + val.getClass()));
            }
        }
    }

    @Test
    public void testShouldNotCreateExactMatchQuery() {
        SearchException nullEx = null;
        try {
            NumericFieldUtils.createExactMatchQuery((String)"nonNumField", null);
        }
        catch (SearchException e) {
            nullEx = e;
        }
        Assert.assertNotNull((String)"Should not create exact match query for null value", (Object)((Object)nullEx));
        for (Object val : this.getNonNumericTestValues()) {
            SearchException caught = null;
            try {
                NumericFieldUtils.createExactMatchQuery((String)"nonNumField", (Object)val);
            }
            catch (SearchException e) {
                caught = e;
            }
            Assert.assertNotNull((String)("Should not create exact match query for value of type " + val.getClass()), (Object)((Object)caught));
        }
    }

    private Object[] getNumericTestValues() {
        Object[] numericValues = new Object[]{40.5, Byte.valueOf("100"), (short)4, 20L, 10, Float.valueOf(30.5f), new Date(), this.nowCalendar()};
        return numericValues;
    }

    private Object[] getNonNumericTestValues() {
        Object[] nonNumericValues = new Object[]{"", BigDecimal.ONE};
        return nonNumericValues;
    }

    private Calendar nowCalendar() {
        return GregorianCalendar.getInstance(TimeZone.getTimeZone("UTC"), Locale.ENGLISH);
    }
}

