/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.configuration.mutablefactory;

import org.apache.lucene.analysis.standard.StandardTokenizerFactory;
import org.hibernate.search.analyzer.impl.LuceneAnalyzerReference;
import org.hibernate.search.analyzer.spi.AnalyzerReference;
import org.hibernate.search.annotations.AnalyzerDef;
import org.hibernate.search.annotations.DocumentId;
import org.hibernate.search.annotations.FullTextFilterDef;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.TokenizerDef;
import org.hibernate.search.engine.impl.AnalyzerRegistry;
import org.hibernate.search.engine.impl.FilterDef;
import org.hibernate.search.engine.integration.impl.ExtendedSearchIntegrator;
import org.hibernate.search.engine.integration.impl.SearchIntegration;
import org.hibernate.search.filter.ShardSensitiveOnlyFilter;
import org.hibernate.search.spi.SearchIntegrator;
import org.hibernate.search.spi.impl.SearchFactoryState;
import org.hibernate.search.testsupport.TestForIssue;
import org.hibernate.search.testsupport.junit.SearchIntegratorResource;
import org.hibernate.search.testsupport.setup.SearchConfigurationForTest;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;

@TestForIssue(jiraKey="HSEARCH-1824")
public class DefinitionsOnHotRebootTest {
    @Rule
    public SearchIntegratorResource integratorResource = new SearchIntegratorResource();

    @Test
    public void notForgettingDefinedFilters() {
        ExtendedSearchIntegrator sf = this.integratorResource.create(new SearchConfigurationForTest().addClass(A.class));
        int defaultFilterCount = this.countFilters((SearchIntegrator)sf);
        sf.addClasses(new Class[]{B.class});
        Assert.assertEquals((long)(defaultFilterCount + 1), (long)this.countFilters((SearchIntegrator)sf));
        Assert.assertTrue((boolean)this.filterExists((SearchIntegrator)sf, "anyFilter"));
        sf.addClasses(new Class[]{C.class});
        Assert.assertEquals((long)(defaultFilterCount + 2), (long)this.countFilters((SearchIntegrator)sf));
        Assert.assertTrue((boolean)this.filterExists((SearchIntegrator)sf, "anyFilter"));
        Assert.assertTrue((boolean)this.filterExists((SearchIntegrator)sf, "anotherFilter"));
    }

    @Test
    public void notForgettingDefinedAnalyzers() {
        ExtendedSearchIntegrator sf = this.integratorResource.create(new SearchConfigurationForTest().addClass(A.class));
        int defaultAnalyzerCount = this.countAnalyzers((SearchIntegrator)sf);
        sf.addClasses(new Class[]{B.class});
        Assert.assertEquals((long)(defaultAnalyzerCount + 1), (long)this.countAnalyzers((SearchIntegrator)sf));
        Assert.assertTrue((boolean)this.analyzerExists((SearchIntegrator)sf, "anAnalyzer"));
        sf.addClasses(new Class[]{C.class});
        Assert.assertEquals((long)(defaultAnalyzerCount + 2), (long)this.countAnalyzers((SearchIntegrator)sf));
        Assert.assertTrue((boolean)this.analyzerExists((SearchIntegrator)sf, "anAnalyzer"));
        Assert.assertTrue((boolean)this.analyzerExists((SearchIntegrator)sf, "anotherAnalyzer"));
    }

    private boolean analyzerExists(SearchIntegrator sf, String analyzerName) {
        for (SearchIntegration integration : ((ExtendedSearchIntegrator)sf.unwrap(ExtendedSearchIntegrator.class)).getIntegrations().values()) {
            AnalyzerRegistry registry = integration.getAnalyzerRegistry();
            AnalyzerReference analyzerReference = registry.getAnalyzerReference(analyzerName);
            if (analyzerReference == null) continue;
            if (analyzerReference.is(LuceneAnalyzerReference.class)) {
                return ((LuceneAnalyzerReference)analyzerReference.unwrap(LuceneAnalyzerReference.class)).getAnalyzer() != null;
            }
            return true;
        }
        return false;
    }

    private int countAnalyzers(SearchIntegrator sf) {
        int count = 0;
        for (SearchIntegration integration : ((ExtendedSearchIntegrator)sf.unwrap(ExtendedSearchIntegrator.class)).getIntegrations().values()) {
            AnalyzerRegistry registry = integration.getAnalyzerRegistry();
            count += registry.getNamedAnalyzerReferences().size();
        }
        return count;
    }

    private boolean filterExists(SearchIntegrator sf, String filterName) {
        FilterDef filterDef = (FilterDef)((SearchFactoryState)sf.unwrap(SearchFactoryState.class)).getFilterDefinitions().get(filterName);
        return filterDef != null;
    }

    private int countFilters(SearchIntegrator sf) {
        return ((SearchFactoryState)sf.unwrap(SearchFactoryState.class)).getFilterDefinitions().size();
    }

    @Indexed
    @FullTextFilterDef(name="anotherFilter", impl=ShardSensitiveOnlyFilter.class)
    @AnalyzerDef(name="anotherAnalyzer", tokenizer=@TokenizerDef(factory=StandardTokenizerFactory.class))
    static class C {
        @DocumentId
        Long id;

        C() {
        }
    }

    @Indexed
    @FullTextFilterDef(name="anyFilter", impl=ShardSensitiveOnlyFilter.class)
    @AnalyzerDef(name="anAnalyzer", tokenizer=@TokenizerDef(factory=StandardTokenizerFactory.class))
    static class B {
        @DocumentId
        Long id;

        B() {
        }
    }

    @Indexed
    static class A {
        @DocumentId
        Long id;

        A() {
        }
    }
}

