/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.facet;

import org.hibernate.search.annotations.Analyze;
import org.hibernate.search.annotations.DocumentId;
import org.hibernate.search.annotations.Facet;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.query.dsl.QueryBuilder;
import org.hibernate.search.query.engine.spi.HSQuery;
import org.hibernate.search.query.facet.FacetingRequest;
import org.hibernate.search.testsupport.TestForIssue;
import org.hibernate.search.testsupport.junit.SearchFactoryHolder;
import org.hibernate.search.testsupport.junit.SearchITHelper;
import org.junit.Rule;
import org.junit.Test;

@TestForIssue(jiraKey="HSEARCH-2955")
public class NoIndexedValueFacetingTest {
    @Rule
    public final SearchFactoryHolder sfHolder = new SearchFactoryHolder(FacetedEntity.class);
    private final SearchITHelper helper = new SearchITHelper(this.sfHolder);

    @Test
    public void discrete_emptyIndex() {
        this.doDiscreteFacetingQuery();
    }

    @Test
    public void integerRange_emptyIndex() {
        this.doIntegerRangeFacetingQuery();
    }

    @Test
    public void floatRange_emptyIndex() {
        this.doFloatRangeFacetingQuery();
    }

    @Test
    public void discrete_noIndexedValueForFacet() {
        this.helper.index(new FacetedEntity(0, null, 0, Float.valueOf(0.01f)), new FacetedEntity(1, null, 1, Float.valueOf(42.01f)));
        this.doDiscreteFacetingQuery();
    }

    @Test
    public void integerRange_noIndexedValueForFacet() {
        this.helper.index(new FacetedEntity(0, "first", null, Float.valueOf(0.01f)), new FacetedEntity(1, "second", null, Float.valueOf(42.01f)));
        this.doIntegerRangeFacetingQuery();
    }

    @Test
    public void floatRange_noIndexedValueForFacet() {
        this.helper.index(new FacetedEntity(0, "first", 0, null), new FacetedEntity(1, "second", 1, null));
        this.doFloatRangeFacetingQuery();
    }

    private void doDiscreteFacetingQuery() {
        QueryBuilder qb = this.helper.queryBuilder(FacetedEntity.class);
        FacetingRequest request = qb.facet().name("myRequest").onField("stringField").discrete().includeZeroCounts(false).createFacetingRequest();
        HSQuery hsQuery = this.helper.hsQuery(FacetedEntity.class);
        hsQuery.getFacetManager().enableFaceting(request);
        this.helper.assertThat(hsQuery).facets("myRequest").isEmpty();
    }

    private void doIntegerRangeFacetingQuery() {
        QueryBuilder qb = this.helper.queryBuilder(FacetedEntity.class);
        FacetingRequest request = qb.facet().name("myRequest").onField("integerField").range().from((Object)0).to((Object)1000).from((Object)1001).to((Object)1500).includeZeroCounts(true).createFacetingRequest();
        HSQuery hsQuery = this.helper.hsQuery(FacetedEntity.class);
        hsQuery.getFacetManager().enableFaceting(request);
        this.helper.assertThat(hsQuery).facets("myRequest").includes("[0, 1000]", 0).includes("[1001, 1500]", 0).only();
    }

    private void doFloatRangeFacetingQuery() {
        QueryBuilder qb = this.helper.queryBuilder(FacetedEntity.class);
        FacetingRequest request = qb.facet().name("myRequest").onField("floatField").range().from((Object)Float.valueOf(0.0f)).to((Object)Float.valueOf(1000.0f)).excludeLimit().from((Object)Float.valueOf(1000.0f)).to((Object)Float.valueOf(1500.0f)).excludeLimit().includeZeroCounts(true).createFacetingRequest();
        HSQuery hsQuery = this.helper.hsQuery(FacetedEntity.class);
        hsQuery.getFacetManager().enableFaceting(request);
        this.helper.assertThat(hsQuery).facets("myRequest").includes("[0.0, 1000.0)", 0).includes("[1000.0, 1500.0)", 0).only();
    }

    @Indexed
    private static class FacetedEntity {
        @DocumentId
        private final int id;
        @Field(analyze=Analyze.NO)
        @Facet
        private final String stringField;
        @Field(analyze=Analyze.NO)
        @Facet
        private final Integer integerField;
        @Field(analyze=Analyze.NO)
        @Facet
        private final Float floatField;

        public FacetedEntity(int id, String stringField, Integer integerField, Float floatField) {
            this.id = id;
            this.stringField = stringField;
            this.integerField = integerField;
            this.floatField = floatField;
        }
    }
}

