/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.analyzer.analyzerdef;

import java.util.Map;
import org.apache.lucene.analysis.core.LowerCaseFilterFactory;
import org.apache.lucene.analysis.standard.StandardTokenizerFactory;
import org.assertj.core.api.Assertions;
import org.hibernate.search.analyzer.impl.LuceneAnalyzerReference;
import org.hibernate.search.analyzer.spi.AnalyzerReference;
import org.hibernate.search.annotations.AnalyzerDef;
import org.hibernate.search.annotations.DocumentId;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.NormalizerDef;
import org.hibernate.search.annotations.TokenFilterDef;
import org.hibernate.search.annotations.TokenizerDef;
import org.hibernate.search.engine.impl.AnalyzerRegistry;
import org.hibernate.search.engine.impl.NormalizerRegistry;
import org.hibernate.search.engine.integration.impl.ExtendedSearchIntegrator;
import org.hibernate.search.engine.integration.impl.SearchIntegration;
import org.hibernate.search.engine.spi.EntityIndexBinding;
import org.hibernate.search.exception.SearchException;
import org.hibernate.search.indexes.spi.IndexManagerType;
import org.hibernate.search.testsupport.junit.SearchFactoryHolder;
import org.hibernate.search.testsupport.junit.SearchIntegratorResource;
import org.hibernate.search.testsupport.junit.SkipOnElasticsearch;
import org.hibernate.search.testsupport.setup.SearchConfigurationForTest;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.ExpectedException;

public class AnalyzerDefAnnotationTest {
    @Rule
    public ExpectedException thrown = ExpectedException.none();
    @Rule
    public SearchFactoryHolder sfHolder = new SearchFactoryHolder(Sample.class);
    @Rule
    public SearchIntegratorResource integratorResource = new SearchIntegratorResource();

    @Test
    public void shouldBePossibleToAnnotatePackage() throws Exception {
        this.assertAnalyzerExists("package-analyzer");
        this.assertNormalizerExists("package-normalizer");
    }

    @Test
    public void shouldBePossibleToAnnotateClass() throws Exception {
        this.assertAnalyzerExists("class-analyzer");
        this.assertNormalizerExists("class-normalizer");
    }

    @Test
    @Category(value={SkipOnElasticsearch.class})
    public void shouldContainOnlyTheDefinedAnalyzers() throws Exception {
        ExtendedSearchIntegrator factory = this.sfHolder.getSearchFactory();
        IndexManagerType indexManagerType = ((EntityIndexBinding)factory.getIndexBindings().get(Sample.class)).getIndexManagerType();
        Map analyzerReferences = factory.getIntegration(indexManagerType).getAnalyzerRegistry().getNamedAnalyzerReferences();
        Assertions.assertThat(analyzerReferences.keySet()).containsOnly((Object[])new String[]{"package-analyzer", "class-analyzer"});
        Map normalizerReferences = factory.getIntegration(indexManagerType).getNormalizerRegistry().getNamedNormalizerReferences();
        Assertions.assertThat(normalizerReferences.keySet()).containsOnly((Object[])new String[]{"package-normalizer", "class-normalizer"});
    }

    @Test
    public void shouldNotBePossibleToHaveTwoAnalyzerDefsWithTheSameName() throws Exception {
        this.thrown.expect(SearchException.class);
        SearchConfigurationForTest cfg = new SearchConfigurationForTest();
        cfg.addClass(SampleWithAnalyzerError.class);
        this.integratorResource.create(cfg);
    }

    @Test
    public void shouldNotBePossibleToHaveTwoNormalizerDefsWithTheSameName() throws Exception {
        this.thrown.expect(SearchException.class);
        SearchConfigurationForTest cfg = new SearchConfigurationForTest();
        cfg.addClass(SampleWithNormalizerError.class);
        this.integratorResource.create(cfg);
    }

    private void assertAnalyzerExists(String analyzerName) {
        for (SearchIntegration integration : this.sfHolder.getSearchFactory().getIntegrations().values()) {
            AnalyzerRegistry registry = integration.getAnalyzerRegistry();
            AnalyzerReference analyzerReference = registry.getAnalyzerReference(analyzerName);
            if (analyzerReference == null) continue;
            if (analyzerReference.is(LuceneAnalyzerReference.class)) {
                Assertions.assertThat((Object)((LuceneAnalyzerReference)analyzerReference.unwrap(LuceneAnalyzerReference.class)).getAnalyzer()).isNotNull();
            }
            return;
        }
        Assert.fail((String)("Analyzer does not exist: " + analyzerName));
    }

    private void assertNormalizerExists(String normalizerName) {
        for (SearchIntegration integration : this.sfHolder.getSearchFactory().getIntegrations().values()) {
            NormalizerRegistry registry = integration.getNormalizerRegistry();
            AnalyzerReference normalizerReference = registry.getNamedNormalizerReference(normalizerName);
            if (normalizerReference == null) continue;
            if (normalizerReference.is(LuceneAnalyzerReference.class)) {
                Assertions.assertThat((Object)((LuceneAnalyzerReference)normalizerReference.unwrap(LuceneAnalyzerReference.class)).getAnalyzer()).isNotNull();
            }
            return;
        }
        Assert.fail((String)("Normalizer does not exist: " + normalizerName));
    }

    @Indexed
    @NormalizerDef(name="package-normalizer", filters={@TokenFilterDef(factory=LowerCaseFilterFactory.class)})
    static class SampleWithNormalizerError {
        @DocumentId
        final long id = 1L;
        @Field
        final String description = "";

        SampleWithNormalizerError() {
        }
    }

    @Indexed
    @AnalyzerDef(name="package-analyzer", tokenizer=@TokenizerDef(factory=StandardTokenizerFactory.class))
    static class SampleWithAnalyzerError {
        @DocumentId
        final long id = 1L;
        @Field
        final String description = "";

        SampleWithAnalyzerError() {
        }
    }

    @Indexed
    @AnalyzerDef(name="class-analyzer", tokenizer=@TokenizerDef(factory=StandardTokenizerFactory.class))
    @NormalizerDef(name="class-normalizer", filters={@TokenFilterDef(factory=LowerCaseFilterFactory.class)})
    static class Sample {
        @DocumentId
        long id;
        @Field
        String description;

        Sample() {
        }
    }
}

