/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.analyzer.common;

import java.lang.invoke.MethodHandles;
import java.util.HashSet;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.search.Query;
import org.hibernate.search.engine.integration.impl.ExtendedSearchIntegrator;
import org.hibernate.search.spi.IndexedTypeIdentifier;
import org.hibernate.search.spi.impl.PojoIndexedTypeIdentifier;
import org.hibernate.search.test.analyzer.common.Article;
import org.hibernate.search.test.analyzer.common.MyComponent;
import org.hibernate.search.test.analyzer.common.MyEntity;
import org.hibernate.search.testsupport.TestConstants;
import org.hibernate.search.testsupport.junit.SearchFactoryHolder;
import org.hibernate.search.testsupport.junit.SearchITHelper;
import org.hibernate.search.testsupport.junit.SkipOnElasticsearch;
import org.hibernate.search.util.AnalyzerUtils;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SkipOnElasticsearch.class})
public class AnalyzerTest {
    private static final Log log = LoggerFactory.make((MethodHandles.Lookup)MethodHandles.lookup());
    private static final IndexedTypeIdentifier MY_ENTITY_TYPE_ID = PojoIndexedTypeIdentifier.convertFromLegacy(MyEntity.class);
    @Rule
    public final SearchFactoryHolder sfHolder = new SearchFactoryHolder(MyEntity.class, Article.class);
    private final SearchITHelper helper = new SearchITHelper(this.sfHolder);

    @Test
    public void testAnalyzerDiscriminator() throws Exception {
        Article germanArticle = new Article();
        germanArticle.setId(1);
        germanArticle.setLanguage("de");
        germanArticle.setText("aufeinanderschl\u00fcgen");
        HashSet<Article> references = new HashSet<Article>();
        references.add(germanArticle);
        Article englishArticle = new Article();
        englishArticle.setId(2);
        englishArticle.setLanguage("en");
        englishArticle.setText("acknowledgment");
        englishArticle.setReferences(references);
        this.helper.index(englishArticle, germanArticle);
        QueryParser parser = new QueryParser("references.text", TestConstants.standardAnalyzer);
        Query luceneQuery = parser.parse("aufeinanderschlug");
        this.helper.assertThat(luceneQuery).matchesExactlyIds(Integer.valueOf(2));
        parser = new QueryParser("text", TestConstants.standardAnalyzer);
        luceneQuery = parser.parse("acknowledg");
        this.helper.assertThat(luceneQuery).matchesExactlyIds(Integer.valueOf(2));
    }

    @Test
    public void testScopedAnalyzers() throws Exception {
        MyEntity en = new MyEntity();
        en.setId(1);
        en.setEntity("Entity");
        en.setField("Field");
        en.setProperty("Property");
        en.setComponent(new MyComponent());
        en.getComponent().setComponentProperty("component property");
        this.helper.index(en);
        QueryParser parser = new QueryParser("id", TestConstants.standardAnalyzer);
        Query luceneQuery = parser.parse("entity:alarm");
        this.helper.assertThat(luceneQuery).matchesExactlyIds(Integer.valueOf(1));
        luceneQuery = parser.parse("property:cat");
        this.helper.assertThat(luceneQuery).matchesExactlyIds(Integer.valueOf(1));
        luceneQuery = parser.parse("field:energy");
        this.helper.assertThat(luceneQuery).matchesExactlyIds(Integer.valueOf(1));
        luceneQuery = parser.parse("component.componentProperty:noise");
        this.helper.assertThat(luceneQuery).matchesExactlyIds(Integer.valueOf(1));
    }

    @Test
    public void testScopedAnalyzersFromSearchFactory() throws Exception {
        ExtendedSearchIntegrator searchFactory = this.sfHolder.getSearchFactory();
        Analyzer analyzer = searchFactory.getAnalyzer(MY_ENTITY_TYPE_ID);
        Token[] tokens = AnalyzerUtils.tokensFromAnalysis((Analyzer)analyzer, (String)"entity", (String)"");
        AnalyzerTest.assertTokensEqual(tokens, new String[]{"alarm", "dog", "performance"});
        tokens = AnalyzerUtils.tokensFromAnalysis((Analyzer)analyzer, (String)"property", (String)"");
        AnalyzerTest.assertTokensEqual(tokens, new String[]{"sound", "cat", "speed"});
        tokens = AnalyzerUtils.tokensFromAnalysis((Analyzer)analyzer, (String)"field", (String)"");
        AnalyzerTest.assertTokensEqual(tokens, new String[]{"music", "elephant", "energy"});
        tokens = AnalyzerUtils.tokensFromAnalysis((Analyzer)analyzer, (String)"component.componentProperty", (String)"");
        AnalyzerTest.assertTokensEqual(tokens, new String[]{"noise", "mouse", "light"});
        try {
            searchFactory.getAnalyzer((IndexedTypeIdentifier)null);
        }
        catch (IllegalArgumentException iae) {
            log.debug((Object)"success");
        }
        try {
            searchFactory.getAnalyzer(PojoIndexedTypeIdentifier.convertFromLegacy(null));
        }
        catch (IllegalArgumentException iae) {
            log.debug((Object)"success");
        }
        try {
            searchFactory.getAnalyzer(PojoIndexedTypeIdentifier.convertFromLegacy(String.class));
        }
        catch (IllegalArgumentException iae) {
            log.debug((Object)"success");
        }
    }

    @Test
    public void testNotAnalyzedFieldAndScopedAnalyzer() throws Exception {
        ExtendedSearchIntegrator searchFactory = this.sfHolder.getSearchFactory();
        Analyzer analyzer = searchFactory.getAnalyzer(MY_ENTITY_TYPE_ID);
        Token[] tokens = AnalyzerUtils.tokensFromAnalysis((Analyzer)analyzer, (String)"notAnalyzed", (String)"pass through");
        AnalyzerTest.assertTokensEqual(tokens, new String[]{"pass through"});
    }

    public static void assertTokensEqual(Token[] tokens, String[] strings) {
        Assert.assertEquals((long)strings.length, (long)tokens.length);
        for (int i = 0; i < tokens.length; ++i) {
            Assert.assertEquals((String)("index " + i), (Object)strings[i], (Object)AnalyzerUtils.getTermText((Token)tokens[i]));
        }
    }
}

