/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.bridge;

import org.hibernate.search.engine.integration.impl.ExtendedSearchIntegrator;
import org.hibernate.search.test.bridge.DynamicIndexedValueHolder;
import org.hibernate.search.testsupport.junit.SearchFactoryHolder;
import org.hibernate.search.testsupport.junit.SearchITHelper;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;

public class PropertiesExampleBridgeTest {
    @Rule
    public final SearchFactoryHolder sfHolder = new SearchFactoryHolder(DynamicIndexedValueHolder.class).withProperty("hibernate.search.all.elasticsearch.dynamic_mapping", "true");
    private final SearchITHelper helper = new SearchITHelper(this.sfHolder);

    @Test
    public void testPropertiesIndexing() {
        ExtendedSearchIntegrator searchFactory = this.sfHolder.getSearchFactory();
        Assert.assertNotNull((Object)searchFactory.getIndexManagerHolder().getIndexManager("all"));
        this.helper.add(new DynamicIndexedValueHolder("1").property("age", "227").property("name", "Thorin").property("surname", "Oakenshield").property("race", "dwarf"));
        this.helper.assertThat().from(DynamicIndexedValueHolder.class).projecting("value.surname").matchesExactlySingleProjections("Oakenshield");
    }
}

