/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.configuration.sharding;

import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.lucene.document.Document;
import org.hibernate.search.annotations.DocumentId;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.engine.impl.MutableSearchFactory;
import org.hibernate.search.engine.spi.EntityIndexBinding;
import org.hibernate.search.exception.SearchException;
import org.hibernate.search.filter.FullTextFilterImplementor;
import org.hibernate.search.indexes.impl.IndexShardingStrategyIndexManagerSelector;
import org.hibernate.search.indexes.impl.NotShardedIndexManagerSelector;
import org.hibernate.search.indexes.spi.DirectoryBasedIndexManager;
import org.hibernate.search.indexes.spi.IndexManager;
import org.hibernate.search.indexes.spi.IndexManagerSelector;
import org.hibernate.search.spi.BuildContext;
import org.hibernate.search.spi.IndexedTypeIdentifier;
import org.hibernate.search.spi.impl.PojoIndexedTypeIdentifier;
import org.hibernate.search.store.IndexShardingStrategy;
import org.hibernate.search.store.ShardIdentifierProvider;
import org.hibernate.search.store.impl.FSDirectoryProvider;
import org.hibernate.search.store.impl.IdHashShardingStrategy;
import org.hibernate.search.test.util.impl.ExpectedLog4jLog;
import org.hibernate.search.testsupport.TestConstants;
import org.hibernate.search.testsupport.TestForIssue;
import org.hibernate.search.testsupport.junit.SearchIntegratorResource;
import org.hibernate.search.testsupport.junit.SkipOnElasticsearch;
import org.hibernate.search.testsupport.setup.SearchConfigurationForTest;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@TestForIssue(jiraKey="HSEARCH-472")
public class ShardingConfigurationTest {
    @Rule
    public ExpectedLog4jLog logged = ExpectedLog4jLog.create();
    @Rule
    public SearchIntegratorResource integratorResource = new SearchIntegratorResource();

    @Test
    public void testNoShardingIsUsedPerDefault() {
        MutableSearchFactory searchFactory = this.getSearchFactory(Collections.emptyMap());
        EntityIndexBinding entityIndexBinding = (EntityIndexBinding)searchFactory.getIndexBindings().get(Foo.class);
        IndexManagerSelector selector = entityIndexBinding.getIndexManagerSelector();
        Assert.assertEquals((String)"No sharding should be configured. Number of shards and sharding strategy are not set", NotShardedIndexManagerSelector.class, selector.getClass());
        Assert.assertEquals((String)"There should be exactly one shard", (long)1L, (long)selector.all().size());
    }

    @Test
    public void testSettingNumberOfShardsOnlySelectsIdHashSharding() {
        HashMap<String, String> shardingProperties = new HashMap<String, String>();
        shardingProperties.put("hibernate.search.default.sharding_strategy.nbr_of_shards", "2");
        MutableSearchFactory searchFactory = this.getSearchFactory(shardingProperties);
        EntityIndexBinding entityIndexBinding = (EntityIndexBinding)searchFactory.getIndexBindings().get(Foo.class);
        IndexManagerSelector selector = entityIndexBinding.getIndexManagerSelector();
        Assert.assertEquals((String)"IndexShardingStrategyIndexManagerSelector should be used due to number of shards being set", IndexShardingStrategyIndexManagerSelector.class, selector.getClass());
        Assert.assertEquals((String)"There should be exactly two shards", (long)2L, (long)selector.all().size());
    }

    @Test
    public void testSettingNegativeNumberOfShardsThrowsException() {
        HashMap<String, String> shardingProperties = new HashMap<String, String>();
        shardingProperties.put("hibernate.search.default.sharding_strategy.nbr_of_shards", "-1");
        try {
            this.getSearchFactory(shardingProperties);
            Assert.fail((String)"Factory creation should have failed");
        }
        catch (SearchException e) {
            Assert.assertTrue((String)("Unexpected error message - " + e.getMessage()), (boolean)e.getMessage().startsWith("HSEARCH000191"));
        }
    }

    @Test
    public void testSettingZeroNumberOfShardsThrowsException() {
        HashMap<String, String> shardingProperties = new HashMap<String, String>();
        shardingProperties.put("hibernate.search.default.sharding_strategy.nbr_of_shards", "0");
        try {
            this.getSearchFactory(shardingProperties);
            Assert.fail((String)"Factory creation should have failed");
        }
        catch (SearchException e) {
            Assert.assertTrue((String)("Unexpected error message - " + e.getMessage()), (boolean)e.getMessage().startsWith("HSEARCH000191"));
        }
    }

    @Test
    public void testSettingStringValueAsNumberOfShardsThrowsException() {
        HashMap<String, String> shardingProperties = new HashMap<String, String>();
        shardingProperties.put("hibernate.search.default.sharding_strategy.nbr_of_shards", "snafu");
        try {
            this.getSearchFactory(shardingProperties);
            Assert.fail((String)"Factory creation should have failed");
        }
        catch (SearchException e) {
            Assert.assertTrue((String)("Unexpected error message - " + e.getMessage()), (boolean)e.getMessage().startsWith("HSEARCH000192"));
        }
    }

    @Test
    public void testSettingIdHashShardingStrategyWithoutNumberOfShards() {
        HashMap<String, String> shardingProperties = new HashMap<String, String>();
        shardingProperties.put("hibernate.search.default.sharding_strategy", IdHashShardingStrategy.class.getName());
        this.logged.expectMessage("HSEARCH000193", "IdHashShardingStrategy");
        EntityIndexBinding entityIndexBinding = (EntityIndexBinding)this.getSearchFactory(shardingProperties).getIndexBindings().get(Foo.class);
        Assert.assertTrue((String)"Without specifying number of shards, 1 should be assumed", (entityIndexBinding.getIndexManagerSelector().all().size() == 1 ? 1 : 0) != 0);
    }

    @Test
    public void testSettingCustomIndexShardingStrategy() {
        HashMap<String, String> shardingProperties = new HashMap<String, String>();
        shardingProperties.put("hibernate.search.default.sharding_strategy", DummyIndexShardingStrategy.class.getName());
        shardingProperties.put("hibernate.search.default.sharding_strategy.nbr_of_shards", "2");
        MutableSearchFactory searchFactory = this.getSearchFactory(shardingProperties);
        EntityIndexBinding entityIndexBinding = (EntityIndexBinding)searchFactory.getIndexBindings().get(Foo.class);
        IndexManagerSelector selector = entityIndexBinding.getIndexManagerSelector();
        Assert.assertEquals((String)"Explicitly set sharding strategy ignored", IndexShardingStrategyIndexManagerSelector.class, selector.getClass());
        Assert.assertEquals((String)"Number of shards is explicitly set, but ignored", (long)2L, (long)entityIndexBinding.getIndexManagerSelector().all().size());
        Assert.assertEquals((String)"Explicitly set sharding strategy ignored", (long)0L, (long)entityIndexBinding.getIndexManagerSelector().forExisting((IndexedTypeIdentifier)new PojoIndexedTypeIdentifier(Foo.class), null, null).size());
    }

    @Test
    public void testSettingCustomShardIdentifierProvider() {
        HashMap<String, String> shardingProperties = new HashMap<String, String>();
        shardingProperties.put("hibernate.search.default.sharding_strategy", DummyShardIdentifierProvider.class.getName());
        MutableSearchFactory searchFactory = this.getSearchFactory(shardingProperties);
        EntityIndexBinding entityIndexBinding = (EntityIndexBinding)searchFactory.getIndexBindings().get(Foo.class);
        Assert.assertEquals((String)"Explicitly set shard id provider ignored", DummyShardIdentifierProvider.class, entityIndexBinding.getShardIdentifierProvider().getClass());
    }

    @Test
    public void testSettingUnknownStrategyClassThrowsException() {
        HashMap<String, String> shardingProperties = new HashMap<String, String>();
        shardingProperties.put("hibernate.search.default.sharding_strategy", "snafu");
        try {
            this.getSearchFactory(shardingProperties);
            Assert.fail((String)"Factory creation should have failed");
        }
        catch (SearchException e) {
            Assert.assertTrue((String)("Unexpected error message - " + e.getMessage()), (boolean)e.getMessage().startsWith("HSEARCH000194"));
        }
    }

    @Test
    public void testSettingCustomShardIdentifierProviderWithExplicitIndexName() {
        HashMap<String, String> shardingProperties = new HashMap<String, String>();
        shardingProperties.put("hibernate.search.foo.sharding_strategy", DummyShardIdentifierProvider.class.getName());
        MutableSearchFactory searchFactory = this.getSearchFactory(shardingProperties);
        EntityIndexBinding entityIndexBinding = (EntityIndexBinding)searchFactory.getIndexBindings().get(Foo.class);
        Assert.assertEquals((String)"Explicitly set shard id provider ignored", DummyShardIdentifierProvider.class, entityIndexBinding.getShardIdentifierProvider().getClass());
    }

    @Test
    @Category(value={SkipOnElasticsearch.class})
    public void testConfiguringDynamicallyCreatedShardViaConfiguration() {
        HashMap<String, String> shardingProperties = new HashMap<String, String>();
        shardingProperties.put("hibernate.search.foo.sharding_strategy", DummyShardIdentifierProvider.class.getName());
        shardingProperties.put("hibernate.search.foo.snafu.directory_provider", "filesystem");
        Path indexDir = TestConstants.getIndexDirectory(ShardingConfigurationTest.getTargetDir());
        shardingProperties.put("hibernate.search.foo.snafu.indexBase", indexDir.toAbsolutePath().toString());
        MutableSearchFactory searchFactory = this.getSearchFactory(shardingProperties);
        EntityIndexBinding entityIndexBinding = (EntityIndexBinding)searchFactory.getIndexBindings().get(Foo.class);
        Set indexManagers = entityIndexBinding.getIndexManagerSelector().all();
        Assert.assertTrue((String)"There should be two index managers", (indexManagers.size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Unexpected index manager type", (boolean)(indexManagers.iterator().next() instanceof DirectoryBasedIndexManager));
        DirectoryBasedIndexManager directoryBasedIndexManager = (DirectoryBasedIndexManager)indexManagers.iterator().next();
        Assert.assertTrue((String)("Unexpected directory provider type: " + directoryBasedIndexManager.getDirectoryProvider().getClass()), (boolean)(directoryBasedIndexManager.getDirectoryProvider() instanceof FSDirectoryProvider));
    }

    private MutableSearchFactory getSearchFactory(Map<String, String> shardingProperties) {
        SearchConfigurationForTest configuration = new SearchConfigurationForTest();
        for (Map.Entry<String, String> entry : shardingProperties.entrySet()) {
            configuration.addProperty(entry.getKey(), entry.getValue());
        }
        configuration.addClass(Foo.class);
        return (MutableSearchFactory)this.integratorResource.create(configuration);
    }

    private static Path getTargetDir() {
        URI classesDirUri;
        try {
            classesDirUri = ShardingConfigurationTest.class.getProtectionDomain().getCodeSource().getLocation().toURI();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        return Paths.get(classesDirUri).getParent();
    }

    public static class DummyShardIdentifierProvider
    implements ShardIdentifierProvider {
        private final Set<String> shards = new HashSet<String>();

        public void initialize(Properties properties, BuildContext buildContext) {
            this.shards.add("snafu");
        }

        public String getShardIdentifier(Class<?> entityType, Serializable id, String idAsString, Document document) {
            return null;
        }

        public Set<String> getShardIdentifiersForQuery(FullTextFilterImplementor[] fullTextFilters) {
            return this.shards;
        }

        public Set<String> getShardIdentifiersForDeletion(Class<?> entity, Serializable id, String idInString) {
            return null;
        }

        public Set<String> getAllShardIdentifiers() {
            return this.shards;
        }
    }

    public static class DummyIndexShardingStrategy
    implements IndexShardingStrategy {
        private IndexManager[] indexManagers;

        public void initialize(Properties properties, IndexManager[] indexManagers) {
            this.indexManagers = indexManagers;
        }

        public IndexManager[] getIndexManagersForAllShards() {
            return this.indexManagers;
        }

        public IndexManager getIndexManagerForAddition(Class<?> entity, Serializable id, String idInString, Document document) {
            return null;
        }

        public IndexManager[] getIndexManagersForDeletion(Class<?> entity, Serializable id, String idInString) {
            return null;
        }

        public IndexManager[] getIndexManagersForQuery(FullTextFilterImplementor[] fullTextFilters) {
            return null;
        }
    }

    @Indexed(index="foo")
    public static final class Foo {
        @DocumentId
        long id;
    }
}

