/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.util.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.hibernate.search.testsupport.TestForIssue;
import org.hibernate.search.util.impl.CollectionHelper;
import org.junit.Assert;
import org.junit.Test;

@TestForIssue(jiraKey="HSEARCH-1769")
public class IterableFlatteningTest {
    @Test
    public void testOuterIteratorBeingEmpty() {
        List<Iterable> outer = Arrays.asList(new Iterable[0]);
        Iterable flattened = CollectionHelper.flatten(outer);
        IterableFlatteningTest.assertIterable(flattened).isEmpty();
    }

    @Test
    public void testOuterIteratorBeingEmptyException() {
        List<Iterable> outer = Arrays.asList(new Iterable[0]);
        Iterable flattened = CollectionHelper.flatten(outer);
        Iterator iterator = flattened.iterator();
        try {
            iterator.next();
            Assert.fail((String)"Should have thrown the exception");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    @Test
    public void testInnerIteratorBeingEmpty() {
        List<Iterable> outer = Arrays.asList(Arrays.asList(new Integer[0]), Arrays.asList(new Integer[0]));
        Iterable flattened = CollectionHelper.flatten(outer);
        IterableFlatteningTest.assertIterable(flattened).isEmpty();
    }

    @Test
    public void testInnerIteratorBeingEmptyException() {
        List<Iterable> outer = Arrays.asList(Arrays.asList(new Integer[0]), Arrays.asList(new Integer[0]));
        Iterable flattened = CollectionHelper.flatten(outer);
        Iterator iterator = flattened.iterator();
        try {
            iterator.next();
            Assert.fail((String)"Should have thrown the exception");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    @Test
    public void testInnerIteratorSingleEmpty() {
        List<Integer> workListOne = Arrays.asList(1);
        List<Iterable> outer = Arrays.asList(workListOne);
        Iterable flattened = CollectionHelper.flatten(outer);
        IterableFlatteningTest.assertIterable(flattened).containsExactly(new Object[]{1});
    }

    @Test
    public void testFourElementsIterator() {
        List<Integer> workListOne = Arrays.asList(1, 2);
        List<Integer> workListTwo = Arrays.asList(3, 4);
        List<Iterable> outer = Arrays.asList(workListOne, workListTwo);
        Iterable flattened = CollectionHelper.flatten(outer);
        IterableFlatteningTest.assertIterable(flattened).containsExactly(new Object[]{1, 2, 3, 4});
    }

    private static <T> ListAssert assertIterable(Iterable<T> iterable) {
        Iterator<T> iterator;
        Iterator<T> iterator2 = iterator = iterable == null ? null : iterable.iterator();
        if (iterator == null) {
            return Assertions.assertThat((List)null);
        }
        ArrayList list = new ArrayList();
        iterator.forEachRemaining(list::add);
        return Assertions.assertThat(list);
    }
}

