/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.backend.lucene;

import org.hibernate.search.spi.SearchIntegrator;
import org.hibernate.search.test.backend.lucene.Quote;
import org.hibernate.search.testsupport.BytemanHelper;
import org.hibernate.search.testsupport.junit.SearchITHelper;
import org.hibernate.search.testsupport.junit.SearchIntegratorResource;
import org.hibernate.search.testsupport.junit.SkipOnElasticsearch;
import org.hibernate.search.testsupport.setup.CountingErrorHandler;
import org.hibernate.search.testsupport.setup.SearchConfigurationForTest;
import org.jboss.byteman.contrib.bmunit.BMRule;
import org.jboss.byteman.contrib.bmunit.BMRules;
import org.jboss.byteman.contrib.bmunit.BMUnitRunner;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=BMUnitRunner.class)
@BMRules(rules={@BMRule(name="trackIndexWriterCommit", targetClass="org.apache.lucene.index.IndexWriter", targetMethod="commit()", helper="org.hibernate.search.testsupport.BytemanHelper", action="pushEvent(\"commit\")"), @BMRule(name="trackIndexWriterClose", targetClass="org.apache.lucene.index.IndexWriter", targetMethod="close()", helper="org.hibernate.search.testsupport.BytemanHelper", action="pushEvent(\"close\")"), @BMRule(name="trackUpdatesBeingApplied", targetClass="org.hibernate.search.backend.impl.lucene.LuceneBackendQueueTask", targetMethod="applyUpdates()", helper="org.hibernate.search.testsupport.BytemanHelper", action="pushEvent(\"applyUpdates\")")})
@Category(value={SkipOnElasticsearch.class})
public class ResourcesClosedInOrderTest {
    private static final int NUMBER_ENTITIES = 2;
    @Rule
    public final SearchIntegratorResource integratorResource = new SearchIntegratorResource();
    @Rule
    public final BytemanHelper.BytemanAccessor byteman = BytemanHelper.createAccessor();
    private SearchIntegrator searchIntegrator;
    private final SearchITHelper helper = new SearchITHelper(() -> this.searchIntegrator);

    @Test
    public void asyncExclusiveIndexResourcesOrderedShutdown() {
        this.expectOnConfiguration(true, true, "close", "applyUpdates", "applyUpdates", "close");
    }

    @Test
    public void asyncSharedIndexResourcesOrderedShutdown() {
        this.expectOnConfiguration(true, false, "close", "applyUpdates", "close", "applyUpdates", "close");
    }

    @Test
    public void synchExclusiveIndexResourcesOrderedShutdown() {
        this.expectOnConfiguration(false, true, "close", "applyUpdates", "commit", "applyUpdates", "commit", "close");
    }

    @Test
    public void synchSharedIndexResourcesOrderedShutdown() {
        this.expectOnConfiguration(false, false, "close", "applyUpdates", "close", "applyUpdates", "close");
    }

    private void expectOnConfiguration(boolean async, boolean exclusiveIndexing, String ... expectedStack) {
        SearchConfigurationForTest cfg = new SearchConfigurationForTest();
        cfg.addProperty("hibernate.search.default.worker.execution", async ? "async" : "sync");
        cfg.addProperty("hibernate.search.default.exclusive_index_use", exclusiveIndexing ? "true" : "false");
        cfg.addProperty("hibernate.search.error_handler", CountingErrorHandler.class.getName());
        cfg.addClass(Quote.class);
        this.searchIntegrator = this.integratorResource.create(cfg);
        CountingErrorHandler errorHandler = (CountingErrorHandler)this.searchIntegrator.getErrorHandler();
        this.writeData(2);
        Assert.assertEquals((long)0L, (long)errorHandler.getTotalCount());
        this.searchIntegrator.close();
        for (int i = 0; i < expectedStack.length; ++i) {
            Assert.assertEquals((Object)expectedStack[i], (Object)this.byteman.consumeNextRecordedEvent());
        }
        Assert.assertTrue((boolean)this.byteman.isEventStackEmpty());
    }

    private void writeData(int numberEntities) {
        int entityIdGenerator = 0;
        for (int i = 0; i < numberEntities; ++i) {
            Integer id = entityIdGenerator++;
            Quote quote = new Quote(id, "description");
            this.helper.add(quote);
        }
    }
}

