/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.spi;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.hibernate.annotations.common.reflection.MetadataProvider;
import org.hibernate.annotations.common.reflection.MetadataProviderInjector;
import org.hibernate.annotations.common.reflection.ReflectionManager;
import org.hibernate.annotations.common.reflection.XClass;
import org.hibernate.annotations.common.reflection.java.JavaReflectionManager;
import org.hibernate.search.annotations.AnalyzerDef;
import org.hibernate.search.annotations.AnalyzerDefs;
import org.hibernate.search.annotations.FullTextFilterDef;
import org.hibernate.search.annotations.FullTextFilterDefs;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.NormalizerDef;
import org.hibernate.search.annotations.NormalizerDefs;
import org.hibernate.search.backend.impl.BatchedQueueingProcessor;
import org.hibernate.search.backend.impl.WorkerFactory;
import org.hibernate.search.backend.spi.Worker;
import org.hibernate.search.cfg.Environment;
import org.hibernate.search.cfg.SearchMapping;
import org.hibernate.search.cfg.spi.HibernateSearch6DeprecationHelper;
import org.hibernate.search.cfg.spi.SearchConfiguration;
import org.hibernate.search.engine.Version;
import org.hibernate.search.engine.impl.ConfigContext;
import org.hibernate.search.engine.impl.DefaultTimingSource;
import org.hibernate.search.engine.impl.FilterDef;
import org.hibernate.search.engine.impl.ImmutableSearchFactory;
import org.hibernate.search.engine.impl.IncrementalSearchConfiguration;
import org.hibernate.search.engine.impl.MappingDefinitionRegistry;
import org.hibernate.search.engine.impl.MappingModelMetadataProvider;
import org.hibernate.search.engine.impl.MutableEntityIndexBinding;
import org.hibernate.search.engine.impl.MutableSearchFactory;
import org.hibernate.search.engine.impl.MutableSearchFactoryState;
import org.hibernate.search.engine.impl.ReflectionReplacingSearchConfiguration;
import org.hibernate.search.engine.integration.impl.ExtendedSearchIntegrator;
import org.hibernate.search.engine.integration.impl.SearchIntegration;
import org.hibernate.search.engine.metadata.impl.AnnotationMetadataProvider;
import org.hibernate.search.engine.metadata.impl.TypeMetadata;
import org.hibernate.search.engine.service.impl.StandardServiceManager;
import org.hibernate.search.engine.service.spi.ServiceManager;
import org.hibernate.search.engine.spi.DocumentBuilderContainedEntity;
import org.hibernate.search.engine.spi.DocumentBuilderIndexedEntity;
import org.hibernate.search.engine.spi.EntityIndexBinding;
import org.hibernate.search.engine.spi.EntityState;
import org.hibernate.search.engine.spi.SearchMappingHelper;
import org.hibernate.search.exception.ErrorHandler;
import org.hibernate.search.exception.SearchException;
import org.hibernate.search.filter.FilterCachingStrategy;
import org.hibernate.search.filter.impl.MRUFilterCachingStrategy;
import org.hibernate.search.indexes.impl.IndexManagerHolder;
import org.hibernate.search.indexes.spi.IndexManager;
import org.hibernate.search.indexes.spi.IndexManagerType;
import org.hibernate.search.indexes.spi.IndexNameNormalizer;
import org.hibernate.search.spi.ErrorHandlerFactory;
import org.hibernate.search.spi.IndexedTypeIdentifier;
import org.hibernate.search.spi.IndexedTypeMap;
import org.hibernate.search.spi.IndexedTypeSet;
import org.hibernate.search.spi.IndexingMode;
import org.hibernate.search.spi.InstanceInitializer;
import org.hibernate.search.spi.SearchIntegrator;
import org.hibernate.search.spi.WorkerBuildContext;
import org.hibernate.search.spi.impl.IndexedTypeMaps;
import org.hibernate.search.spi.impl.PojoIndexedTypeIdentifier;
import org.hibernate.search.spi.impl.SearchFactoryState;
import org.hibernate.search.spi.impl.TypeHierarchy;
import org.hibernate.search.util.StringHelper;
import org.hibernate.search.util.configuration.impl.ConfigurationParseHelper;
import org.hibernate.search.util.impl.ClassLoaderHelper;
import org.hibernate.search.util.impl.Closer;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class SearchIntegratorBuilder {
    private static final Log log;
    private SearchConfiguration cfg;
    private MutableSearchFactory rootFactory;
    private final List<Class<?>> classes = new ArrayList();
    private final MutableSearchFactoryState factoryState = new MutableSearchFactoryState();

    public SearchIntegratorBuilder configuration(SearchConfiguration configuration) {
        this.cfg = configuration;
        return this;
    }

    public SearchIntegratorBuilder currentSearchIntegrator(SearchIntegrator factory) {
        this.rootFactory = factory.unwrap(MutableSearchFactory.class);
        return this;
    }

    public SearchIntegratorBuilder addClass(Class<?> clazz) {
        this.classes.add(clazz);
        return this;
    }

    public SearchIntegrator buildSearchIntegrator() {
        ExtendedSearchIntegrator extendedIntegrator;
        if (this.rootFactory == null) {
            if (this.classes.size() > 0) {
                throw new SearchException("Cannot add a class if the original SearchFactory is not passed");
            }
            extendedIntegrator = this.buildNewSearchFactory();
        } else {
            extendedIntegrator = this.buildIncrementalSearchFactory();
        }
        return extendedIntegrator;
    }

    private ExtendedSearchIntegrator buildIncrementalSearchFactory() {
        this.removeClassesAlreadyManaged();
        if (this.classes.size() == 0) {
            return this.rootFactory;
        }
        this.factoryState.copyStateFromOldFactory(this.rootFactory);
        Properties configurationProperties = this.factoryState.getConfigurationProperties();
        BuildContext buildContext = new BuildContext();
        IncrementalSearchConfiguration searchConfiguration = new IncrementalSearchConfiguration(this.classes, configurationProperties, this.factoryState);
        this.applySearchMappingToMetadata(searchConfiguration.getReflectionManager(), searchConfiguration.getProgrammaticMapping());
        this.initDocumentBuilders(searchConfiguration, buildContext, searchConfiguration.getProgrammaticMapping());
        IndexedTypeMap<EntityIndexBinding> documentBuildersIndexedEntities = this.factoryState.getIndexBindings();
        IndexedTypeSet indexedClasses = documentBuildersIndexedEntities.keySet();
        for (EntityIndexBinding entityIndexBinding : documentBuildersIndexedEntities.values()) {
            entityIndexBinding.postInitialize(indexedClasses);
        }
        IndexedTypeMap<DocumentBuilderContainedEntity> documentBuildersContainedEntities = this.factoryState.getDocumentBuildersContainedEntities();
        for (DocumentBuilderContainedEntity builder : documentBuildersContainedEntities.values()) {
            builder.postInitialize(indexedClasses);
        }
        ImmutableSearchFactory immutableSearchFactory = new ImmutableSearchFactory(this.factoryState);
        this.factoryState.setActiveSearchIntegrator(immutableSearchFactory);
        this.rootFactory.setDelegate(immutableSearchFactory);
        return this.rootFactory;
    }

    private void removeClassesAlreadyManaged() {
        HashSet remove = new HashSet();
        IndexedTypeMap<DocumentBuilderContainedEntity> containedEntities = this.rootFactory.getDocumentBuildersContainedEntities();
        IndexedTypeMap<EntityIndexBinding> indexedEntities = this.rootFactory.getIndexBindings();
        for (Class<Object> entity : this.classes) {
            IndexedTypeIdentifier typeId = PojoIndexedTypeIdentifier.convertFromLegacy(entity);
            if (!indexedEntities.containsKey(typeId) && !containedEntities.containsKey(typeId)) continue;
            remove.add(entity);
        }
        for (Class<Object> entity : remove) {
            this.classes.remove(entity);
        }
    }

    private ExtendedSearchIntegrator buildNewSearchFactory() {
        BuildContext buildContext = new BuildContext();
        try {
            this.createNewFactoryState(this.cfg, buildContext);
        }
        catch (RuntimeException initializationException) {
            try {
                this.cleanupFactoryState();
            }
            catch (RuntimeException e) {
                initializationException.addSuppressed(e);
            }
            throw initializationException;
        }
        ImmutableSearchFactory factory = new ImmutableSearchFactory(this.factoryState);
        try {
            this.factoryState.setActiveSearchIntegrator(factory);
            this.rootFactory.setDelegate(factory);
            return this.rootFactory;
        }
        catch (RuntimeException initializationException) {
            try {
                factory.close();
            }
            catch (RuntimeException e) {
                initializationException.addSuppressed(e);
            }
            throw initializationException;
        }
    }

    private void createNewFactoryState(SearchConfiguration cfg2, BuildContext buildContext) {
        this.createCleanFactoryState(this.cfg, buildContext);
        ReflectionManager reflectionManager = this.getReflectionManager(this.cfg);
        if (reflectionManager != this.cfg.getReflectionManager()) {
            this.cfg = new ReflectionReplacingSearchConfiguration(reflectionManager, this.cfg);
        }
        SearchMapping mapping = SearchMappingHelper.extractSearchMapping(this.cfg);
        this.applySearchMappingToMetadata(reflectionManager, mapping);
        this.factoryState.setSearchMapping(mapping);
        this.factoryState.setIndexingMode(SearchIntegratorBuilder.defineIndexingMode(this.cfg));
        this.initDocumentBuilders(this.cfg, buildContext, mapping);
        IndexedTypeMap<EntityIndexBinding> documentBuildersIndexedEntities = this.factoryState.getIndexBindings();
        IndexedTypeSet indexedClasses = documentBuildersIndexedEntities.keySet();
        for (EntityIndexBinding entityIndexBinding : documentBuildersIndexedEntities.values()) {
            entityIndexBinding.postInitialize(indexedClasses);
        }
        IndexedTypeMap<DocumentBuilderContainedEntity> documentBuildersContainedEntities = this.factoryState.getDocumentBuildersContainedEntities();
        for (DocumentBuilderContainedEntity builder : documentBuildersContainedEntities.values()) {
            builder.postInitialize(indexedClasses);
        }
        BatchedQueueingProcessor batchedQueueingProcessor = new BatchedQueueingProcessor(documentBuildersIndexedEntities, this.cfg.getProperties(), buildContext.getAllIndexesManager());
        this.factoryState.setWorker(WorkerFactory.createWorker(this.cfg, buildContext, batchedQueueingProcessor));
        this.factoryState.setFilterCachingStrategy(this.buildFilterCachingStrategy(this.cfg));
        this.factoryState.setCacheBitResultsSize(ConfigurationParseHelper.getIntValue(this.cfg.getProperties(), "hibernate.search.filter.cache_docidresults.size", 5));
    }

    private void cleanupFactoryState() {
        try (Closer closer = new Closer();){
            Worker worker = this.factoryState.getWorker();
            if (worker != null) {
                closer.push(worker::close);
            }
            closer.push(this.factoryState.getAllIndexesManager()::stop);
            closer.push(this.factoryState.getTimingSource()::stop);
            closer.push(this.factoryState.getServiceManager()::releaseAllServices);
            closer.pushAll(SearchIntegration::close, this.factoryState.getIntegrations().values());
        }
    }

    private void applySearchMappingToMetadata(ReflectionManager reflectionManager, SearchMapping mapping) {
        if (mapping != null) {
            if (!(reflectionManager instanceof MetadataProviderInjector)) {
                throw new SearchException("Programmatic mapping model used but ReflectionManager does not implement " + MetadataProviderInjector.class.getName());
            }
            MetadataProviderInjector injector = (MetadataProviderInjector)reflectionManager;
            MetadataProvider original = injector.getMetadataProvider();
            injector.setMetadataProvider((MetadataProvider)new MappingModelMetadataProvider(original, mapping));
        }
    }

    private FilterCachingStrategy buildFilterCachingStrategy(SearchConfiguration searchConfiguration) {
        FilterCachingStrategy filterCachingStrategy;
        String filterCachingStrategyName = searchConfiguration.getProperties().getProperty("hibernate.search.filter.cache_strategy");
        if (StringHelper.isEmpty(filterCachingStrategyName) || "mru".equalsIgnoreCase(filterCachingStrategyName)) {
            filterCachingStrategy = new MRUFilterCachingStrategy();
        } else {
            Class filterCachingStrategyClass = searchConfiguration.getClassLoaderService().classForName(filterCachingStrategyName);
            filterCachingStrategy = ClassLoaderHelper.instanceFromClass(FilterCachingStrategy.class, filterCachingStrategyClass, "filterCachingStrategy");
        }
        filterCachingStrategy.initialize(searchConfiguration.getProperties());
        return filterCachingStrategy;
    }

    private void createCleanFactoryState(SearchConfiguration cfg, BuildContext buildContext) {
        if (this.rootFactory == null) {
            this.rootFactory = new MutableSearchFactory();
            this.factoryState.setDocumentBuildersIndexedEntities(IndexedTypeMaps.concurrentHashMap());
            this.factoryState.setDocumentBuildersContainedEntities(IndexedTypeMaps.concurrentHashMap());
            this.factoryState.setConfiguredTypeHierarchy(new TypeHierarchy());
            this.factoryState.setIndexedTypeHierarchy(new TypeHierarchy());
            this.factoryState.setConfigurationProperties(cfg.getProperties());
            this.factoryState.setServiceManager(new StandardServiceManager(cfg, buildContext, Environment.DEFAULT_SERVICES_MAP));
            this.factoryState.setAllIndexesManager(new IndexManagerHolder());
            this.factoryState.setErrorHandler(ErrorHandlerFactory.createErrorHandler(cfg));
            this.factoryState.setInstanceInitializer(cfg.getInstanceInitializer());
            this.factoryState.setTimingSource(new DefaultTimingSource());
            this.factoryState.setIndexMetadataComplete(cfg.isIndexMetadataComplete());
            this.factoryState.setTransactionManagerExpected(cfg.isTransactionManagerExpected());
            this.factoryState.setDeleteByTermEnforced(cfg.isDeleteByTermEnforced());
            this.factoryState.setIdProvidedImplicit(cfg.isIdProvidedImplicit());
            this.factoryState.setMultitenancyEnabled(cfg.isMultitenancyEnabled());
        }
    }

    private void initDocumentBuilders(SearchConfiguration searchConfiguration, BuildContext buildContext, SearchMapping searchMapping) {
        Class<?> mappedClass;
        ConfigContext configContext = new ConfigContext(searchConfiguration, buildContext, searchMapping, this.factoryState.getIntegrations());
        this.initProgrammaticAnalyzers(configContext, searchConfiguration.getReflectionManager());
        this.initProgrammaticNormalizers(configContext, searchConfiguration.getReflectionManager());
        this.initProgrammaticallyDefinedFilterDef(configContext, searchConfiguration.getReflectionManager());
        TypeHierarchy configuredTypeHierarchy = this.factoryState.getConfiguredTypeHierarchy();
        TypeHierarchy indexedTypeHierarchy = this.factoryState.getIndexedTypeHierarchy();
        IndexedTypeMap<EntityIndexBinding> documentBuildersIndexedEntities = this.factoryState.getIndexBindings();
        IndexedTypeMap<DocumentBuilderContainedEntity> documentBuildersContainedEntities = this.factoryState.getDocumentBuildersContainedEntities();
        HashSet<XClass> optimizationBlackListedTypes = new HashSet<XClass>();
        Map<XClass, Class<?>> classMappings = SearchIntegratorBuilder.initializeClassMappings(searchConfiguration, searchConfiguration.getReflectionManager());
        LinkedList<XClass> rootIndexedEntities = new LinkedList<XClass>();
        AnnotationMetadataProvider metadataProvider = new AnnotationMetadataProvider(searchConfiguration.getReflectionManager(), configContext);
        for (Map.Entry<XClass, Class<?>> mapping : classMappings.entrySet()) {
            XClass mappedXClass = mapping.getKey();
            mappedClass = mapping.getValue();
            PojoIndexedTypeIdentifier mappedClassIdentifier = new PojoIndexedTypeIdentifier(mappedClass);
            if (mappedXClass.isAnnotationPresent(Indexed.class)) {
                if (mappedXClass.isAbstract()) {
                    log.abstractClassesCannotInsertDocuments(mappedXClass.getName());
                    continue;
                }
                rootIndexedEntities.add(mappedXClass);
                configuredTypeHierarchy.addConfiguredClass(mappedClass);
                indexedTypeHierarchy.addConfiguredClass(mappedClass);
                continue;
            }
            if (metadataProvider.containsSearchMetadata(mappedClassIdentifier)) {
                TypeMetadata typeMetadata = metadataProvider.getTypeMetadataForContainedIn(mappedClassIdentifier);
                DocumentBuilderContainedEntity documentBuilder = new DocumentBuilderContainedEntity(mappedXClass, typeMetadata, searchConfiguration.getReflectionManager(), optimizationBlackListedTypes, searchConfiguration.getInstanceInitializer());
                if (documentBuilder.getEntityState() != EntityState.NON_INDEXABLE) {
                    documentBuildersContainedEntities.put(mappedClassIdentifier, documentBuilder);
                }
                configuredTypeHierarchy.addConfiguredClass(mappedClass);
                continue;
            }
            configuredTypeHierarchy.addConfiguredClass(mappedClass);
        }
        IndexManagerHolder indexesFactory = this.factoryState.getAllIndexesManager();
        this.detectIndexNamesCollisions(indexesFactory.getIndexManagers());
        for (XClass mappedXClass : rootIndexedEntities) {
            PojoIndexedTypeIdentifier mappedClassId;
            MutableEntityIndexBinding entityIndexBinding = indexesFactory.buildEntityIndexBinding(mappedXClass, mappedClassId = new PojoIndexedTypeIdentifier(mappedClass = classMappings.get(mappedXClass)), searchConfiguration, buildContext);
            if (entityIndexBinding.getEntityIndexingInterceptor() != null) {
                optimizationBlackListedTypes.add(mappedXClass);
            }
            IndexManagerType indexManagerType = entityIndexBinding.getIndexManagerType();
            TypeMetadata typeMetadata = metadataProvider.getTypeMetadataFor(mappedClassId, indexManagerType);
            DocumentBuilderIndexedEntity documentBuilder = new DocumentBuilderIndexedEntity(mappedXClass, typeMetadata, configContext, searchConfiguration.getReflectionManager(), optimizationBlackListedTypes, searchConfiguration.getInstanceInitializer());
            entityIndexBinding.setDocumentBuilderIndexedEntity(documentBuilder);
            documentBuildersIndexedEntities.put(mappedClassId, entityIndexBinding);
        }
        this.detectIndexNamesCollisions(indexesFactory.getIndexManagers());
        this.disableBlackListedTypesOptimization(classMappings, optimizationBlackListedTypes, documentBuildersIndexedEntities, documentBuildersContainedEntities);
        if (HibernateSearch6DeprecationHelper.isWarningEnabled(searchConfiguration.getProperties())) {
            for (IndexManager indexManager : indexesFactory.getIndexManagers()) {
                IndexedTypeSet indexedTypes = indexManager.getContainedTypes();
                if (indexedTypes.size() <= 1) continue;
                log.multipleTypesInSingleIndex(indexManager.getIndexName(), indexedTypes);
            }
        }
        this.factoryState.addFilterDefinitions(configContext.initFilters());
        this.factoryState.addIntegrations(configContext.initIntegrations(indexesFactory));
    }

    private void detectIndexNamesCollisions(Collection<IndexManager> indexManagers) {
        Map<String, Set<String>> indexNames = this.collectIndexNames(indexManagers);
        this.validateIndexNames(indexNames);
    }

    private Map<String, Set<String>> collectIndexNames(Collection<IndexManager> indexManagers) {
        HashMap<String, Set<String>> indexNames = new HashMap<String, Set<String>>();
        for (IndexManager indexManager : indexManagers) {
            if (!(indexManager instanceof IndexNameNormalizer)) continue;
            IndexNameNormalizer normalizer = (IndexNameNormalizer)((Object)indexManager);
            if (!indexNames.containsKey(normalizer.getActualIndexName())) {
                indexNames.put(normalizer.getActualIndexName(), new HashSet(2));
            }
            ((Set)indexNames.get(normalizer.getActualIndexName())).add(indexManager.getIndexName());
        }
        return indexNames;
    }

    private void validateIndexNames(Map<String, Set<String>> indexNames) {
        StringBuilder builder = new StringBuilder();
        String separator = "";
        for (Map.Entry<String, Set<String>> entry : indexNames.entrySet()) {
            if (entry.getValue().size() <= 1) continue;
            builder.append(separator);
            builder.append("(");
            builder.append(entry.getValue());
            builder.append(" --> ");
            builder.append(entry.getKey());
            builder.append(")");
            separator = ", ";
        }
        if (builder.length() > 0) {
            throw log.indexNamesCollisionDetected(builder.toString());
        }
    }

    private void disableBlackListedTypesOptimization(Map<XClass, Class<?>> classMappings, Set<XClass> optimizationBlackListX, IndexedTypeMap<EntityIndexBinding> documentBuildersIndexedEntities, IndexedTypeMap<DocumentBuilderContainedEntity> documentBuildersContainedEntities) {
        for (XClass xClass : optimizationBlackListX) {
            DocumentBuilderContainedEntity documentBuilderContainedEntity;
            Class<?> type = classMappings.get(xClass);
            if (type == null) continue;
            PojoIndexedTypeIdentifier typeIdentifier = new PojoIndexedTypeIdentifier(type);
            EntityIndexBinding entityIndexBinding = documentBuildersIndexedEntities.get(typeIdentifier);
            if (entityIndexBinding != null) {
                log.tracef("Dirty checking optimizations disabled for class %s", type);
                entityIndexBinding.getDocumentBuilder().forceStateInspectionOptimizationsDisabled();
            }
            if ((documentBuilderContainedEntity = documentBuildersContainedEntities.get(typeIdentifier)) == null) continue;
            log.tracef("Dirty checking optimizations disabled for class %s", type);
            documentBuilderContainedEntity.forceStateInspectionOptimizationsDisabled();
        }
    }

    private static Map<XClass, Class<?>> initializeClassMappings(SearchConfiguration cfg, ReflectionManager reflectionManager) {
        Iterator<Class<?>> iter = cfg.getClassMappings();
        HashMap map = new HashMap();
        while (iter.hasNext()) {
            XClass mappedXClass;
            Class<?> mappedClass = iter.next();
            if (mappedClass == null || (mappedXClass = reflectionManager.toXClass(mappedClass)) == null) continue;
            map.put(mappedXClass, mappedClass);
        }
        return map;
    }

    private void initProgrammaticAnalyzers(ConfigContext context, ReflectionManager reflectionManager) {
        AnalyzerDef[] defs;
        Map defaults = reflectionManager.getDefaults();
        if (defaults != null && (defs = (AnalyzerDef[])defaults.get(AnalyzerDefs.class)) != null) {
            MappingDefinitionRegistry<AnalyzerDef, ?> registry = context.getAnalyzerDefinitionRegistry();
            for (AnalyzerDef def : defs) {
                registry.registerGlobal(def.name(), def);
            }
        }
    }

    private void initProgrammaticNormalizers(ConfigContext context, ReflectionManager reflectionManager) {
        NormalizerDef[] defs;
        Map defaults = reflectionManager.getDefaults();
        if (defaults != null && (defs = (NormalizerDef[])defaults.get(NormalizerDefs.class)) != null) {
            MappingDefinitionRegistry<NormalizerDef, ?> registry = context.getNormalizerDefinitionRegistry();
            for (NormalizerDef def : defs) {
                registry.registerGlobal(def.name(), def);
            }
        }
    }

    private void initProgrammaticallyDefinedFilterDef(ConfigContext context, ReflectionManager reflectionManager) {
        Map defaults = reflectionManager.getDefaults();
        FullTextFilterDef[] filterDefs = (FullTextFilterDef[])defaults.get(FullTextFilterDefs.class);
        if (filterDefs != null && filterDefs.length != 0) {
            MappingDefinitionRegistry<FullTextFilterDef, ?> registry = context.getFullTextFilterDefinitionRegistry();
            Map<String, FilterDef> filterDefinitions = this.factoryState.getFilterDefinitions();
            for (FullTextFilterDef defAnn : filterDefs) {
                String name = defAnn.name();
                if (filterDefinitions.containsKey(name)) {
                    throw new SearchException("Multiple definition of @FullTextFilterDef.name=" + defAnn.name());
                }
                registry.registerGlobal(name, defAnn);
            }
        }
    }

    private ReflectionManager getReflectionManager(SearchConfiguration cfg) {
        ReflectionManager reflectionManager = cfg.getReflectionManager();
        return this.getReflectionManager(reflectionManager);
    }

    private ReflectionManager getReflectionManager(ReflectionManager reflectionManager) {
        if (reflectionManager == null) {
            reflectionManager = new JavaReflectionManager();
        }
        return reflectionManager;
    }

    private static IndexingMode defineIndexingMode(SearchConfiguration cfg) {
        String indexingStrategy = cfg.getProperties().getProperty("hibernate.search.indexing_strategy", IndexingMode.EVENT.toExternalRepresentation());
        return IndexingMode.fromExternalRepresentation(indexingStrategy);
    }

    static {
        Version.touch();
        log = LoggerFactory.make(MethodHandles.lookup());
    }

    private class BuildContext
    implements WorkerBuildContext {
        private final SearchFactoryState factoryState;

        private BuildContext() {
            this.factoryState = SearchIntegratorBuilder.this.factoryState;
        }

        @Override
        public ExtendedSearchIntegrator getUninitializedSearchIntegrator() {
            return SearchIntegratorBuilder.this.rootFactory;
        }

        @Override
        public IndexingMode getIndexingMode() {
            return this.factoryState.getIndexingMode();
        }

        @Override
        public boolean isTransactionManagerExpected() {
            return SearchIntegratorBuilder.this.cfg.isTransactionManagerExpected();
        }

        @Override
        public IndexManagerHolder getAllIndexesManager() {
            return this.factoryState.getAllIndexesManager();
        }

        @Override
        public ErrorHandler getErrorHandler() {
            return this.factoryState.getErrorHandler();
        }

        @Override
        public InstanceInitializer getInstanceInitializer() {
            return this.factoryState.getInstanceInitializer();
        }

        @Override
        public boolean enlistWorkerInTransaction() {
            return this.factoryState.enlistWorkerInTransaction();
        }

        @Override
        public boolean isIndexMetadataComplete() {
            return this.factoryState.isIndexMetadataComplete();
        }

        @Override
        public boolean isDeleteByTermEnforced() {
            return this.factoryState.isDeleteByTermEnforced();
        }

        @Override
        public ServiceManager getServiceManager() {
            return this.factoryState.getServiceManager();
        }

        @Override
        public boolean isMultitenancyEnabled() {
            return this.factoryState.isMultitenancyEnabled();
        }

        @Override
        public boolean isHibernateSearch6DeprecationWarningsEnabled() {
            return HibernateSearch6DeprecationHelper.isWarningEnabled(this.factoryState.getConfigurationProperties());
        }
    }
}

