/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.bridge;

import java.io.Serializable;
import org.apache.lucene.document.Document;
import org.hibernate.search.bridge.LuceneOptions;
import org.hibernate.search.bridge.MetadataProvidingFieldBridge;
import org.hibernate.search.bridge.TwoWayFieldBridge;
import org.hibernate.search.bridge.spi.FieldMetadataBuilder;
import org.hibernate.search.bridge.spi.FieldType;
import org.hibernate.search.testsupport.junit.SearchFactoryHolder;
import org.hibernate.search.testsupport.junit.SearchITHelper;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public abstract class CheckCustomFieldDefaultAnalyzer {
    private static final String ENTITY_ID = "GLaDOS";
    @Rule
    public final SearchFactoryHolder holder = new SearchFactoryHolder(this.getEntityType());
    private final SearchITHelper helper = new SearchITHelper(this.holder);

    @Before
    public void before() throws Exception {
        this.helper.add(this.entity());
    }

    private Object entity() {
        return this.entity(ENTITY_ID, "CHELL", "WELL DONE. HERE COME THE TEST RESULTS: 'YOU ARE A HORRIBLE PERSON.");
    }

    protected abstract Object entity(String var1, String var2, String var3);

    protected abstract Class<?> getEntityType();

    @Test
    public void shouldBeAbleToFindTheCustomIdField() throws Exception {
        this.helper.assertThat("copy_of_id", ENTITY_ID).from(this.getEntityType()).matchesExactlyIds(new Serializable[]{ENTITY_ID});
    }

    @Test
    public void shouldNotAnalyzeCustomIdField() throws Exception {
        this.helper.assertThat("copy_of_id", "glados").from(this.getEntityType()).matchesNone();
    }

    @Test
    public void shouldBeAbleToFindNotAnalyzedCustomField() throws Exception {
        this.helper.assertThat("copy_of_subject", "CHELL").from(this.getEntityType()).matchesExactlyIds(new Serializable[]{ENTITY_ID});
    }

    @Test
    public void shouldNotAnalyzeCustomField() throws Exception {
        this.helper.assertThat("copy_of_subject", "chell").from(this.getEntityType()).matchesNone();
    }

    @Test
    public void shouldBeAbleToFindAnalyzedAnnotatedField() throws Exception {
        this.helper.assertThat("result", "HORRIBLE").from(this.getEntityType()).matchesExactlyIds(new Serializable[]{ENTITY_ID});
    }

    @Test
    public void shouldNotBeAbleToFindAnalyzedCustomField() throws Exception {
        this.helper.assertThat("copy_of_result", "HORRIBLE").from(this.getEntityType()).matchesNone();
    }

    @Test
    public void shouldBeAbleToFindAnalyzedCustomField() throws Exception {
        this.helper.assertThat("copy_of_result", "horrible").from(this.getEntityType()).matchesExactlyIds(new Serializable[]{ENTITY_ID});
    }

    public static class AdditionalFieldBridge
    implements MetadataProvidingFieldBridge,
    TwoWayFieldBridge {
        public void set(String name, Object value, Document document, LuceneOptions luceneOptions) {
            luceneOptions.addFieldToDocument(name, (String)value, document);
            luceneOptions.addFieldToDocument(this.copyOf(name), (String)value, document);
        }

        private String copyOf(String name) {
            return "copy_of_" + name;
        }

        public void configureFieldMetadata(String name, FieldMetadataBuilder builder) {
            builder.field(this.copyOf(name), FieldType.STRING);
        }

        public Object get(String name, Document document) {
            return document.get(name);
        }

        public String objectToString(Object object) {
            return (String)object;
        }
    }
}

