/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.sorting;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.lucene.document.Document;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.assertj.core.api.Assertions;
import org.hibernate.search.annotations.Analyze;
import org.hibernate.search.annotations.DocumentId;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.FieldBridge;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.SortableField;
import org.hibernate.search.bridge.LuceneOptions;
import org.hibernate.search.query.engine.spi.HSQuery;
import org.hibernate.search.spi.CustomTypeMetadata;
import org.hibernate.search.spi.IndexedTypeIdentifier;
import org.hibernate.search.spi.IndexedTypeMap;
import org.hibernate.search.spi.impl.IndexedTypeMaps;
import org.hibernate.search.spi.impl.PojoIndexedTypeIdentifier;
import org.hibernate.search.test.util.impl.ExpectedLog4jLog;
import org.hibernate.search.testsupport.TestForIssue;
import org.hibernate.search.testsupport.junit.SearchFactoryHolder;
import org.hibernate.search.testsupport.junit.SearchITHelper;
import org.hibernate.search.testsupport.junit.SkipOnElasticsearch;
import org.hibernate.search.util.impl.CollectionHelper;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@TestForIssue(jiraKey="HSEARCH-2561")
@Category(value={SkipOnElasticsearch.class})
public class CustomTypeMetadataSortingTest {
    private static final String UNINVERTING_READER_LOG_CODE = "HSEARCH000289";
    private static final IndexedTypeIdentifier PROPERTY_SET_TYPE_ID = new PojoIndexedTypeIdentifier(PropertySet.class);
    private static final IndexedTypeIdentifier PERSON_TYPE_ID = new PojoIndexedTypeIdentifier(Person.class);
    private static final Sort FIRST_NAME_SORT = new Sort(new SortField("properties.firstName", SortField.Type.STRING));
    private static final Sort FIRST_NAME_SORT_REVERSED = new Sort(new SortField("properties.firstName", SortField.Type.STRING, true));
    @Rule
    public final ExpectedLog4jLog logged = ExpectedLog4jLog.create();
    @Rule
    public final SearchFactoryHolder factoryHolder = new SearchFactoryHolder(PropertySet.class, ExtendedPropertySet.class, Person.class).withProperty("hibernate.search.index_uninverting_allowed", "true");
    private final SearchITHelper helper = new SearchITHelper(this.factoryHolder);

    @Test
    public void undeclaredSortableField_defaultMetadata() {
        this.helper.index(new PropertySet(0).put("firstName", "Aaron").put("lastName", "Zahnd").put("nonSortableField", "zzz"), new ExtendedPropertySet(1).put("firstName", "Mike").put("lastName", "Myers").put("nonSortableField", "mmm"), new Person(2, "Zach"));
        this.logged.expectMessage(UNINVERTING_READER_LOG_CODE);
        Query luceneQuery = this.factoryHolder.getSearchFactory().buildQueryBuilder().forEntity(PropertySet.class).get().all().createQuery();
        HSQuery query = this.factoryHolder.getSearchFactory().createHSQuery(luceneQuery, new Class[]{PropertySet.class, Person.class}).sort(FIRST_NAME_SORT);
        Assertions.assertThat((List)query.queryEntityInfos()).extracting("id").as("Sorted IDs", new Object[0]).containsExactly(new Object[]{0, 1, 2});
        query.sort(FIRST_NAME_SORT_REVERSED);
        Assertions.assertThat((List)query.queryEntityInfos()).extracting("id").as("Sorted IDs", new Object[0]).containsExactly(new Object[]{2, 1, 0});
    }

    @Test
    public void undeclaredSortableField_incorrectCustomMetadata() {
        this.helper.index(new PropertySet(0).put("firstName", "Aaron").put("lastName", "Zahnd").put("nonSortableField", "zzz"), new ExtendedPropertySet(1).put("firstName", "Mike").put("lastName", "Myers").put("nonSortableField", "mmm"), new Person(2, "Zach"));
        this.logged.expectMessage(UNINVERTING_READER_LOG_CODE);
        Query luceneQuery = this.factoryHolder.getSearchFactory().buildQueryBuilder().forEntity(PropertySet.class).get().all().createQuery();
        CustomTypeMetadata incorrectCustomMetadata = new CustomTypeMetadata(){

            public Set<String> getSortableFields() {
                return Collections.singleton("properties.nonSortableField");
            }
        };
        IndexedTypeMap metadata = IndexedTypeMaps.hashMap();
        metadata.put(PROPERTY_SET_TYPE_ID, (Object)incorrectCustomMetadata);
        metadata.put(PERSON_TYPE_ID, (Object)new EmptyMetadata());
        HSQuery query = this.factoryHolder.getSearchFactory().createHSQuery(luceneQuery, metadata).sort(FIRST_NAME_SORT);
        Assertions.assertThat((List)query.queryEntityInfos()).extracting("id").as("Sorted IDs", new Object[0]).containsExactly(new Object[]{0, 1, 2});
        query.sort(FIRST_NAME_SORT_REVERSED);
        Assertions.assertThat((List)query.queryEntityInfos()).extracting("id").as("Sorted IDs", new Object[0]).containsExactly(new Object[]{2, 1, 0});
    }

    @Test
    public void undeclaredSortableField_correctCustomMetadata() {
        this.helper.index(new PropertySet(0).put("firstName", "Aaron").put("lastName", "Zahnd").put("nonSortableField", "zzz"), new ExtendedPropertySet(1).put("firstName", "Mike").put("lastName", "Myers").put("nonSortableField", "mmm"), new Person(2, "Zach"));
        this.logged.expectMessageMissing(UNINVERTING_READER_LOG_CODE);
        Query luceneQuery = this.factoryHolder.getSearchFactory().buildQueryBuilder().forEntity(PropertySet.class).get().all().createQuery();
        IndexedTypeMap metadata = IndexedTypeMaps.hashMap();
        metadata.put(PROPERTY_SET_TYPE_ID, (Object)new PropertySetMetadata());
        metadata.put(PERSON_TYPE_ID, (Object)new EmptyMetadata());
        HSQuery query = this.factoryHolder.getSearchFactory().createHSQuery(luceneQuery, metadata).sort(FIRST_NAME_SORT);
        Assertions.assertThat((List)query.queryEntityInfos()).extracting("id").as("Sorted IDs", new Object[0]).containsExactly(new Object[]{0, 1, 2});
        query.sort(FIRST_NAME_SORT_REVERSED);
        Assertions.assertThat((List)query.queryEntityInfos()).extracting("id").as("Sorted IDs", new Object[0]).containsExactly(new Object[]{2, 1, 0});
    }

    private static class EmptyMetadata
    implements CustomTypeMetadata {
        private EmptyMetadata() {
        }

        public Set<String> getSortableFields() {
            return Collections.emptySet();
        }
    }

    private static class PropertySetMetadata
    implements CustomTypeMetadata {
        private final Set<String> sortableFields;

        public PropertySetMetadata() {
            TreeSet<String> sortableFields = new TreeSet<String>();
            for (String propertyName : PropertiesBridge.SORTABLE_PROPERTIES) {
                sortableFields.add("properties." + propertyName);
            }
            this.sortableFields = Collections.unmodifiableSet(sortableFields);
        }

        public Set<String> getSortableFields() {
            return this.sortableFields;
        }
    }

    public static class PropertiesBridge
    implements org.hibernate.search.bridge.FieldBridge {
        public static final Set<String> SORTABLE_PROPERTIES = CollectionHelper.asImmutableSet((String[])new String[]{"firstName", "lastName"});

        public void set(String name, Object value, Document document, LuceneOptions luceneOptions) {
            Map properties = (Map)value;
            for (Map.Entry property : properties.entrySet()) {
                String fieldName = name + "." + (String)property.getKey();
                luceneOptions.addFieldToDocument(fieldName, (String)property.getValue(), document);
                if (!SORTABLE_PROPERTIES.contains(property.getKey())) continue;
                luceneOptions.addSortedDocValuesFieldToDocument(fieldName, (String)property.getValue(), document);
            }
        }
    }

    @Indexed(index="person")
    private static class Person {
        @DocumentId
        int id;
        @Field(name="properties.firstName", analyze=Analyze.NO)
        @SortableField(forField="properties.firstName")
        String firstName;

        public Person(int id, String firstName) {
            this.id = id;
            this.firstName = firstName;
        }
    }

    @Indexed(index="propertySet")
    private static class ExtendedPropertySet
    extends PropertySet {
        public ExtendedPropertySet(int id) {
            super(id);
        }
    }

    @Indexed(index="propertySet")
    private static class PropertySet {
        @DocumentId
        int id;
        @Field(bridge=@FieldBridge(impl=PropertiesBridge.class))
        Map<String, String> properties = new LinkedHashMap<String, String>();

        public PropertySet(int id) {
            this.id = id;
        }

        public PropertySet put(String name, String value) {
            this.properties.put(name, value);
            return this;
        }
    }
}

