/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.query.engine;

import java.io.IOException;
import java.util.HashSet;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.IntField;
import org.apache.lucene.document.StringField;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.DisjunctionMaxQuery;
import org.apache.lucene.search.FuzzyQuery;
import org.apache.lucene.search.MultiPhraseQuery;
import org.apache.lucene.search.NumericRangeQuery;
import org.apache.lucene.search.PhraseQuery;
import org.apache.lucene.search.PrefixQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.RegexpQuery;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TermRangeQuery;
import org.apache.lucene.search.WildcardQuery;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.RAMDirectory;
import org.hibernate.search.query.engine.impl.FieldNameCollector;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class FieldNameCollectorTest {
    DirectoryReader indexReader;

    @Before
    public void setUp() throws Exception {
        RAMDirectory directory = new RAMDirectory();
        this.indexTestDocuments((Directory)directory);
        this.indexReader = DirectoryReader.open((Directory)directory);
    }

    @After
    public void tearDown() throws Exception {
        this.indexReader.close();
    }

    @Test
    public void testExtractFieldNameFromTermQuery() {
        TermQuery query = new TermQuery(new Term("stringField", "foobar"));
        this.assertFieldNames((Query)query, FieldType.STRING, "stringField");
    }

    @Test
    public void testExtractFieldNameFromWildcardQuery() {
        WildcardQuery query = new WildcardQuery(new Term("stringField", "foo*"));
        this.assertFieldNames((Query)query, FieldType.STRING, "stringField");
    }

    @Test
    public void testExtractFieldNameFromFuzzyQuery() {
        FuzzyQuery query = new FuzzyQuery(new Term("stringField", "foo*"));
        this.assertFieldNames((Query)query, FieldType.STRING, "stringField");
    }

    @Test
    public void testExtractFieldNameFromRegexpQuery() {
        RegexpQuery query = new RegexpQuery(new Term("stringField", ".foo?"));
        this.assertFieldNames((Query)query, FieldType.STRING, "stringField");
    }

    @Test
    public void testExtractFieldNameFromPrefixQuery() {
        PrefixQuery query = new PrefixQuery(new Term("stringField", "foo*"));
        this.assertFieldNames((Query)query, FieldType.STRING, "stringField");
    }

    @Test
    public void testExtractFieldNameFromMultiPhraseQuery() {
        MultiPhraseQuery phraseQuery = new MultiPhraseQuery();
        phraseQuery.add(new Term("stringField1", "hello world"));
        this.assertFieldNames((Query)phraseQuery, FieldType.STRING, "stringField1");
    }

    @Test
    public void testExtractFieldNameFromPhraseQuery() {
        PhraseQuery.Builder phraseQBuilder = new PhraseQuery.Builder();
        phraseQBuilder.add(new Term("stringField", "hello world"));
        PhraseQuery phraseQuery = phraseQBuilder.build();
        this.assertFieldNames((Query)phraseQuery, FieldType.STRING, "stringField");
    }

    @Test
    public void testExtractFieldNameFromTermRangeQuery() {
        TermRangeQuery query = TermRangeQuery.newStringRange((String)"stringField", (String)"A", (String)"Z", (boolean)true, (boolean)true);
        this.assertFieldNames((Query)query, FieldType.STRING, "stringField");
    }

    @Test
    public void testExtractFieldNameFromNumericRangeQuery() {
        NumericRangeQuery query = NumericRangeQuery.newIntRange((String)"intField", (Integer)0, (Integer)0, (boolean)true, (boolean)true);
        this.assertFieldNames((Query)query, FieldType.NUMBER, "intField");
    }

    @Test
    public void testBooleanQuery() {
        BooleanQuery.Builder booleanQueryBuilder = new BooleanQuery.Builder();
        TermQuery termQuery = new TermQuery(new Term("stringField", "foobar"));
        booleanQueryBuilder.add((Query)termQuery, BooleanClause.Occur.MUST);
        NumericRangeQuery numericRangeQuery = NumericRangeQuery.newIntRange((String)"intField", (Integer)0, (Integer)0, (boolean)true, (boolean)true);
        booleanQueryBuilder.add((Query)numericRangeQuery, BooleanClause.Occur.SHOULD);
        BooleanQuery booleanQuery = booleanQueryBuilder.build();
        this.assertFieldNames((Query)booleanQuery, FieldType.NUMBER, "intField");
        this.assertFieldNames((Query)booleanQuery, FieldType.STRING, "stringField");
    }

    @Test
    public void testNestedBooleanQuery() {
        BooleanQuery.Builder booleanQueryBuilder = new BooleanQuery.Builder();
        TermQuery termQuery = new TermQuery(new Term("stringField", "foobar"));
        booleanQueryBuilder.add((Query)termQuery, BooleanClause.Occur.MUST);
        BooleanQuery.Builder nestedBuilder = new BooleanQuery.Builder();
        NumericRangeQuery numericRangeQuery = NumericRangeQuery.newIntRange((String)"intField", (Integer)0, (Integer)0, (boolean)true, (boolean)true);
        nestedBuilder.add((Query)numericRangeQuery, BooleanClause.Occur.SHOULD);
        BooleanQuery nestedBooleanQuery = nestedBuilder.build();
        booleanQueryBuilder.add((Query)nestedBooleanQuery, BooleanClause.Occur.MUST);
        BooleanQuery booleanQuery = booleanQueryBuilder.build();
        this.assertFieldNames((Query)booleanQuery, FieldType.NUMBER, "intField");
        this.assertFieldNames((Query)booleanQuery, FieldType.STRING, "stringField");
    }

    @Test
    public void testDisjunctionMaxQuery() {
        HashSet<Object> queriesToCombine = new HashSet<Object>();
        TermQuery termQuery = new TermQuery(new Term("stringField", "foobar"));
        queriesToCombine.add(termQuery);
        NumericRangeQuery numericRangeQuery = NumericRangeQuery.newIntRange((String)"intField", (Integer)0, (Integer)0, (boolean)true, (boolean)true);
        queriesToCombine.add(numericRangeQuery);
        DisjunctionMaxQuery disjunctionMaxQuery = new DisjunctionMaxQuery(queriesToCombine, 0.0f);
        this.assertFieldNames((Query)disjunctionMaxQuery, FieldType.NUMBER, "intField");
        this.assertFieldNames((Query)disjunctionMaxQuery, FieldType.STRING, "stringField");
    }

    private void assertFieldNames(Query query, FieldType fieldType, String ... expectedFields) {
        FieldNameCollector.FieldCollection fieldCollection = FieldNameCollector.extractFieldNames((Query)query);
        HashSet actualFieldNames = new HashSet();
        if (FieldType.STRING.equals((Object)fieldType)) {
            actualFieldNames.addAll(fieldCollection.getStringFieldNames());
        } else {
            actualFieldNames.addAll(fieldCollection.getNumericFieldNames());
        }
        for (String expectedFieldName : expectedFields) {
            if (!actualFieldNames.contains(expectedFieldName)) {
                Assert.fail((String)("The expected field name " + expectedFieldName + " was not found in the actual field names: " + actualFieldNames));
            }
            actualFieldNames.remove(expectedFieldName);
        }
        if (!actualFieldNames.isEmpty()) {
            Assert.fail((String)("There were field names which were unexpected: " + actualFieldNames));
        }
    }

    private void indexTestDocuments(Directory directory) throws IOException {
        IndexWriterConfig indexWriterConfig = new IndexWriterConfig((Analyzer)new StandardAnalyzer());
        indexWriterConfig.setOpenMode(IndexWriterConfig.OpenMode.CREATE);
        IndexWriter indexWriter = new IndexWriter(directory, indexWriterConfig);
        Document document = new Document();
        document.add((IndexableField)new StringField("stringField", "test", Field.Store.NO));
        document.add((IndexableField)new IntField("intField", 0, Field.Store.NO));
        indexWriter.addDocument((Iterable)document);
        indexWriter.commit();
        indexWriter.close();
    }

    static enum FieldType {
        STRING,
        NUMBER;

    }
}

