/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.testsupport.readerprovider;

import java.io.IOException;
import java.util.Collections;
import org.apache.lucene.document.DocumentStoredFieldVisitor;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FilterDirectoryReader;
import org.apache.lucene.index.FilterLeafReader;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.StoredFieldVisitor;
import org.hibernate.search.exception.SearchException;
import org.hibernate.search.indexes.impl.NotSharedReaderProvider;
import org.hibernate.search.indexes.spi.ReaderProvider;
import org.hibernate.search.query.engine.impl.ReusableDocumentStoredFieldVisitor;
import org.junit.Assert;

public final class FieldSelectorLeakingReaderProvider
extends NotSharedReaderProvider
implements ReaderProvider {
    private static volatile StoredFieldVisitor fieldSelector;

    public static void resetFieldSelector() {
        fieldSelector = null;
    }

    public static void assertFieldSelectorEnabled(String ... expectedFieldNames) throws IOException {
        if (expectedFieldNames == null || expectedFieldNames.length == 0) {
            FieldSelectorLeakingReaderProvider.assertFieldSelectorDisabled();
        } else {
            Assert.assertNotNull((Object)fieldSelector);
            Assert.assertTrue((boolean)(fieldSelector instanceof ReusableDocumentStoredFieldVisitor));
            ReusableDocumentStoredFieldVisitor visitor = (ReusableDocumentStoredFieldVisitor)fieldSelector;
            Assert.assertEquals((long)expectedFieldNames.length, (long)visitor.countAcceptedFields());
            for (String fieldName : expectedFieldNames) {
                FieldInfo fieldId = FieldSelectorLeakingReaderProvider.forgeFieldInfo(fieldName);
                Assert.assertEquals((Object)StoredFieldVisitor.Status.YES, (Object)visitor.needsField(fieldId));
            }
        }
    }

    static FieldInfo forgeFieldInfo(String fieldName) {
        return new FieldInfo(fieldName, 0, false, true, false, IndexOptions.DOCS, DocValuesType.SORTED, 1L, Collections.emptyMap());
    }

    public static void assertFieldSelectorDisabled() {
        StoredFieldVisitor fieldVisitor = fieldSelector;
        Assert.assertTrue((fieldVisitor == null || fieldVisitor instanceof DocumentStoredFieldVisitor ? 1 : 0) != 0);
    }

    public DirectoryReader openIndexReader() {
        DirectoryReader originalReader = super.openIndexReader();
        try {
            LeakingDirectoryReader wrappedReader = new LeakingDirectoryReader(originalReader);
            return wrappedReader;
        }
        catch (IOException ioe) {
            throw new SearchException((Throwable)ioe);
        }
    }

    private final class LeakingAtomicReader
    extends FilterLeafReader {
        public LeakingAtomicReader(LeafReader in) {
            super(in);
        }

        public void document(int docID, StoredFieldVisitor visitor) throws IOException {
            super.document(docID, visitor);
            fieldSelector = visitor;
        }
    }

    private final class LeakingSubReaderWrapper
    extends FilterDirectoryReader.SubReaderWrapper {
        private LeakingSubReaderWrapper() {
        }

        public LeafReader wrap(LeafReader reader) {
            return new LeakingAtomicReader(reader);
        }
    }

    private final class LeakingDirectoryReader
    extends FilterDirectoryReader {
        public LeakingDirectoryReader(DirectoryReader in) throws IOException {
            super(in, (FilterDirectoryReader.SubReaderWrapper)new LeakingSubReaderWrapper());
        }

        protected DirectoryReader doWrapDirectoryReader(DirectoryReader in) throws IOException {
            return new LeakingDirectoryReader(in);
        }
    }
}

