/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.util.impl;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.invoke.MethodHandles;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import org.hibernate.search.util.impl.FileHelper;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;
import org.junit.After;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class FileHelperTest {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private static Path root;
    private String srcDir = "filehelpersrc";
    private String destDir = "filehelperdest";

    @BeforeClass
    public static void prepareRootDirectory() {
        String buildDir = System.getProperty("build.dir");
        if (buildDir == null) {
            buildDir = ".";
        }
        root = Paths.get(buildDir, "filehelper");
        log.infof("Using %s as test directory.", (Object)root.toAbsolutePath());
    }

    private Path createFile(Path dir, String name) throws IOException {
        Path file = dir.resolve(name);
        this.createDummyDatafile(file);
        return file;
    }

    private void createDummyDatafile(Path file) throws IOException {
        try (OutputStream os = Files.newOutputStream(file, StandardOpenOption.CREATE_NEW);){
            os.write("Hello! anyone there?".getBytes(StandardCharsets.UTF_8));
            os.flush();
        }
    }

    @After
    public void tearDown() throws Exception {
        FileHelper.tryDelete((Path)root);
    }

    @Test
    public void testSynchronize() throws Exception {
        Path src = root.resolve(this.srcDir);
        Files.createDirectories(src, new FileAttribute[0]);
        String name = "a";
        this.createFile(src, name);
        name = "b";
        this.createFile(src, name);
        Path subDir = src.resolve("subdir");
        Files.createDirectories(subDir, new FileAttribute[0]);
        name = "c";
        this.createFile(subDir, name);
        Path dest = root.resolve(this.destDir);
        Assert.assertFalse((String)"Directories should be out of sync", (boolean)FileHelper.areInSync((Path)src, (Path)dest));
        FileHelper.synchronize((Path)src, (Path)dest, (boolean)true);
        Assert.assertTrue((String)"Directories should be in sync", (boolean)FileHelper.areInSync((Path)src, (Path)dest));
        Path destTestFile1 = dest.resolve("b");
        Assert.assertTrue((boolean)Files.exists(destTestFile1, new LinkOption[0]));
        Path destTestFile2 = dest.resolve("subdir").resolve("c");
        Assert.assertTrue((boolean)Files.exists(destTestFile2, new LinkOption[0]));
        Path destTestFile3 = this.createFile(dest, "foo");
        Path srcTestFile = src.resolve("c");
        this.createDummyDatafile(srcTestFile);
        Path destTestFile = dest.resolve("c");
        Assert.assertNotSame((Object)srcTestFile.toFile().lastModified(), (Object)destTestFile.toFile().lastModified());
        Assert.assertFalse((String)"Directories should be out of sync", (boolean)FileHelper.areInSync((Path)src, (Path)dest));
        FileHelper.synchronize((Path)src, (Path)dest, (boolean)true);
        Assert.assertTrue((String)"Directories should be in sync", (boolean)FileHelper.areInSync((Path)src, (Path)dest));
        Assert.assertEquals((long)srcTestFile.toFile().lastModified(), (long)destTestFile.toFile().lastModified());
        Assert.assertEquals((long)srcTestFile.toFile().length(), (long)destTestFile.toFile().length());
        Assert.assertTrue((boolean)Files.exists(destTestFile1, new LinkOption[0]));
        Assert.assertTrue((boolean)Files.exists(destTestFile2, new LinkOption[0]));
        Assert.assertTrue((!Files.exists(destTestFile3, new LinkOption[0]) ? 1 : 0) != 0);
        Files.deleteIfExists(srcTestFile);
        FileHelper.synchronize((Path)src, (Path)dest, (boolean)true);
        Assert.assertTrue((!Files.exists(destTestFile, new LinkOption[0]) ? 1 : 0) != 0);
        Assert.assertTrue((String)"Directories should be in sync", (boolean)FileHelper.areInSync((Path)src, (Path)dest));
    }
}

