/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.analyzer.common;

import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.hibernate.search.test.analyzer.common.AlarmEntity;
import org.hibernate.search.test.analyzer.common.MyEntity;
import org.hibernate.search.testsupport.TestConstants;
import org.hibernate.search.testsupport.TestForIssue;
import org.hibernate.search.testsupport.junit.SearchFactoryHolder;
import org.hibernate.search.testsupport.junit.SearchITHelper;
import org.hibernate.search.testsupport.junit.SkipOnElasticsearch;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@TestForIssue(jiraKey="HSEARCH-263")
@Category(value={SkipOnElasticsearch.class})
public class DoubleAnalyzerTest {
    @Rule
    public final SearchFactoryHolder sfHolder = new SearchFactoryHolder(MyEntity.class, AlarmEntity.class);
    private final SearchITHelper helper = new SearchITHelper(this.sfHolder);

    @Test
    public void testScopedAnalyzers() throws Exception {
        MyEntity en = new MyEntity();
        en.setId(1);
        en.setEntity("anyNotNull");
        AlarmEntity alarmEn = new AlarmEntity();
        alarmEn.setId(2);
        alarmEn.setProperty("notNullAgain");
        alarmEn.setAlarmDescription("description");
        this.helper.index(en, alarmEn);
        QueryParser parser = new QueryParser("id", TestConstants.keywordAnalyzer);
        this.helper.assertThat((Query)new MatchAllDocsQuery()).matchesUnorderedIds(Integer.valueOf(1), Integer.valueOf(2));
        this.helper.assertThat(parser.parse("entity:alarm")).from(MyEntity.class).matchesExactlyIds(Integer.valueOf(1));
        this.helper.assertThat(parser.parse("property:sound")).from(AlarmEntity.class).matchesNone();
        this.helper.assertThat(parser.parse("description_analyzer2:sound")).from(AlarmEntity.class).matchesExactlyIds(Integer.valueOf(2));
        this.helper.assertThat(parser.parse("description_analyzer3:music")).from(AlarmEntity.class).matchesExactlyIds(Integer.valueOf(2));
        this.helper.assertThat(parser.parse("description_normalizer1:symphony")).from(AlarmEntity.class).matchesExactlyIds(Integer.valueOf(2));
    }
}

