/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.bridge.time;

import java.time.Period;
import org.assertj.core.api.Assertions;
import org.hibernate.search.bridge.builtin.time.impl.PeriodBridge;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class PeriodBridgeTest {
    private static final PeriodBridge BRIDGE = PeriodBridge.INSTANCE;
    private static final Period MAX_PERIOD = Period.of(Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE);
    private static final Period MIN_PERIOD = Period.of(Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE);
    private static final Period ZERO_PERIOD = Period.ZERO;
    private static final Period CUSTOM_PERIOD = Period.of(100, -20, 3);
    private static final String MAX = "+2147483647+2147483647+2147483647";
    private static final String MIN = "-2147483648-2147483648-2147483648";
    private static final String ZER = "+0000000000+0000000000+0000000000";
    private static final String CST = "+0000000100-0000000020+0000000003";
    @Rule
    public final ExpectedException thrown = ExpectedException.none();

    @Test
    public void testMaxObjectToString() throws Exception {
        Assertions.assertThat((String)BRIDGE.objectToString((Object)MAX_PERIOD)).isEqualTo((Object)MAX);
    }

    @Test
    public void testMinObjectToString() throws Exception {
        Assertions.assertThat((String)BRIDGE.objectToString((Object)MIN_PERIOD)).isEqualTo((Object)MIN);
    }

    @Test
    public void testPaddingObjectToString() throws Exception {
        Assertions.assertThat((String)BRIDGE.objectToString((Object)CUSTOM_PERIOD)).isEqualTo((Object)CST);
    }

    @Test
    public void testZeroObjectToString() throws Exception {
        Assertions.assertThat((String)BRIDGE.objectToString((Object)ZERO_PERIOD)).isEqualTo((Object)ZER);
    }

    @Test
    public void testMaxStringToObject() throws Exception {
        Assertions.assertThat((Object)BRIDGE.stringToObject(MAX)).isEqualTo((Object)MAX_PERIOD);
    }

    @Test
    public void testMinStringToObject() throws Exception {
        Assertions.assertThat((Object)BRIDGE.stringToObject(MIN)).isEqualTo((Object)MIN_PERIOD);
    }

    @Test
    public void testPaddingStringToObject() throws Exception {
        Assertions.assertThat((Object)BRIDGE.stringToObject(CST)).isEqualTo((Object)CUSTOM_PERIOD);
    }

    @Test
    public void testZeroStringToObject() throws Exception {
        Assertions.assertThat((Object)BRIDGE.stringToObject(ZER)).isEqualTo((Object)ZERO_PERIOD);
    }
}

