/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.dsl;

import java.io.Serializable;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.hibernate.search.query.dsl.QueryBuilder;
import org.hibernate.search.query.dsl.TermMatchingContext;
import org.hibernate.search.test.dsl.Coffee;
import org.hibernate.search.test.dsl.CoffeeBrand;
import org.hibernate.search.testsupport.TestForIssue;
import org.hibernate.search.testsupport.junit.SearchFactoryHolder;
import org.hibernate.search.testsupport.junit.SearchITHelper;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

@TestForIssue(jiraKey="HSEARCH-2983")
public class BoostDSLTest {
    @Rule
    public final SearchFactoryHolder sfHolder = new SearchFactoryHolder(Coffee.class, CoffeeBrand.class);
    private final SearchITHelper helper = new SearchITHelper(this.sfHolder);

    @Before
    public void setUp() throws Exception {
        this.indexTestData();
    }

    @Test
    public void testBoostOnTermQuery() {
        QueryBuilder qb = this.helper.queryBuilder(Coffee.class);
        Query query = qb.bool().should(((TermMatchingContext)qb.keyword().onField("name").boostedTo(40.0f)).matching((Object)"Kazaar").createQuery()).should(((TermMatchingContext)qb.keyword().onField("summary").boostedTo(1.0f)).matching((Object)"VELVETY").createQuery()).createQuery();
        this.helper.assertThat(query).from(Coffee.class).sort(new Sort(SortField.FIELD_SCORE)).matchesExactlyIds(new Serializable[]{"Kazaar", "Dharkan"});
        query = qb.bool().should(((TermMatchingContext)qb.keyword().onField("name").boostedTo(1.0f)).matching((Object)"Kazaar").createQuery()).should(((TermMatchingContext)qb.keyword().onField("summary").boostedTo(40.0f)).matching((Object)"VELVETY").createQuery()).createQuery();
        this.helper.assertThat(query).from(Coffee.class).sort(new Sort(SortField.FIELD_SCORE)).matchesExactlyIds(new Serializable[]{"Dharkan", "Kazaar"});
    }

    @Test
    public void testBoostOnNumericQuery() {
        QueryBuilder qb = this.helper.queryBuilder(Coffee.class);
        Query query = qb.bool().should(((TermMatchingContext)qb.keyword().onField("name").boostedTo(40.0f)).matching((Object)"Kazaar").createQuery()).should(((TermMatchingContext)qb.keyword().onField("intensity").boostedTo(1.0f)).matching((Object)11).createQuery()).createQuery();
        this.helper.assertThat(query).from(Coffee.class).sort(new Sort(SortField.FIELD_SCORE)).matchesExactlyIds(new Serializable[]{"Kazaar", "Dharkan"});
        query = qb.bool().should(((TermMatchingContext)qb.keyword().onField("name").boostedTo(1.0f)).matching((Object)"Kazaar").createQuery()).should(((TermMatchingContext)qb.keyword().onField("intensity").boostedTo(40.0f)).matching((Object)11).createQuery()).createQuery();
        this.helper.assertThat(query).from(Coffee.class).sort(new Sort(SortField.FIELD_SCORE)).matchesExactlyIds(new Serializable[]{"Dharkan", "Kazaar"});
    }

    private void indexTestData() {
        this.createCoffee("Kazaar", "EXCEPTIONALLY INTENSE AND SYRUPY", "A daring blend of two Robustas from Brazil and Guatemala, specially prepared for Nespresso, and a separately roasted Arabica from South America, Kazaar is a coffee of exceptional intensity. Its powerful bitterness and notes of pepper are balanced by a full and creamy texture.", 12);
        this.createCoffee("Dharkan", "LONG ROASTED AND VELVETY", "This blend of Arabicas from Latin America and Asia fully unveils its character thanks to the technique of long roasting at a low temperature. Its powerful personality reveals intense roasted notes together with hints of bitter cocoa powder and toasted cereals that express themselves in a silky and velvety txture.", 11);
        this.createCoffee("Ristretto", "POWERFUL AND CONTRASTING", "A blend of South American and East African Arabicas, with a touch of Robusta, roasted separately to create the subtle fruity note of this full-bodied, intense espresso.", 10);
    }

    private void createCoffee(String name, String summary, String description, int intensity) {
        Coffee coffee = new Coffee();
        coffee.setId(name);
        coffee.setName(name);
        coffee.setSummary(summary);
        coffee.setDescription(description);
        coffee.setIntensity(intensity);
        this.helper.add(coffee);
    }
}

