/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.dsl;

import org.apache.lucene.document.Document;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.hibernate.search.annotations.DocumentId;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.FieldBridge;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.IndexedEmbedded;
import org.hibernate.search.annotations.SortableField;
import org.hibernate.search.annotations.Spatial;
import org.hibernate.search.annotations.SpatialMode;
import org.hibernate.search.bridge.LuceneOptions;
import org.hibernate.search.bridge.MetadataProvidingFieldBridge;
import org.hibernate.search.bridge.StringBridge;
import org.hibernate.search.bridge.spi.FieldMetadataBuilder;
import org.hibernate.search.bridge.spi.FieldType;
import org.hibernate.search.exception.SearchException;
import org.hibernate.search.query.dsl.QueryBuilder;
import org.hibernate.search.query.dsl.sort.SortDistanceFieldAndReferenceContext;
import org.hibernate.search.query.dsl.sort.SortFieldContext;
import org.hibernate.search.query.dsl.sort.SortScoreContext;
import org.hibernate.search.query.dsl.sort.SortTermination;
import org.hibernate.search.spatial.Coordinates;
import org.hibernate.search.testsupport.TestForIssue;
import org.hibernate.search.testsupport.junit.SearchFactoryHolder;
import org.hibernate.search.testsupport.junit.SearchITHelper;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

@TestForIssue(jiraKey="HSEARCH-1872")
public class SortDSLTest {
    @Rule
    public final SearchFactoryHolder sfHolder = new SearchFactoryHolder(IndexedEntry.class);
    private final SearchITHelper helper = new SearchITHelper(this.sfHolder);

    @Before
    public void prepareTestData() {
        IndexedEntry entry0 = new IndexedEntry(0).setTextField("infrequent1 infrequent2 infrequent1 inMultipleDocsWithUniqueScores inMultipleDocsWithVariousScores inMultipleDocsWithVariousScores").setNonUniqueIntgerField(1).setUniqueIntegerField(3).setUniqueDoubleField(2.0).setLocation(24.0, 31.9);
        IndexedEntry entry1 = new IndexedEntry(1).setTextField("inMultipleDocsWithUniqueScores inMultipleDocsWithUniqueScores inMultipleDocsWithUniqueScores inMultipleDocsWithVariousScores").setNonUniqueIntgerField(2).setUniqueIntegerField(1).setUniqueDoubleField(1.0).setLocation(23.9, 32.0).setPrevious(entry0);
        IndexedEntry entry2 = new IndexedEntry(2).setNonUniqueIntgerField(1).setPrevious(entry1);
        IndexedEntry entry3 = new IndexedEntry(3).setTextField("infrequent1 inMultipleDocsWithUniqueScores inMultipleDocsWithUniqueScores inMultipleDocsWithVariousScores").setNonUniqueIntgerField(1).setUniqueIntegerField(4).setUniqueDoubleField(3.0).setLocation(23.9, 32.1).setPrevious(entry2);
        entry0.setPrevious(entry3);
        this.helper.add(entry0, entry1, entry2, entry3);
    }

    private QueryBuilder builder() {
        return this.sfHolder.getSearchFactory().buildQueryBuilder().forEntity(IndexedEntry.class).get();
    }

    @Test
    public void score() throws Exception {
        Query query = this.builder().keyword().onField("textField").matching((Object)"infrequent1").createQuery();
        Sort sort = this.builder().sort().byScore().createSort();
        this.helper.assertThat(query).from(IndexedEntry.class).sort(sort).matchesExactlyIds(Integer.valueOf(0), Integer.valueOf(3));
        sort = ((SortScoreContext)this.builder().sort().byScore().asc()).createSort();
        this.helper.assertThat(query).from(IndexedEntry.class).sort(sort).matchesExactlyIds(Integer.valueOf(3), Integer.valueOf(0));
        sort = ((SortScoreContext)this.builder().sort().byScore().desc()).createSort();
        this.helper.assertThat(query).from(IndexedEntry.class).sort(sort).matchesExactlyIds(Integer.valueOf(0), Integer.valueOf(3));
    }

    @Test
    public void docID() throws Exception {
        Sort sort = this.builder().sort().byIndexOrder().createSort();
        this.assertQueryAll(sort).matchesExactlyIds(Integer.valueOf(0), Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3));
        sort = ((SortTermination)this.builder().sort().byIndexOrder().asc()).createSort();
        this.assertQueryAll(sort).matchesExactlyIds(Integer.valueOf(0), Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3));
        sort = ((SortTermination)this.builder().sort().byIndexOrder().desc()).createSort();
        this.assertQueryAll(sort).matchesExactlyIds(Integer.valueOf(3), Integer.valueOf(2), Integer.valueOf(1), Integer.valueOf(0));
    }

    @Test
    public void singleField() throws Exception {
        Sort sort = this.builder().sort().byField("uniqueDoubleField").createSort();
        this.assertQueryAll(sort).matchesExactlyIds(Integer.valueOf(2), Integer.valueOf(1), Integer.valueOf(0), Integer.valueOf(3));
        sort = ((SortFieldContext)this.builder().sort().byField("uniqueDoubleField").asc()).createSort();
        this.assertQueryAll(sort).matchesExactlyIds(Integer.valueOf(2), Integer.valueOf(1), Integer.valueOf(0), Integer.valueOf(3));
        sort = ((SortFieldContext)this.builder().sort().byField("uniqueDoubleField").desc()).createSort();
        this.assertQueryAll(sort).matchesExactlyIds(Integer.valueOf(3), Integer.valueOf(0), Integer.valueOf(1), Integer.valueOf(2));
    }

    @Test
    public void singleField_double_missingValue_use() throws Exception {
        Sort sort = ((SortFieldContext)this.builder().sort().byField("uniqueDoubleField").onMissingValue().use((Object)1.5)).createSort();
        this.assertQueryAll(sort).matchesExactlyIds(Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(0), Integer.valueOf(3));
        sort = ((SortFieldContext)((SortFieldContext)this.builder().sort().byField("uniqueDoubleField").asc()).onMissingValue().use((Object)1.5)).createSort();
        this.assertQueryAll(sort).matchesExactlyIds(Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(0), Integer.valueOf(3));
        sort = ((SortFieldContext)((SortFieldContext)this.builder().sort().byField("uniqueDoubleField").desc()).onMissingValue().use((Object)1.5)).createSort();
        this.assertQueryAll(sort).matchesExactlyIds(Integer.valueOf(3), Integer.valueOf(0), Integer.valueOf(2), Integer.valueOf(1));
    }

    @Test
    public void singleField_integer_missingValue_use() throws Exception {
        Sort sort = ((SortFieldContext)this.builder().sort().byField("uniqueIntegerField").onMissingValue().use((Object)2)).createSort();
        this.assertQueryAll(sort).matchesExactlyIds(Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(0), Integer.valueOf(3));
        sort = ((SortFieldContext)((SortFieldContext)this.builder().sort().byField("uniqueIntegerField").asc()).onMissingValue().use((Object)2)).createSort();
        this.assertQueryAll(sort).matchesExactlyIds(Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(0), Integer.valueOf(3));
        sort = ((SortFieldContext)((SortFieldContext)this.builder().sort().byField("uniqueIntegerField").desc()).onMissingValue().use((Object)2)).createSort();
        this.assertQueryAll(sort).matchesExactlyIds(Integer.valueOf(3), Integer.valueOf(0), Integer.valueOf(2), Integer.valueOf(1));
    }

    @Test
    public void singleField_stringFieldBridge() throws Exception {
        Sort sort = this.builder().sort().byField("fieldBridgedStringField").createSort();
        this.assertQueryAll(sort).matchesExactlyIds(Integer.valueOf(2), Integer.valueOf(1), Integer.valueOf(0), Integer.valueOf(3));
        sort = ((SortFieldContext)this.builder().sort().byField("fieldBridgedStringField").asc()).createSort();
        this.assertQueryAll(sort).matchesExactlyIds(Integer.valueOf(2), Integer.valueOf(1), Integer.valueOf(0), Integer.valueOf(3));
        sort = ((SortFieldContext)this.builder().sort().byField("fieldBridgedStringField").desc()).createSort();
        this.assertQueryAll(sort).matchesExactlyIds(Integer.valueOf(3), Integer.valueOf(0), Integer.valueOf(1), Integer.valueOf(2));
    }

    @Test(expected=SearchException.class)
    public void singleField_stringFieldBridge_missingValue_use() throws Exception {
        ((SortFieldContext)this.builder().sort().byField("fieldBridgedStringField").onMissingValue().use((Object)"1.5")).createSort();
    }

    @Test
    public void singleField_numericFieldBridge() throws Exception {
        Sort sort = this.builder().sort().byField("fieldBridgedNumericField").createSort();
        this.assertQueryAll(sort).matchesExactlyIds(Integer.valueOf(2), Integer.valueOf(1), Integer.valueOf(0), Integer.valueOf(3));
        sort = ((SortFieldContext)this.builder().sort().byField("fieldBridgedNumericField").asc()).createSort();
        this.assertQueryAll(sort).matchesExactlyIds(Integer.valueOf(2), Integer.valueOf(1), Integer.valueOf(0), Integer.valueOf(3));
        sort = ((SortFieldContext)this.builder().sort().byField("fieldBridgedNumericField").desc()).createSort();
        this.assertQueryAll(sort).matchesExactlyIds(Integer.valueOf(3), Integer.valueOf(0), Integer.valueOf(1), Integer.valueOf(2));
    }

    @Test
    public void singleField_numericFieldBridge_missingValue_use() throws Exception {
        Sort sort = ((SortFieldContext)this.builder().sort().byField("fieldBridgedNumericField").onMissingValue().use((Object)1.5)).createSort();
        this.assertQueryAll(sort).matchesExactlyIds(Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(0), Integer.valueOf(3));
        sort = ((SortFieldContext)((SortFieldContext)this.builder().sort().byField("fieldBridgedNumericField").asc()).onMissingValue().use((Object)1.5)).createSort();
        this.assertQueryAll(sort).matchesExactlyIds(Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(0), Integer.valueOf(3));
        sort = ((SortFieldContext)((SortFieldContext)this.builder().sort().byField("fieldBridgedNumericField").desc()).onMissingValue().use((Object)1.5)).createSort();
        this.assertQueryAll(sort).matchesExactlyIds(Integer.valueOf(3), Integer.valueOf(0), Integer.valueOf(2), Integer.valueOf(1));
    }

    @Test(expected=ClassCastException.class)
    public void singleField_numericFieldBridge_missingValue_use_nonRaw() throws Exception {
        Sort sort = ((SortFieldContext)this.builder().sort().byField("fieldBridgedNumericField").onMissingValue().use((Object)new WrappedDoubleValue(1.5))).createSort();
        this.sfHolder.getSearchFactory().createHSQuery((Query)new MatchAllDocsQuery(), new Class[]{IndexedEntry.class}).sort(sort).queryEntityInfos();
    }

    @Test
    public void singleField_double_missingValue_sortFirst() throws Exception {
        Sort sort = ((SortFieldContext)this.builder().sort().byField("uniqueDoubleField").onMissingValue().sortFirst()).createSort();
        this.assertQueryAll(sort).matchesExactlyIds(Integer.valueOf(2), Integer.valueOf(1), Integer.valueOf(0), Integer.valueOf(3));
        sort = ((SortFieldContext)((SortFieldContext)this.builder().sort().byField("uniqueDoubleField").asc()).onMissingValue().sortFirst()).createSort();
        this.assertQueryAll(sort).matchesExactlyIds(Integer.valueOf(2), Integer.valueOf(1), Integer.valueOf(0), Integer.valueOf(3));
        sort = ((SortFieldContext)((SortFieldContext)this.builder().sort().byField("uniqueDoubleField").desc()).onMissingValue().sortFirst()).createSort();
        this.assertQueryAll(sort).matchesExactlyIds(Integer.valueOf(2), Integer.valueOf(3), Integer.valueOf(0), Integer.valueOf(1));
    }

    @Test
    public void singleField_integer_missingValue_sortFirst() throws Exception {
        Sort sort = ((SortFieldContext)this.builder().sort().byField("uniqueIntegerField").onMissingValue().sortFirst()).createSort();
        this.assertQueryAll(sort).matchesExactlyIds(Integer.valueOf(2), Integer.valueOf(1), Integer.valueOf(0), Integer.valueOf(3));
        sort = ((SortFieldContext)((SortFieldContext)this.builder().sort().byField("uniqueIntegerField").asc()).onMissingValue().sortFirst()).createSort();
        this.assertQueryAll(sort).matchesExactlyIds(Integer.valueOf(2), Integer.valueOf(1), Integer.valueOf(0), Integer.valueOf(3));
        sort = ((SortFieldContext)((SortFieldContext)this.builder().sort().byField("uniqueIntegerField").desc()).onMissingValue().sortFirst()).createSort();
        this.assertQueryAll(sort).matchesExactlyIds(Integer.valueOf(2), Integer.valueOf(3), Integer.valueOf(0), Integer.valueOf(1));
    }

    @Test
    public void singleField_missingValue_sortLast() throws Exception {
        Sort sort = ((SortFieldContext)this.builder().sort().byField("uniqueDoubleField").onMissingValue().sortLast()).createSort();
        this.assertQueryAll(sort).matchesExactlyIds(Integer.valueOf(1), Integer.valueOf(0), Integer.valueOf(3), Integer.valueOf(2));
        sort = ((SortFieldContext)((SortFieldContext)this.builder().sort().byField("uniqueDoubleField").asc()).onMissingValue().sortLast()).createSort();
        this.assertQueryAll(sort).matchesExactlyIds(Integer.valueOf(1), Integer.valueOf(0), Integer.valueOf(3), Integer.valueOf(2));
        sort = ((SortFieldContext)((SortFieldContext)this.builder().sort().byField("uniqueDoubleField").desc()).onMissingValue().sortLast()).createSort();
        this.assertQueryAll(sort).matchesExactlyIds(Integer.valueOf(3), Integer.valueOf(0), Integer.valueOf(1), Integer.valueOf(2));
    }

    @Test
    public void multipleFields() throws Exception {
        Sort sort = this.builder().sort().byField("nonUniqueIntegerField").andByField("uniqueDoubleField").createSort();
        this.assertQueryAll(sort).matchesExactlyIds(Integer.valueOf(2), Integer.valueOf(0), Integer.valueOf(3), Integer.valueOf(1));
        sort = ((SortFieldContext)this.builder().sort().byField("nonUniqueIntegerField").andByField("uniqueDoubleField").asc()).createSort();
        this.assertQueryAll(sort).matchesExactlyIds(Integer.valueOf(2), Integer.valueOf(0), Integer.valueOf(3), Integer.valueOf(1));
        sort = ((SortFieldContext)this.builder().sort().byField("nonUniqueIntegerField").andByField("uniqueDoubleField").desc()).createSort();
        this.assertQueryAll(sort).matchesExactlyIds(Integer.valueOf(3), Integer.valueOf(0), Integer.valueOf(2), Integer.valueOf(1));
    }

    @Test
    public void distance() throws Exception {
        Sort sort = this.builder().sort().byDistance().onField("location_hash").fromLatitude(24.0).andLongitude(32.0).createSort();
        this.assertQueryAll(sort).matchesExactlyIds(Integer.valueOf(0), Integer.valueOf(1), Integer.valueOf(3), Integer.valueOf(2));
        sort = ((SortDistanceFieldAndReferenceContext)this.builder().sort().byDistance().onField("location_hash").fromLatitude(24.0).andLongitude(32.0).asc()).createSort();
        this.assertQueryAll(sort).matchesExactlyIds(Integer.valueOf(0), Integer.valueOf(1), Integer.valueOf(3), Integer.valueOf(2));
        sort = ((SortDistanceFieldAndReferenceContext)this.builder().sort().byDistance().onField("location_hash").fromLatitude(24.0).andLongitude(32.0).desc()).createSort();
        this.assertQueryAll(sort).matchesExactlyIds(Integer.valueOf(2), Integer.valueOf(3), Integer.valueOf(1), Integer.valueOf(0));
    }

    @Test
    public void nativeLucene() throws Exception {
        Sort sort = this.builder().sort().byNative(new SortField("uniqueDoubleField", SortField.Type.DOUBLE)).createSort();
        this.assertQueryAll(sort).matchesExactlyIds(Integer.valueOf(2), Integer.valueOf(1), Integer.valueOf(0), Integer.valueOf(3));
        sort = this.builder().sort().byNative(new SortField("uniqueDoubleField", SortField.Type.DOUBLE, false)).createSort();
        this.assertQueryAll(sort).matchesExactlyIds(Integer.valueOf(2), Integer.valueOf(1), Integer.valueOf(0), Integer.valueOf(3));
        sort = this.builder().sort().byNative(new SortField("uniqueDoubleField", SortField.Type.DOUBLE, true)).createSort();
        this.assertQueryAll(sort).matchesExactlyIds(Integer.valueOf(3), Integer.valueOf(0), Integer.valueOf(1), Integer.valueOf(2));
    }

    @Test
    public void fieldThenScore() throws Exception {
        Query query = this.builder().keyword().onField("textField").matching((Object)"inMultipleDocsWithUniqueScores").createQuery();
        Sort sort = this.builder().sort().byField("nonUniqueIntegerField").andByScore().createSort();
        this.assertQuery(query, sort).matchesExactlyIds(Integer.valueOf(3), Integer.valueOf(0), Integer.valueOf(1));
        sort = ((SortFieldContext)this.builder().sort().byField("nonUniqueIntegerField").asc()).andByScore().createSort();
        this.assertQuery(query, sort).matchesExactlyIds(Integer.valueOf(3), Integer.valueOf(0), Integer.valueOf(1));
        sort = ((SortFieldContext)this.builder().sort().byField("nonUniqueIntegerField").desc()).andByScore().createSort();
        this.assertQuery(query, sort).matchesExactlyIds(Integer.valueOf(1), Integer.valueOf(3), Integer.valueOf(0));
    }

    @Test
    public void scoreThenField() throws Exception {
        Query query = this.builder().keyword().onField("textField").matching((Object)"inMultipleDocsWithVariousScores").createQuery();
        Sort sort = this.builder().sort().byScore().andByField("uniqueDoubleField").createSort();
        this.assertQuery(query, sort).matchesExactlyIds(Integer.valueOf(0), Integer.valueOf(1), Integer.valueOf(3));
        sort = ((SortScoreContext)this.builder().sort().byScore().asc()).andByField("uniqueDoubleField").createSort();
        this.assertQuery(query, sort).matchesExactlyIds(Integer.valueOf(1), Integer.valueOf(3), Integer.valueOf(0));
        sort = ((SortScoreContext)this.builder().sort().byScore().desc()).andByField("uniqueDoubleField").createSort();
        this.assertQuery(query, sort).matchesExactlyIds(Integer.valueOf(0), Integer.valueOf(1), Integer.valueOf(3));
    }

    @Test
    @TestForIssue(jiraKey="HSEARCH-2587")
    public void embeddedField() throws Exception {
        Sort sort = this.builder().sort().byField("previous.uniqueDoubleField").createSort();
        this.assertQueryAll(sort).matchesExactlyIds(Integer.valueOf(3), Integer.valueOf(2), Integer.valueOf(1), Integer.valueOf(0));
        sort = ((SortFieldContext)this.builder().sort().byField("previous.uniqueDoubleField").asc()).createSort();
        this.assertQueryAll(sort).matchesExactlyIds(Integer.valueOf(3), Integer.valueOf(2), Integer.valueOf(1), Integer.valueOf(0));
        sort = ((SortFieldContext)this.builder().sort().byField("previous.uniqueDoubleField").desc()).createSort();
        this.assertQueryAll(sort).matchesExactlyIds(Integer.valueOf(0), Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3));
    }

    private SearchITHelper.AssertBuildingHSQueryContext assertQueryAll(Sort sort) {
        return this.helper.assertThat().from(IndexedEntry.class).sort(sort);
    }

    private SearchITHelper.AssertBuildingHSQueryContext assertQuery(Query query, Sort sort) {
        return this.helper.assertThat(query).from(IndexedEntry.class).sort(sort);
    }

    @Indexed
    @Spatial(name="location_hash", spatialMode=SpatialMode.HASH)
    public static class IndexedEntry
    implements Coordinates {
        @DocumentId
        @Field(name="idSort")
        @SortableField(forField="idSort")
        int id;
        @Field
        String textField;
        @Field
        @SortableField
        Integer nonUniqueIntegerField;
        @Field
        @SortableField
        Double uniqueDoubleField;
        @Field
        @SortableField
        Integer uniqueIntegerField;
        @Field(bridge=@FieldBridge(impl=WrappedStringValueFieldBridge.class))
        WrappedStringValue fieldBridgedStringField;
        @Field(bridge=@FieldBridge(impl=WrappedDoubleValueFieldBridge.class))
        WrappedDoubleValue fieldBridgedNumericField;
        @IndexedEmbedded(depth=1)
        IndexedEntry previous;
        Double latitude;
        Double longitude;

        public IndexedEntry() {
        }

        public IndexedEntry(int id) {
            this.id = id;
        }

        public Double getLatitude() {
            return this.latitude;
        }

        public Double getLongitude() {
            return this.longitude;
        }

        public IndexedEntry setTextField(String textField) {
            this.textField = textField;
            return this;
        }

        public IndexedEntry setNonUniqueIntgerField(Integer nonUniqueIntegerField) {
            this.nonUniqueIntegerField = nonUniqueIntegerField;
            return this;
        }

        public IndexedEntry setUniqueIntegerField(Integer uniqueIntegerField) {
            this.uniqueIntegerField = uniqueIntegerField;
            return this;
        }

        public IndexedEntry setUniqueDoubleField(Double uniqueDoubleField) {
            this.uniqueDoubleField = uniqueDoubleField;
            this.fieldBridgedStringField = new WrappedStringValue(uniqueDoubleField == null ? null : String.valueOf(uniqueDoubleField));
            this.fieldBridgedNumericField = new WrappedDoubleValue(uniqueDoubleField);
            return this;
        }

        public IndexedEntry setLocation(Double latitude, Double longitude) {
            this.latitude = latitude;
            this.longitude = longitude;
            return this;
        }

        public IndexedEntry setPrevious(IndexedEntry previous) {
            this.previous = previous;
            return this;
        }
    }

    public static class WrappedStringValueFieldBridge
    implements MetadataProvidingFieldBridge,
    StringBridge {
        public void configureFieldMetadata(String name, FieldMetadataBuilder builder) {
            builder.field(name, FieldType.STRING).sortable(true);
        }

        public String objectToString(Object object) {
            if (object == null) {
                return null;
            }
            return object.toString();
        }

        public void set(String name, Object value, Document document, LuceneOptions luceneOptions) {
            if (value == null) {
                return;
            }
            String stringValue = ((WrappedStringValue)value).value;
            if (stringValue == null) {
                return;
            }
            luceneOptions.addFieldToDocument(name, stringValue, document);
            luceneOptions.addSortedDocValuesFieldToDocument(name, stringValue, document);
        }
    }

    public static class WrappedStringValue {
        final String value;

        public WrappedStringValue(String value) {
            this.value = value;
        }
    }

    public static class WrappedDoubleValueFieldBridge
    implements MetadataProvidingFieldBridge,
    StringBridge {
        public void configureFieldMetadata(String name, FieldMetadataBuilder builder) {
            builder.field(name, FieldType.DOUBLE).sortable(true);
        }

        public String objectToString(Object object) {
            if (object == null) {
                return null;
            }
            return object.toString();
        }

        public void set(String name, Object value, Document document, LuceneOptions luceneOptions) {
            if (value == null) {
                return;
            }
            Double doubleValue = ((WrappedDoubleValue)value).value;
            if (doubleValue == null) {
                return;
            }
            luceneOptions.addNumericFieldToDocument(name, (Object)doubleValue, document);
            luceneOptions.addNumericDocValuesFieldToDocument(name, (Number)doubleValue, document);
        }
    }

    public static class WrappedDoubleValue {
        final Double value;

        public WrappedDoubleValue(Double value) {
            this.value = value;
        }
    }
}

