/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.testsupport.indexmanager;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.lucene.search.similarities.ClassicSimilarity;
import org.apache.lucene.search.similarities.Similarity;
import org.hibernate.search.indexes.spi.DirectoryBasedIndexManager;
import org.hibernate.search.indexes.spi.IndexManager;
import org.hibernate.search.testsupport.setup.SearchConfigurationForTest;
import org.hibernate.search.testsupport.setup.WorkerBuildContextForTest;
import org.junit.rules.ExternalResource;
import org.junit.rules.TestRule;

public class RamIndexManagerFactory
extends ExternalResource
implements TestRule {
    private final List<IndexManager> managersToDestroy = new ArrayList<IndexManager>();

    protected void after() {
        for (IndexManager manager : this.managersToDestroy) {
            manager.destroy();
        }
    }

    public IndexManager[] createArray(int length) {
        IndexManager[] result = new IndexManager[length];
        for (int i = 0; i < length; ++i) {
            result[i] = this.create();
        }
        return result;
    }

    public IndexManager create() {
        RamIndexManager ramIndexManager = new RamIndexManager();
        Properties properties = new Properties();
        properties.setProperty("directory_provider", "local-heap");
        ramIndexManager.initialize("testIndex", properties, (Similarity)new ClassicSimilarity(), new WorkerBuildContextForTest(new SearchConfigurationForTest()));
        this.managersToDestroy.add((IndexManager)ramIndexManager);
        return ramIndexManager;
    }

    private static final class RamIndexManager
    extends DirectoryBasedIndexManager {
        private RamIndexManager() {
        }
    }
}

