/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.id;

import org.apache.lucene.search.NumericRangeQuery;
import org.hibernate.search.annotations.DocumentId;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.NumericField;
import org.hibernate.search.annotations.SortableField;
import org.hibernate.search.annotations.Store;
import org.hibernate.search.engine.integration.impl.ExtendedSearchIntegrator;
import org.hibernate.search.query.dsl.QueryBuilder;
import org.hibernate.search.query.engine.spi.HSQuery;
import org.hibernate.search.testsupport.junit.SearchFactoryHolder;
import org.hibernate.search.testsupport.junit.SearchITHelper;
import org.junit.Rule;
import org.junit.Test;

public class NumericIdEncodingTest {
    @Rule
    public final SearchFactoryHolder factoryHolder = new SearchFactoryHolder(Staff.class);
    private final SearchITHelper helper = new SearchITHelper(this.factoryHolder);

    @Test
    public void testNumericIdRangeQuery() {
        this.helper.index(new Staff(1L, "One"), new Staff(2L, "Two"), new Staff(3L, "Three"), new Staff(4L, "Four"));
        NumericRangeQuery smallRangeQuery = NumericRangeQuery.newLongRange((String)"id", (Long)1L, (Long)3L, (boolean)false, (boolean)false);
        this.expectedProjections((NumericRangeQuery<Long>)smallRangeQuery, "Two");
        NumericRangeQuery universeRangeQuery = NumericRangeQuery.newLongRange((String)"id", null, null, (boolean)false, (boolean)false);
        this.expectedProjections((NumericRangeQuery<Long>)universeRangeQuery, "One", "Two", "Three", "Four");
    }

    private void expectedProjections(NumericRangeQuery<Long> numericRangeQuery, String ... expectedProjections) {
        ExtendedSearchIntegrator searchFactory = this.factoryHolder.getSearchFactory();
        QueryBuilder queryBuilder = this.helper.queryBuilder(Staff.class);
        HSQuery hsQuery = searchFactory.createHSQuery(numericRangeQuery, new Class[]{Staff.class}).projection(new String[]{"name"}).sort(queryBuilder.sort().byField("idSort").createSort());
        this.helper.assertThat(hsQuery).matchesExactlySingleProjections(expectedProjections).hasResultSize(expectedProjections.length);
    }

    @Indexed
    public class Staff {
        @DocumentId
        @NumericField(forField="id")
        @Field(name="idSort")
        @SortableField(forField="idSort")
        final Long id;
        @Field(store=Store.YES)
        final String name;

        Staff(long id, String name) {
            this.id = id;
            this.name = name;
        }
    }
}

