/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.backend.lucene;

import org.hibernate.search.test.backend.lucene.Quote;
import org.hibernate.search.testsupport.junit.SearchFactoryHolder;
import org.hibernate.search.testsupport.junit.SearchITHelper;
import org.hibernate.search.testsupport.junit.SkipOnElasticsearch;
import org.jboss.byteman.contrib.bmunit.BMRule;
import org.jboss.byteman.contrib.bmunit.BMUnitRunner;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=BMUnitRunner.class)
@Category(value={SkipOnElasticsearch.class})
public class SyncWorkProcessorShutDownTest {
    @Rule
    public final SearchFactoryHolder sfAsyncExclusiveIndex = new SearchFactoryHolder(Quote.class).withProperty("hibernate.search.default.exclusive_index_use", "true");
    private final SearchITHelper helper = new SearchITHelper(this.sfAsyncExclusiveIndex);

    @Test
    @BMRule(targetClass="org.apache.lucene.index.IndexWriter", targetMethod="commit", action="throw new Error(\"error!\")", name="commitError")
    public void testErrorHandlingDuringCommit() throws Exception {
        Quote quote = new Quote(1, "description");
        this.helper.add(quote);
        this.sfAsyncExclusiveIndex.getSearchFactory().close();
    }
}

