/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.dsl;

import java.io.Serializable;
import org.hibernate.search.annotations.DocumentId;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.exception.SearchException;
import org.hibernate.search.query.dsl.QueryBuilder;
import org.hibernate.search.query.engine.spi.HSQuery;
import org.hibernate.search.testsupport.TestForIssue;
import org.hibernate.search.testsupport.junit.SearchFactoryHolder;
import org.hibernate.search.testsupport.junit.SearchITHelper;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class BoolDSLTest {
    private static final String DOCUMENT_1 = "1";
    private static final String DOCUMENT_2 = "2";
    private static final String DOCUMENT_3 = "3";
    private static final String FIELD1_VALUE1 = "Irving";
    private static final Integer FIELD2_VALUE1 = 3;
    private static final Integer FIELD3_VALUE1 = 4;
    private static final Integer FIELD4_VALUE1AND2 = 1000;
    private static final Integer FIELD5_VALUE1AND2 = 2000;
    private static final String FIELD1_VALUE2 = "Auster";
    private static final Integer FIELD2_VALUE2 = 13;
    private static final Integer FIELD3_VALUE2 = 14;
    private static final String FIELD1_VALUE3 = "Coe";
    private static final Integer FIELD2_VALUE3 = 25;
    private static final Integer FIELD3_VALUE3 = 42;
    private static final Integer FIELD4_VALUE3 = 42000;
    private static final Integer FIELD5_VALUE3 = 142000;
    @Rule
    public final SearchFactoryHolder sfHolder = new SearchFactoryHolder(IndexedEntity.class);
    private final SearchITHelper helper = new SearchITHelper(this.sfHolder);
    @Rule
    public final ExpectedException thrown = ExpectedException.none();

    @Before
    public void setup() {
        this.initData();
    }

    @Test
    public void must() {
        QueryBuilder queryBuilder = this.helper.queryBuilder(IndexedEntity.class);
        HSQuery query = this.helper.hsQuery(queryBuilder.bool().must(queryBuilder.keyword().onField("field1").matching((Object)FIELD1_VALUE1).createQuery()).createQuery(), new Class[0]);
        this.helper.assertThat(query).matchesUnorderedIds(new Serializable[]{DOCUMENT_1});
        query = this.helper.hsQuery(queryBuilder.bool().must(queryBuilder.keyword().onField("field1").matching((Object)FIELD1_VALUE1).createQuery()).must(queryBuilder.keyword().onField("field2").matching((Object)FIELD2_VALUE2).createQuery()).createQuery(), new Class[0]);
        this.helper.assertThat(query).matchesNone();
        query = this.helper.hsQuery(queryBuilder.bool().must(queryBuilder.keyword().onField("field1").matching((Object)FIELD1_VALUE1).createQuery()).must(queryBuilder.keyword().onField("field2").matching((Object)FIELD2_VALUE1).createQuery()).createQuery(), new Class[0]);
        this.helper.assertThat(query).matchesUnorderedIds(new Serializable[]{DOCUMENT_1});
    }

    @Test
    public void should() {
        QueryBuilder queryBuilder = this.helper.queryBuilder(IndexedEntity.class);
        HSQuery query = this.helper.hsQuery(queryBuilder.bool().should(queryBuilder.keyword().onField("field1").matching((Object)FIELD1_VALUE1).createQuery()).createQuery(), new Class[0]);
        this.helper.assertThat(query).matchesUnorderedIds(new Serializable[]{DOCUMENT_1});
        query = this.helper.hsQuery(queryBuilder.bool().should(queryBuilder.keyword().onField("field1").matching((Object)FIELD1_VALUE1).createQuery()).should(queryBuilder.keyword().onField("field1").matching((Object)FIELD1_VALUE2).createQuery()).createQuery(), new Class[0]);
        this.helper.assertThat(query).matchesUnorderedIds(new Serializable[]{DOCUMENT_1, DOCUMENT_2});
    }

    @Test
    public void mustNot() {
        QueryBuilder queryBuilder = this.helper.queryBuilder(IndexedEntity.class);
        HSQuery query = this.helper.hsQuery(queryBuilder.bool().must(queryBuilder.keyword().onField("field1").matching((Object)FIELD1_VALUE1).createQuery()).not().createQuery(), new Class[0]);
        this.helper.assertThat(query).matchesUnorderedIds(new Serializable[]{DOCUMENT_2, DOCUMENT_3});
        query = this.helper.hsQuery(queryBuilder.bool().must(queryBuilder.keyword().onField("field1").matching((Object)FIELD1_VALUE1).createQuery()).not().must(queryBuilder.keyword().onField("field1").matching((Object)FIELD1_VALUE3).createQuery()).not().createQuery(), new Class[0]);
        this.helper.assertThat(query).matchesUnorderedIds(new Serializable[]{DOCUMENT_2});
    }

    @Test
    public void should_mustNot() {
        QueryBuilder queryBuilder = this.helper.queryBuilder(IndexedEntity.class);
        HSQuery query = this.helper.hsQuery(queryBuilder.bool().should(queryBuilder.keyword().onField("field1").matching((Object)FIELD1_VALUE1).createQuery()).should(queryBuilder.keyword().onField("field1").matching((Object)FIELD1_VALUE3).createQuery()).must(queryBuilder.keyword().onField("field1").matching((Object)FIELD1_VALUE1).createQuery()).not().createQuery(), new Class[0]);
        this.helper.assertThat(query).matchesUnorderedIds(new Serializable[]{DOCUMENT_3});
    }

    @Test
    public void must_mustNot() {
        QueryBuilder queryBuilder = this.helper.queryBuilder(IndexedEntity.class);
        HSQuery query = this.helper.hsQuery(queryBuilder.bool().must(queryBuilder.keyword().onField("field1").matching((Object)FIELD1_VALUE1).createQuery()).must(queryBuilder.keyword().onField("field1").matching((Object)FIELD1_VALUE1).createQuery()).not().createQuery(), new Class[0]);
        this.helper.assertThat(query).matchesNone();
        query = this.helper.hsQuery(queryBuilder.bool().must(queryBuilder.keyword().onField("field1").matching((Object)FIELD1_VALUE1).createQuery()).must(queryBuilder.keyword().onField("field1").matching((Object)FIELD1_VALUE2).createQuery()).not().createQuery(), new Class[0]);
        this.helper.assertThat(query).matchesUnorderedIds(new Serializable[]{DOCUMENT_1});
    }

    @Test
    public void must_should() {
        QueryBuilder queryBuilder = this.helper.queryBuilder(IndexedEntity.class);
        HSQuery query = this.helper.hsQuery(queryBuilder.bool().must(queryBuilder.keyword().onField("field1").matching((Object)FIELD1_VALUE1).createQuery()).should(queryBuilder.keyword().onField("field2").matching((Object)FIELD2_VALUE2).createQuery()).should(queryBuilder.keyword().onField("field3").matching((Object)FIELD3_VALUE3).createQuery()).createQuery(), new Class[0]);
        this.helper.assertThat(query).matchesUnorderedIds(new Serializable[]{DOCUMENT_1});
        query = this.helper.hsQuery(queryBuilder.bool().must(queryBuilder.keyword().onField("field1").matching((Object)FIELD1_VALUE2).createQuery()).should(queryBuilder.keyword().onField("field2").matching((Object)FIELD2_VALUE1).createQuery()).should(queryBuilder.keyword().onField("field3").matching((Object)FIELD3_VALUE3).createQuery()).createQuery(), new Class[0]);
        this.helper.assertThat(query).matchesUnorderedIds(new Serializable[]{DOCUMENT_2});
    }

    @Test
    public void filter_should() {
        QueryBuilder queryBuilder = this.helper.queryBuilder(IndexedEntity.class);
        HSQuery query = this.helper.hsQuery(queryBuilder.bool().must(queryBuilder.keyword().onField("field1").matching((Object)FIELD1_VALUE1).createQuery()).disableScoring().should(queryBuilder.keyword().onField("field2").matching((Object)FIELD2_VALUE2).createQuery()).should(queryBuilder.keyword().onField("field3").matching((Object)FIELD3_VALUE3).createQuery()).createQuery(), new Class[0]);
        this.helper.assertThat(query).matchesUnorderedIds(new Serializable[]{DOCUMENT_1});
        query = this.helper.hsQuery(queryBuilder.bool().must(queryBuilder.keyword().onField("field1").matching((Object)FIELD1_VALUE1).createQuery()).disableScoring().should(queryBuilder.keyword().onField("field2").matching((Object)FIELD2_VALUE1).createQuery()).should(queryBuilder.keyword().onField("field3").matching((Object)FIELD3_VALUE3).createQuery()).createQuery(), new Class[0]);
        this.helper.assertThat(query).matchesUnorderedIds(new Serializable[]{DOCUMENT_1});
    }

    @Test
    public void mustNot_should() {
        QueryBuilder queryBuilder = this.helper.queryBuilder(IndexedEntity.class);
        HSQuery query = this.helper.hsQuery(queryBuilder.bool().must(queryBuilder.keyword().onField("field1").matching((Object)FIELD1_VALUE2).createQuery()).not().must(queryBuilder.keyword().onField("field1").matching((Object)FIELD1_VALUE3).createQuery()).not().should(queryBuilder.keyword().onField("field2").matching((Object)FIELD2_VALUE2).createQuery()).should(queryBuilder.keyword().onField("field3").matching((Object)FIELD3_VALUE3).createQuery()).createQuery(), new Class[0]);
        this.helper.assertThat(query).matchesNone();
        query = this.helper.hsQuery(queryBuilder.bool().must(queryBuilder.keyword().onField("field1").matching((Object)FIELD1_VALUE1).createQuery()).not().must(queryBuilder.keyword().onField("field1").matching((Object)FIELD1_VALUE3).createQuery()).not().should(queryBuilder.keyword().onField("field2").matching((Object)FIELD2_VALUE2).createQuery()).should(queryBuilder.keyword().onField("field3").matching((Object)FIELD3_VALUE3).createQuery()).createQuery(), new Class[0]);
        this.helper.assertThat(query).matchesUnorderedIds(new Serializable[]{DOCUMENT_2});
    }

    @Test
    public void minimumShouldMatchNumber_positive() {
        QueryBuilder queryBuilder = this.helper.queryBuilder(IndexedEntity.class);
        HSQuery query = this.helper.hsQuery(queryBuilder.bool().minimumShouldMatchNumber(1).should(queryBuilder.keyword().onField("field1").matching((Object)FIELD1_VALUE1).createQuery()).should(queryBuilder.keyword().onField("field2").matching((Object)FIELD2_VALUE3).createQuery()).createQuery(), new Class[0]);
        this.helper.assertThat(query).matchesUnorderedIds(new Serializable[]{DOCUMENT_1, DOCUMENT_3});
        query = this.helper.hsQuery(queryBuilder.bool().must(queryBuilder.keyword().onField("field4").matching((Object)FIELD4_VALUE1AND2).createQuery()).minimumShouldMatchNumber(1).should(queryBuilder.keyword().onField("field2").matching((Object)FIELD2_VALUE2).createQuery()).should(queryBuilder.keyword().onField("field3").matching((Object)FIELD3_VALUE3).createQuery()).createQuery(), new Class[0]);
        this.helper.assertThat(query).matchesUnorderedIds(new Serializable[]{DOCUMENT_2});
        query = this.helper.hsQuery(queryBuilder.bool().minimumShouldMatchNumber(2).should(queryBuilder.keyword().onField("field4").matching((Object)FIELD4_VALUE1AND2).createQuery()).should(queryBuilder.keyword().onField("field2").matching((Object)FIELD2_VALUE1).createQuery()).should(queryBuilder.keyword().onField("field3").matching((Object)FIELD3_VALUE3).createQuery()).createQuery(), new Class[0]);
        this.helper.assertThat(query).matchesUnorderedIds(new Serializable[]{DOCUMENT_1});
        query = this.helper.hsQuery(queryBuilder.bool().minimumShouldMatchNumber(2).should(queryBuilder.keyword().onField("field4").matching((Object)FIELD4_VALUE1AND2).createQuery()).should(queryBuilder.keyword().onField("field2").matching((Object)FIELD2_VALUE1).createQuery()).createQuery(), new Class[0]);
        this.helper.assertThat(query).matchesUnorderedIds(new Serializable[]{DOCUMENT_1});
    }

    @Test
    public void minimumShouldMatchNumber_negative() {
        QueryBuilder queryBuilder = this.helper.queryBuilder(IndexedEntity.class);
        HSQuery query = this.helper.hsQuery(queryBuilder.bool().minimumShouldMatchNumber(-1).should(queryBuilder.keyword().onField("field1").matching((Object)FIELD1_VALUE1).createQuery()).should(queryBuilder.keyword().onField("field2").matching((Object)FIELD2_VALUE3).createQuery()).createQuery(), new Class[0]);
        this.helper.assertThat(query).matchesUnorderedIds(new Serializable[]{DOCUMENT_1, DOCUMENT_3});
        query = this.helper.hsQuery(queryBuilder.bool().must(queryBuilder.keyword().onField("field4").matching((Object)FIELD4_VALUE1AND2).createQuery()).minimumShouldMatchNumber(-1).should(queryBuilder.keyword().onField("field2").matching((Object)FIELD2_VALUE2).createQuery()).should(queryBuilder.keyword().onField("field3").matching((Object)FIELD3_VALUE3).createQuery()).createQuery(), new Class[0]);
        this.helper.assertThat(query).matchesUnorderedIds(new Serializable[]{DOCUMENT_2});
        query = this.helper.hsQuery(queryBuilder.bool().minimumShouldMatchNumber(-1).should(queryBuilder.keyword().onField("field4").matching((Object)FIELD4_VALUE1AND2).createQuery()).should(queryBuilder.keyword().onField("field2").matching((Object)FIELD2_VALUE1).createQuery()).should(queryBuilder.keyword().onField("field3").matching((Object)FIELD3_VALUE3).createQuery()).createQuery(), new Class[0]);
        this.helper.assertThat(query).matchesUnorderedIds(new Serializable[]{DOCUMENT_1});
    }

    @Test
    public void minimumShouldMatchPercent_positive() {
        QueryBuilder queryBuilder = this.helper.queryBuilder(IndexedEntity.class);
        HSQuery query = this.helper.hsQuery(queryBuilder.bool().minimumShouldMatchPercent(50).should(queryBuilder.keyword().onField("field1").matching((Object)FIELD1_VALUE1).createQuery()).should(queryBuilder.keyword().onField("field2").matching((Object)FIELD2_VALUE3).createQuery()).createQuery(), new Class[0]);
        this.helper.assertThat(query).matchesUnorderedIds(new Serializable[]{DOCUMENT_1, DOCUMENT_3});
        query = this.helper.hsQuery(queryBuilder.bool().must(queryBuilder.keyword().onField("field4").matching((Object)FIELD4_VALUE1AND2).createQuery()).minimumShouldMatchPercent(50).should(queryBuilder.keyword().onField("field2").matching((Object)FIELD2_VALUE2).createQuery()).should(queryBuilder.keyword().onField("field3").matching((Object)FIELD3_VALUE3).createQuery()).createQuery(), new Class[0]);
        this.helper.assertThat(query).matchesUnorderedIds(new Serializable[]{DOCUMENT_2});
        query = this.helper.hsQuery(queryBuilder.bool().minimumShouldMatchPercent(70).should(queryBuilder.keyword().onField("field4").matching((Object)FIELD4_VALUE1AND2).createQuery()).should(queryBuilder.keyword().onField("field2").matching((Object)FIELD2_VALUE1).createQuery()).should(queryBuilder.keyword().onField("field3").matching((Object)FIELD3_VALUE3).createQuery()).createQuery(), new Class[0]);
        this.helper.assertThat(query).matchesUnorderedIds(new Serializable[]{DOCUMENT_1});
        query = this.helper.hsQuery(queryBuilder.bool().minimumShouldMatchPercent(100).should(queryBuilder.keyword().onField("field4").matching((Object)FIELD4_VALUE1AND2).createQuery()).should(queryBuilder.keyword().onField("field2").matching((Object)FIELD2_VALUE1).createQuery()).createQuery(), new Class[0]);
        this.helper.assertThat(query).matchesUnorderedIds(new Serializable[]{DOCUMENT_1});
    }

    @Test
    public void minimumShouldMatchPercent_negative() {
        QueryBuilder queryBuilder = this.helper.queryBuilder(IndexedEntity.class);
        HSQuery query = this.helper.hsQuery(queryBuilder.bool().minimumShouldMatchPercent(-50).should(queryBuilder.keyword().onField("field1").matching((Object)FIELD1_VALUE1).createQuery()).should(queryBuilder.keyword().onField("field2").matching((Object)FIELD2_VALUE3).createQuery()).createQuery(), new Class[0]);
        this.helper.assertThat(query).matchesUnorderedIds(new Serializable[]{DOCUMENT_1, DOCUMENT_3});
        query = this.helper.hsQuery(queryBuilder.bool().must(queryBuilder.keyword().onField("field4").matching((Object)FIELD4_VALUE1AND2).createQuery()).minimumShouldMatchPercent(-50).should(queryBuilder.keyword().onField("field2").matching((Object)FIELD2_VALUE2).createQuery()).should(queryBuilder.keyword().onField("field3").matching((Object)FIELD3_VALUE3).createQuery()).createQuery(), new Class[0]);
        this.helper.assertThat(query).matchesUnorderedIds(new Serializable[]{DOCUMENT_2});
        query = this.helper.hsQuery(queryBuilder.bool().minimumShouldMatchPercent(-40).should(queryBuilder.keyword().onField("field4").matching((Object)FIELD4_VALUE1AND2).createQuery()).should(queryBuilder.keyword().onField("field2").matching((Object)FIELD2_VALUE1).createQuery()).should(queryBuilder.keyword().onField("field3").matching((Object)FIELD3_VALUE3).createQuery()).createQuery(), new Class[0]);
        this.helper.assertThat(query).matchesUnorderedIds(new Serializable[]{DOCUMENT_1});
    }

    @Test
    public void minimumShouldMatch_error_multipleConflictingConstraints() {
        QueryBuilder queryBuilder = this.helper.queryBuilder(IndexedEntity.class);
        this.thrown.expect(SearchException.class);
        this.thrown.expectMessage("Multiple conflicting minimumShouldMatch constraints");
        queryBuilder.bool().minimumShouldMatchNumber(-1).minimumShouldMatchPercent(100);
    }

    @Test
    @TestForIssue(jiraKey="HSEARCH-3535")
    public void minimumShouldMatch_error_outOfBounds() {
        QueryBuilder queryBuilder = this.helper.queryBuilder(IndexedEntity.class);
        this.thrown.expect(SearchException.class);
        this.thrown.expectMessage("Computed minimum for minimumShouldMatch constraint is out of bounds");
        this.thrown.expectMessage("expected a number between '1' and '1', got '3'");
        queryBuilder.bool().should(queryBuilder.all().createQuery()).minimumShouldMatchNumber(3).createQuery();
    }

    private void initData() {
        this.helper.index(new IndexedEntity(DOCUMENT_1, FIELD1_VALUE1, FIELD2_VALUE1, FIELD3_VALUE1, FIELD4_VALUE1AND2, FIELD5_VALUE1AND2), new IndexedEntity(DOCUMENT_2, FIELD1_VALUE2, FIELD2_VALUE2, FIELD3_VALUE2, FIELD4_VALUE1AND2, FIELD5_VALUE1AND2), new IndexedEntity(DOCUMENT_3, FIELD1_VALUE3, FIELD2_VALUE3, FIELD3_VALUE3, FIELD4_VALUE3, FIELD5_VALUE3));
        this.helper.assertThat(this.helper.hsQuery(IndexedEntity.class)).matchesUnorderedIds(new Serializable[]{DOCUMENT_1, DOCUMENT_2, DOCUMENT_3});
    }

    @Indexed
    private static class IndexedEntity {
        @DocumentId
        private String id;
        @Field
        private String field1;
        @Field
        private Integer field2;
        @Field
        private Integer field3;
        @Field
        private Integer field4;
        @Field
        private Integer field5;

        IndexedEntity(String id, String field1, Integer field2, Integer field3, Integer field4, Integer field5) {
            this.id = id;
            this.field1 = field1;
            this.field2 = field2;
            this.field3 = field3;
            this.field4 = field4;
            this.field5 = field5;
        }
    }
}

