/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.dsl;

import org.apache.lucene.document.Document;
import org.apache.lucene.search.Query;
import org.hibernate.search.annotations.DocumentId;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.bridge.FieldBridge;
import org.hibernate.search.bridge.LuceneOptions;
import org.hibernate.search.bridge.MetadataProvidingFieldBridge;
import org.hibernate.search.bridge.spi.FieldMetadataBuilder;
import org.hibernate.search.bridge.spi.FieldType;
import org.hibernate.search.query.dsl.QueryBuilder;
import org.hibernate.search.testsupport.TestForIssue;
import org.hibernate.search.testsupport.junit.SearchFactoryHolder;
import org.hibernate.search.testsupport.junit.SearchITHelper;
import org.junit.Rule;
import org.junit.Test;

@TestForIssue(jiraKey="HSEARCH-1758")
public class NumericTypeGuessedTest {
    @Rule
    public final SearchFactoryHolder sfHolder = new SearchFactoryHolder(CustomBridgedNumbers.class);
    private final SearchITHelper helper = new SearchITHelper(this.sfHolder);

    @Test
    public void numericRangeQueryOnCustomField() {
        this.storeData("title-one", "1");
        this.storeData("title-two", "2");
        this.storeData("title-three", "3");
        QueryBuilder queryBuilder = this.helper.queryBuilder(CustomBridgedNumbers.class);
        Query query = queryBuilder.range().onField("customField").from((Object)1).excludeLimit().to((Object)3).excludeLimit().createQuery();
        this.helper.assertThat(query).from(CustomBridgedNumbers.class).projecting("title").matchesExactlySingleProjections("title-two");
    }

    private void storeData(String title, String value) {
        CustomBridgedNumbers entry = new CustomBridgedNumbers();
        entry.title = title;
        entry.textEncodedInt = value;
        this.helper.add(entry);
    }

    public static class NumericEncodingCustom
    implements FieldBridge,
    MetadataProvidingFieldBridge {
        public void configureFieldMetadata(String name, FieldMetadataBuilder builder) {
            builder.field("customField", FieldType.INTEGER);
        }

        public void set(String name, Object value, Document document, LuceneOptions luceneOptions) {
            if (value != null) {
                Integer i = Integer.parseInt((String)value);
                luceneOptions.addNumericFieldToDocument("customField", (Object)i, document);
            }
        }
    }

    @Indexed
    public static class CustomBridgedNumbers {
        @DocumentId
        String title;
        @Field(bridge=@org.hibernate.search.annotations.FieldBridge(impl=NumericEncodingCustom.class))
        String textEncodedInt;
    }
}

