/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.bridge;

import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import org.apache.lucene.document.DateTools;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.StringField;
import org.apache.lucene.index.IndexableField;
import org.hibernate.search.annotations.Resolution;
import org.hibernate.search.bridge.builtin.StringEncodingDateBridge;
import org.hibernate.search.exception.SearchException;
import org.hibernate.search.testsupport.TestForIssue;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class StringEncodingDateBridgeTest {
    private StringEncodingDateBridge bridgeUnderTest;
    private Date testDate;
    private Document testDocument;

    @Before
    public void setUp() {
        this.bridgeUnderTest = new StringEncodingDateBridge(Resolution.MILLISECOND);
        Calendar calendar = GregorianCalendar.getInstance();
        this.testDate = calendar.getTime();
        this.testDocument = new Document();
        StringField stringDateField = new StringField("date", DateTools.dateToString((Date)this.testDate, (DateTools.Resolution)DateTools.Resolution.MILLISECOND), Field.Store.NO);
        this.testDocument.add((IndexableField)stringDateField);
        StringField invalidDateField = new StringField("invalidDate", "foo", Field.Store.NO);
        this.testDocument.add((IndexableField)invalidDateField);
    }

    @Test
    @TestForIssue(jiraKey="HSEARCH-1752")
    public void testFieldBridgeGetReturnsDateInstance() {
        Object o = this.bridgeUnderTest.get("date", this.testDocument);
        Assert.assertTrue((String)("The date bridge should return Date instance from a Document not " + o.getClass()), (boolean)(o instanceof Date));
        Date actualDate = (Date)o;
        Assert.assertEquals((String)"Added and retrieved dates should match", (Object)this.testDate, (Object)actualDate);
    }

    @Test
    @TestForIssue(jiraKey="HSEARCH-1752")
    public void testInvalidDateFieldThrowsException() {
        try {
            this.bridgeUnderTest.get("invalidDate", this.testDocument);
            Assert.fail((String)"The field value is not a valid date and conversion should throw an exception");
        }
        catch (SearchException e) {
            Assert.assertTrue((String)("Unexpected error " + e.getMessage()), (boolean)e.getMessage().startsWith("HSEARCH000240"));
        }
    }
}

