/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.configuration;

import org.hibernate.annotations.common.reflection.ReflectionManager;
import org.hibernate.annotations.common.reflection.java.JavaReflectionManager;
import org.hibernate.search.annotations.DocumentId;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.cfg.spi.SearchConfiguration;
import org.hibernate.search.engine.impl.ConfigContext;
import org.hibernate.search.engine.metadata.impl.AnnotationMetadataProvider;
import org.hibernate.search.exception.SearchException;
import org.hibernate.search.spi.BuildContext;
import org.hibernate.search.testsupport.setup.BuildContextForTest;
import org.hibernate.search.testsupport.setup.SearchConfigurationForTest;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TypeMetadataTest {
    private AnnotationMetadataProvider metadataProvider;

    @Before
    public void setUp() {
        SearchConfigurationForTest searchConfiguration = new SearchConfigurationForTest();
        ConfigContext configContext = new ConfigContext((SearchConfiguration)searchConfiguration, (BuildContext)new BuildContextForTest(searchConfiguration));
        this.metadataProvider = new AnnotationMetadataProvider((ReflectionManager)new JavaReflectionManager(), configContext);
    }

    @Test
    public void testMultipleDocumentIdsCauseException() {
        try {
            this.metadataProvider.getTypeMetadataFor(Foo.class);
            Assert.fail((String)"An exception should have been thrown");
        }
        catch (SearchException e) {
            Assert.assertEquals((Object)"HSEARCH000167: More than one @DocumentId specified on entity 'org.hibernate.search.test.configuration.TypeMetadataTest$Foo'", (Object)e.getMessage());
        }
    }

    @Indexed
    public class Foo {
        @DocumentId
        private Integer id;
        @DocumentId
        private String name;

        public Integer getId() {
            return this.id;
        }

        public void setId(Integer id) {
            this.id = id;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }
    }
}

