/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.query.engine.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.hibernate.search.engine.metadata.impl.SortableFieldMetadata;

public class SortConfigurations
implements Iterable<SortConfiguration> {
    private final List<SortConfiguration> configurations;

    public String toString() {
        return this.configurations.toString();
    }

    private SortConfigurations(List<SortConfiguration> configurations) {
        this.configurations = Collections.unmodifiableList(configurations);
    }

    @Override
    public Iterator<SortConfiguration> iterator() {
        return this.configurations.iterator();
    }

    public static class Builder {
        private final Map<String, Map<Class<?>, List<SortableFieldMetadata>>> builtConfigurations = new HashMap();
        private Map<Class<?>, List<SortableFieldMetadata>> currentIndexBucket;
        private List<SortableFieldMetadata> currentEntityTypeBucket;

        public Builder setIndex(String indexName) {
            this.currentIndexBucket = this.builtConfigurations.get(indexName);
            if (this.currentIndexBucket == null) {
                this.currentIndexBucket = new HashMap();
                this.builtConfigurations.put(indexName, this.currentIndexBucket);
            }
            return this;
        }

        public Builder setEntityType(Class<?> entityType) {
            this.currentEntityTypeBucket = this.currentIndexBucket.get(entityType);
            if (this.currentEntityTypeBucket == null) {
                this.currentEntityTypeBucket = new ArrayList<SortableFieldMetadata>();
                this.currentIndexBucket.put(entityType, this.currentEntityTypeBucket);
            }
            return this;
        }

        public Builder addSortableFields(Collection<SortableFieldMetadata> sortableFieldMetadata) {
            this.currentEntityTypeBucket.addAll(sortableFieldMetadata);
            return this;
        }

        public SortConfigurations build() {
            ArrayList<SortConfiguration> configurations = new ArrayList<SortConfiguration>();
            for (Map.Entry<String, Map<Class<?>, List<SortableFieldMetadata>>> configuration : this.builtConfigurations.entrySet()) {
                configurations.add(new SortConfiguration(configuration.getKey(), configuration.getValue()));
            }
            return new SortConfigurations(configurations);
        }
    }

    public static class SortConfiguration {
        private final String indexName;
        private final Map<Class<?>, List<SortableFieldMetadata>> sortableFieldsByType;

        public SortConfiguration(String indexName, Map<Class<?>, List<SortableFieldMetadata>> sortableFieldsByType) {
            this.indexName = indexName;
            this.sortableFieldsByType = sortableFieldsByType;
        }

        public List<String> getUncoveredSorts(Class<?> entityType, Sort sort) {
            ArrayList<String> uncoveredSorts = new ArrayList<String>();
            for (SortField sortField : sort.getSort()) {
                if (sortField.getType() == SortField.Type.DOC && sortField.getType() == SortField.Type.SCORE) continue;
                boolean isConfigured = false;
                for (SortableFieldMetadata sortFieldMetadata : this.sortableFieldsByType.get(entityType)) {
                    if (!sortFieldMetadata.getFieldName().equals(sortField.getField())) continue;
                    isConfigured = true;
                    break;
                }
                if (isConfigured) continue;
                uncoveredSorts.add(sortField.getField());
            }
            return uncoveredSorts;
        }

        public Set<Class<?>> getEntityTypes() {
            return this.sortableFieldsByType.keySet();
        }

        public String getIndexName() {
            return this.indexName;
        }

        public String toString() {
            return "SortConfiguration [indexName=" + this.indexName + ", sortableFieldsByType=" + this.sortableFieldsByType + "]";
        }
    }
}

