/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.bridge.builtin;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Date;
import org.apache.lucene.search.Query;
import org.hibernate.search.annotations.Analyze;
import org.hibernate.search.annotations.DocumentId;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.FieldBridge;
import org.hibernate.search.annotations.Index;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.Parameter;
import org.hibernate.search.annotations.Store;
import org.hibernate.search.backend.TransactionContext;
import org.hibernate.search.backend.spi.Work;
import org.hibernate.search.backend.spi.WorkType;
import org.hibernate.search.bridge.builtin.NumericEncodingDateBridge;
import org.hibernate.search.bridge.util.impl.NumericFieldUtils;
import org.hibernate.search.engine.integration.impl.ExtendedSearchIntegrator;
import org.hibernate.search.testsupport.TestForIssue;
import org.hibernate.search.testsupport.junit.SearchFactoryHolder;
import org.hibernate.search.testsupport.setup.TransactionContextForTest;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;

@TestForIssue(jiraKey="HSEARCH-1825")
public class NullEncodingTwoWayFieldBridgeTest {
    @Rule
    public SearchFactoryHolder sfHolder = new SearchFactoryHolder(Sample.class).withProperty("hibernate.search.default_null_token", "-1");

    @Test
    public void testIndexingWithNullEncodingFieldBridge() {
        ExtendedSearchIntegrator searchFactory = this.sfHolder.getSearchFactory();
        Sample entity = new Sample();
        entity.id = 1L;
        entity.description = "null date";
        entity.deletionDate = null;
        Work work = new Work((Object)entity, (Serializable)Long.valueOf(entity.id), WorkType.ADD, false);
        TransactionContextForTest tc = new TransactionContextForTest();
        searchFactory.getWorker().performWork(work, (TransactionContext)tc);
        tc.end();
        Query termQuery = NumericFieldUtils.createExactMatchQuery((String)"deletionDate", (Object)Long.parseLong("-1"));
        int queryResultSize = searchFactory.createHSQuery().targetedEntities(Arrays.asList(Sample.class)).luceneQuery(termQuery).queryResultSize();
        Assert.assertEquals((long)1L, (long)queryResultSize);
    }

    @Indexed
    static class Sample {
        @DocumentId
        long id;
        @Field
        String description;
        @Field(store=Store.YES, index=Index.YES, analyze=Analyze.NO, indexNullAs="__DEFAULT_NULL_TOKEN__", bridge=@FieldBridge(impl=NumericEncodingDateBridge.class, params={@Parameter(name="resolution", value="MINUTE")}))
        private Date deletionDate;

        Sample() {
        }
    }
}

