/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.metadata;

import org.hibernate.annotations.common.reflection.ReflectionManager;
import org.hibernate.annotations.common.reflection.java.JavaReflectionManager;
import org.hibernate.search.cfg.spi.SearchConfiguration;
import org.hibernate.search.engine.impl.ConfigContext;
import org.hibernate.search.engine.metadata.impl.AnnotationMetadataProvider;
import org.hibernate.search.engine.metadata.impl.EmbeddedTypeMetadata;
import org.hibernate.search.engine.metadata.impl.TypeMetadata;
import org.hibernate.search.indexes.spi.IndexManagerType;
import org.hibernate.search.indexes.spi.LuceneEmbeddedIndexManagerType;
import org.hibernate.search.spi.BuildContext;
import org.hibernate.search.test.metadata.IndexedEmbeddedTestEntity;
import org.hibernate.search.testsupport.TestForIssue;
import org.hibernate.search.testsupport.setup.BuildContextForTest;
import org.hibernate.search.testsupport.setup.SearchConfigurationForTest;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@TestForIssue(jiraKey="HSEARCH-1442")
public class IndexedEmbeddedWithDepthAndIncludePathTest {
    private AnnotationMetadataProvider metadataProvider;

    @Before
    public void setUp() {
        SearchConfigurationForTest searchConfiguration = new SearchConfigurationForTest();
        ConfigContext configContext = new ConfigContext((SearchConfiguration)searchConfiguration, (BuildContext)new BuildContextForTest(searchConfiguration));
        this.metadataProvider = new AnnotationMetadataProvider((ReflectionManager)new JavaReflectionManager(), configContext);
    }

    @Test
    public void testDepthIsProperlyHandled() {
        TypeMetadata rootTypeMetadata = this.metadataProvider.getTypeMetadataFor(IndexedEmbeddedTestEntity.class, (IndexManagerType)LuceneEmbeddedIndexManagerType.INSTANCE);
        EmbeddedTypeMetadata embeddedWithDepthTypeMetadata = null;
        for (EmbeddedTypeMetadata typeMetadata : rootTypeMetadata.getEmbeddedTypeMetadata()) {
            if (!"indexedEmbeddedWithDepth".equals(typeMetadata.getEmbeddedFieldName())) continue;
            embeddedWithDepthTypeMetadata = typeMetadata;
        }
        Assert.assertNotNull(embeddedWithDepthTypeMetadata);
        Assert.assertNotNull((Object)embeddedWithDepthTypeMetadata.getPropertyMetadataForProperty("name"));
    }
}

