/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.metadata;

import java.util.Arrays;
import java.util.List;
import org.hibernate.search.engine.metadata.impl.AnnotationMetadataProvider;
import org.hibernate.search.engine.metadata.impl.TypeMetadata;
import org.hibernate.search.indexes.spi.IndexManager;
import org.hibernate.search.indexes.spi.IndexManagerType;
import org.hibernate.search.indexes.spi.LuceneEmbeddedIndexManagerType;
import org.hibernate.search.metadata.IndexedTypeDescriptor;
import org.hibernate.search.metadata.impl.IndexedTypeDescriptorImpl;
import org.hibernate.search.test.metadata.DummyIndexManager;

public final class DescriptorTestHelper {
    public static final List<String> TEST_INDEX_NAMES = Arrays.asList("index-0", "index-0", "index-0");

    private DescriptorTestHelper() {
    }

    public static IndexedTypeDescriptor getTypeDescriptor(AnnotationMetadataProvider metadataProvider, Class<?> clazz) {
        TypeMetadata typeMetadata = metadataProvider.getTypeMetadataFor(clazz, (IndexManagerType)LuceneEmbeddedIndexManagerType.INSTANCE);
        return new IndexedTypeDescriptorImpl(typeMetadata, DescriptorTestHelper.getDummyUnShardedIndexManager());
    }

    public static IndexManager[] getDummyUnShardedIndexManager() {
        IndexManager[] managers = new IndexManager[]{new DummyIndexManager(TEST_INDEX_NAMES.get(0))};
        return managers;
    }

    public static IndexManager[] getDummyShardedIndexManager() {
        IndexManager[] managers = new IndexManager[3];
        int i = 0;
        for (String indexName : TEST_INDEX_NAMES) {
            managers[i] = new DummyIndexManager(indexName);
            ++i;
        }
        return managers;
    }
}

