/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.bridge;

import java.io.Serializable;
import java.util.List;
import org.apache.lucene.search.Query;
import org.hibernate.search.backend.TransactionContext;
import org.hibernate.search.backend.spi.Work;
import org.hibernate.search.backend.spi.WorkType;
import org.hibernate.search.engine.integration.impl.ExtendedSearchIntegrator;
import org.hibernate.search.query.dsl.QueryBuilder;
import org.hibernate.search.query.engine.spi.EntityInfo;
import org.hibernate.search.test.bridge.DynamicIndexedValueHolder;
import org.hibernate.search.testsupport.junit.ElasticsearchSupportInProgress;
import org.hibernate.search.testsupport.junit.SearchFactoryHolder;
import org.hibernate.search.testsupport.setup.TransactionContextForTest;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

public class PropertiesExampleBridgeTest {
    @Rule
    public SearchFactoryHolder sfHolder = new SearchFactoryHolder(DynamicIndexedValueHolder.class);

    @Test
    @Category(value={ElasticsearchSupportInProgress.class})
    public void testPropertiesIndexing() {
        ExtendedSearchIntegrator searchFactory = this.sfHolder.getSearchFactory();
        Assert.assertNotNull((Object)searchFactory.getIndexManagerHolder().getIndexManager("all"));
        DynamicIndexedValueHolder holder = new DynamicIndexedValueHolder("1").property("age", "227").property("name", "Thorin").property("surname", "Oakenshield").property("race", "dwarf");
        Work work = new Work((Object)holder, (Serializable)((Object)holder.id), WorkType.ADD, false);
        TransactionContextForTest tc = new TransactionContextForTest();
        searchFactory.getWorker().performWork(work, (TransactionContext)tc);
        tc.end();
        QueryBuilder guestQueryBuilder = searchFactory.buildQueryBuilder().forEntity(DynamicIndexedValueHolder.class).get();
        Query queryAllGuests = guestQueryBuilder.all().createQuery();
        List queryEntityInfos = searchFactory.createHSQuery(queryAllGuests, new Class[]{DynamicIndexedValueHolder.class}).projection(new String[]{"value.surname"}).queryEntityInfos();
        Assert.assertEquals((long)1L, (long)queryEntityInfos.size());
        EntityInfo entityInfo = (EntityInfo)queryEntityInfos.get(0);
        Assert.assertEquals((Object)"Oakenshield", (Object)entityInfo.getProjection()[0]);
    }
}

